/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.portlet.CmsPortletController;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.module.SimpleModule;
import org.jboss.portal.security.impl.jacc.JACCPortalPrincipal;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Group;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.GroupService;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.services.procedure.portlet.command.ListProcedureInstancesByQueryCommand;
import org.osivia.services.procedure.portlet.drools.DatasInjection;
import org.osivia.services.procedure.portlet.model.Action;
import org.osivia.services.procedure.portlet.model.AddField;
import org.osivia.services.procedure.portlet.model.Column;
import org.osivia.services.procedure.portlet.model.Dashboard;
import org.osivia.services.procedure.portlet.model.DocumentTypeEnum;
import org.osivia.services.procedure.portlet.model.Field;
import org.osivia.services.procedure.portlet.model.Filter;
import org.osivia.services.procedure.portlet.model.Form;
import org.osivia.services.procedure.portlet.model.ProcedureInstance;
import org.osivia.services.procedure.portlet.model.ProcedureModel;
import org.osivia.services.procedure.portlet.model.ProcedureObject;
import org.osivia.services.procedure.portlet.model.ProcedureRepository;
import org.osivia.services.procedure.portlet.model.ProcedureUploadedFile;
import org.osivia.services.procedure.portlet.model.ProcedureUploadedFileMetadata;
import org.osivia.services.procedure.portlet.model.Record;
import org.osivia.services.procedure.portlet.model.Step;
import org.osivia.services.procedure.portlet.model.Variable;
import org.osivia.services.procedure.portlet.model.VariableTypesAllEnum;
import org.osivia.services.procedure.portlet.model.WebIdException;
import org.osivia.services.procedure.portlet.service.IProcedureService;
import org.osivia.services.procedure.portlet.service.impl.ProcedureServiceImpl;
import org.osivia.services.procedure.portlet.util.ProcedureUtils;
import org.osivia.services.procedure.portlet.util.VariableTypesEnumJsonSerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@SessionAttributes(value={"form"})
@RequestMapping(value={"VIEW"})
public class ProcedurePortletController
extends CmsPortletController {
    private static final Log logger = LogFactory.getLog(ProcedurePortletController.class);
    private static final String CREATE_VIEW = "editProcedure";
    private static final String EDIT_VIEW = "editStep";
    private static final String EDIT_RECORD_VIEW = "editRecord";
    private static final String DISPLAY_RECORD_VIEW = "displayRecord";
    private static final String EDIT_TDB = "editTdb";
    private static final String VIEW_PROCEDURE = "viewProcedure";
    private static final String VIEW_ENDSTEP = "endStep";
    private static final String VIEW_ACTION = "editAction";
    private static final String LIST_PROC_VIEW = "list";
    private static final String DETAIL_PROC = "detailProc";
    private static final String MANAGE_VIEW = "manageVariables";
    private static final String DASHBOARD_VIEW = "procedureDashboard";
    private static final String VIEW_ERROR = "error";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private IProcedureService procedureService;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;
    @Autowired
    private GroupService groupService;
    private static final String VAR__RQST_USR = "${user}";

    private boolean checkTaskdocRight(NuxeoController nuxeoController, ProcedureModel procedureModel, ProcedureInstance procedureInstance, String userId, String displayContext) {
        PropertyList actors = procedureInstance.getTaskDoc().getList("nt:actors");
        HashSet<Name> names = new HashSet<Name>(actors.size());
        if (!actors.isEmpty()) {
            for (int i = 0; i < actors.size(); ++i) {
                String actor = actors.getString(i);
                Group group = StringUtils.startsWith((String)actor, (String)"user:") ? null : (StringUtils.startsWith((String)actor, (String)"group:") ? this.groupService.get(StringUtils.removeStart((String)actor, (String)"group:")) : this.groupService.get(actor));
                if (group == null) {
                    String user = StringUtils.removeStart((String)actor, (String)"user:");
                    names.add(this.personService.getEmptyPerson().buildDn(user));
                    continue;
                }
                for (Name member : group.getMembers()) {
                    names.add(member);
                }
            }
        }
        for (Name name : names) {
            Person person = this.personService.getPerson(name);
            if (!person.getUid().equals(userId)) continue;
            return true;
        }
        List dashboardsList = procedureModel.getDashboards();
        for (Dashboard dashboard : dashboardsList) {
            ListProcedureInstancesByQueryCommand command;
            Documents documents;
            List groups;
            boolean userAccess = false;
            for (Column column : dashboard.getColumns()) {
                if (!column.isEnableLink()) continue;
                userAccess = true;
            }
            if (!userAccess || !this.isAuthorized(groups = dashboard.getGroups())) continue;
            StringBuilder requestSb = new StringBuilder();
            requestSb.append("ecm:primaryType = 'ProcedureInstance' ");
            requestSb.append(" AND ttc:webid = '" + procedureInstance.getOriginalDocument().getProperties().getString("ttc:webid") + "' ");
            requestSb.append(" AND (pi:procedureModelWebId = '" + procedureModel.getCurrentWebId() + "') ");
            String requestFilter = dashboard.getRequestFilter();
            if (StringUtils.isNotEmpty((String)requestFilter)) {
                requestSb.append(" AND (" + this.parseRequest(requestFilter, userId) + ")");
            }
            if ((documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)(command = new ListProcedureInstancesByQueryCommand(requestSb.toString())))).size() != 1) continue;
            return true;
        }
        return false;
    }

    private String parseRequest(String request, String user) {
        request = StringUtils.replace((String)request, (String)VAR__RQST_USR, (String)user);
        return request;
    }

    private boolean isAuthorized(List<String> groups) {
        if (groups == null || groups.isEmpty() || groups.contains("members")) {
            return true;
        }
        Subject subject = null;
        try {
            subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        }
        catch (PolicyContextException policyContextException) {
            // empty catch block
        }
        if (subject != null) {
            JACCPortalPrincipal pp = new JACCPortalPrincipal(subject);
            for (Principal principal : pp.getRoles()) {
                String groupName = principal.getName();
                for (String groupO : groups) {
                    String group = groupO;
                    if (!StringUtils.equals((String)groupName, (String)group)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @RenderMapping
    public String defaultView(RenderRequest request, RenderResponse response, @ModelAttribute(value="form") Form form, @ModelAttribute(value="addProcedureUrl") String addProcedureUrl, @ModelAttribute(value="procedureList") List<ProcedureModel> procedureModels) throws PortletException, CMSException {
        if (StringUtils.isNotBlank((String)((String)request.getAttribute("errorText")))) {
            request.setAttribute("errorText", request.getAttribute("errorText"));
            return VIEW_ERROR;
        }
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.defaultRenderAction(nuxeoController);
        if (StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.RECORDFOLDER.getDocType())) {
            if (StringUtils.equals((String)this.getAction((PortletRequest)request), (String)"adminrecord")) {
                return EDIT_RECORD_VIEW;
            }
            if (this.getWebId((PortletRequest)request) != null) {
                return VIEW_PROCEDURE;
            }
            if (StringUtils.isBlank((String)addProcedureUrl)) {
                boolean hide = true;
                if (procedureModels != null) {
                    Iterator<ProcedureModel> procedureModelsI = procedureModels.iterator();
                    while (hide && procedureModelsI.hasNext()) {
                        ProcedureModel procedureModel = procedureModelsI.next();
                        if (!StringUtils.isNotBlank((String)procedureModel.getUrl())) continue;
                        hide = false;
                    }
                }
                if (hide) {
                    request.setAttribute("osivia.emptyResponse", (Object)"1");
                }
            }
            return LIST_PROC_VIEW;
        }
        if (StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.RECORD.getDocType())) {
            if (StringUtils.isNotBlank((String)this.getAction((PortletRequest)request))) {
                return VIEW_PROCEDURE;
            }
            return DISPLAY_RECORD_VIEW;
        }
        if (StringUtils.isBlank((String)this.getDocType((PortletRequest)request)) && StringUtils.isNotBlank((String)this.getDashboardPath((PortletRequest)request))) {
            return DASHBOARD_VIEW;
        }
        if (StringUtils.equals((String)this.getAction((PortletRequest)request), (String)"adminproc")) {
            this.validateModel(form, nuxeoController);
            return CREATE_VIEW;
        }
        if (StringUtils.equals((String)this.getAction((PortletRequest)request), (String)"adminprocstep")) {
            this.validateModel(form, nuxeoController);
            return EDIT_VIEW;
        }
        if (StringUtils.equals((String)this.getAction((PortletRequest)request), (String)"detailproc")) {
            return DETAIL_PROC;
        }
        if (this.getWebId((PortletRequest)request) != null || this.getId((PortletRequest)request) != null) {
            return VIEW_PROCEDURE;
        }
        if (StringUtils.isBlank((String)addProcedureUrl)) {
            boolean hide = true;
            if (procedureModels != null) {
                Iterator<ProcedureModel> procedureModelsI = procedureModels.iterator();
                while (hide && procedureModelsI.hasNext()) {
                    ProcedureModel procedureModel = procedureModelsI.next();
                    if (!StringUtils.isNotBlank((String)procedureModel.getUrl())) continue;
                    hide = false;
                }
            }
            if (hide) {
                request.setAttribute("osivia.emptyResponse", (Object)"1");
            }
        }
        return LIST_PROC_VIEW;
    }

    @RenderMapping(params={"action=editProcedure"})
    public String editProcedureView(RenderRequest request, RenderResponse response, @ModelAttribute(value="form") Form form) throws PortletException, CMSException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.validateModel(form, nuxeoController);
        return CREATE_VIEW;
    }

    @RenderMapping(params={"action=editStep"})
    public String editStepView(RenderRequest request, RenderResponse response, @ModelAttribute(value="form") Form form) throws PortletException, CMSException {
        request.setAttribute("activeTab", (Object)request.getParameter("activeTab"));
        request.setAttribute("activeFormTab", (Object)request.getParameter("activeFormTab"));
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        if (StringUtils.isBlank((String)request.getParameter("activeTab")) && StringUtils.isNotBlank((String)form.getProcedureModel().getCurrentWebId())) {
            this.validateStep(form, nuxeoController);
        }
        return EDIT_VIEW;
    }

    @RenderMapping(params={"action=editTdb"})
    public String editTdbView(RenderRequest request, RenderResponse response, @ModelAttribute(value="form") Form form) throws PortletException, CMSException {
        return EDIT_TDB;
    }

    @RenderMapping(params={"action=editRecord"})
    public String editRecordView(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        request.setAttribute("activeTab", (Object)request.getParameter("activeTab"));
        request.setAttribute("activeFormTab", (Object)request.getParameter("activeFormTab"));
        return EDIT_RECORD_VIEW;
    }

    @RenderMapping(params={"action=editAction"})
    public String endStepView(RenderRequest request, RenderResponse response, @RequestParam(value="editAction", required=false) String editAction) throws PortletException, CMSException {
        request.setAttribute("activeTab", (Object)request.getParameter("activeTab"));
        return VIEW_ACTION;
    }

    @RenderMapping(params={"action=viewProcedure"})
    public String viewProcedure(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        return VIEW_PROCEDURE;
    }

    @RenderMapping(params={"action=manageVariables"})
    public String viewManageVariables(RenderRequest request, RenderResponse response, @ModelAttribute(value="form") Form form) throws PortletException, CMSException {
        return MANAGE_VIEW;
    }

    @RenderMapping(params={"action=endStep"})
    public String endStepView(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        String closeUrl = this.procedureService.getCloseUrl(portalControllerContext);
        request.setAttribute("closeUrl", (Object)closeUrl);
        return VIEW_ENDSTEP;
    }

    @RenderMapping(params={"action=error"})
    public String errorView(RenderRequest request, RenderResponse response) {
        request.setAttribute("errorText", (Object)request.getParameter("errorText"));
        return VIEW_ERROR;
    }

    private void defaultRenderAction(NuxeoController nuxeoController) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        String dashboardPath = this.getDashboardPath(nuxeoController.getRequest());
        if (StringUtils.isNotBlank((String)nuxeoPath)) {
            nuxeoPath = nuxeoController.getComputedPath(nuxeoPath);
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(nuxeoPath);
            Document document = documentContext.getDocument();
            nuxeoController.setCurrentDoc(document);
            nuxeoController.insertContentMenuBarItems();
        } else if (StringUtils.isNotBlank((String)dashboardPath)) {
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(dashboardPath);
            Document document = documentContext.getDocument();
            nuxeoController.setCurrentDoc(document);
            nuxeoController.insertContentMenuBarItems();
        }
    }

    @ModelAttribute(value="form")
    public Form getForm(PortletRequest request, PortletResponse response, @RequestParam(value="selectedStep", required=false) String selectedStep) throws PortletException {
        Form form;
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        if (StringUtils.isNotEmpty((String)this.getWebId(request)) && StringUtils.equals((String)this.getDocType(request), (String)DocumentTypeEnum.PROCEDUREMODEL.getDocType())) {
            ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, this.getWebId(request));
            form = new Form(procedureModel);
            form.setSelectedStep(StringUtils.defaultIfBlank((String)selectedStep, (String)"0"));
            if (!StringUtils.equals((String)this.getAction(request), (String)"adminproc") && !StringUtils.equals((String)this.getAction(request), (String)"adminprocstep")) {
                try {
                    HashMap<String, String> variables;
                    PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                    String jsonVariables = window.getProperty("osivia.services.procedure.variables");
                    if (StringUtils.isEmpty((String)jsonVariables)) {
                        variables = null;
                    } else {
                        try {
                            JSONObject jsonObject = JSONObject.fromObject((Object)jsonVariables);
                            variables = new HashMap<String, String>(jsonObject.size());
                            for (Object object : jsonObject.keySet()) {
                                String key = (String)object;
                                variables.put(key, jsonObject.getString(key));
                            }
                        }
                        catch (JSONException e) {
                            variables = null;
                        }
                    }
                    Map initVariables = nuxeoController.getNuxeoCMSService().getFormsService().init(nuxeoController.getPortalCtx(), procedureModel.getOriginalDocument(), variables);
                    ProcedureInstance procedureInstance = new ProcedureInstance(initVariables);
                    procedureInstance.setCurrentStep(form.getProcedureModel().getStartingStep());
                    form.setProcedureInstance(procedureInstance);
                }
                catch (PortalException e) {
                    if (StringUtils.isNotBlank((String)e.getMessage())) {
                        request.setAttribute("errorText", (Object)e.getMessage());
                    }
                    throw new PortletException((Throwable)e);
                }
                catch (FormFilterException e) {
                    this.addNotification(nuxeoController.getPortalCtx(), e.getMessage(), NotificationsType.ERROR, new Object[0]);
                }
            }
            if (!StringUtils.equals((String)this.getAction(request), (String)"adminproc") && !StringUtils.equals((String)this.getAction(request), (String)"adminprocstep")) {
                this.procedureService.updateData(nuxeoController, form);
            }
            Map recordTypes = this.procedureService.getRecordTypes(portalControllerContext);
            form.setRecordTypes(recordTypes);
        } else if (StringUtils.isNotEmpty((String)this.getWebId(request)) && StringUtils.equals((String)this.getDocType(request), (String)DocumentTypeEnum.PROCEDUREINSTANCE.getDocType())) {
            ProcedureInstance procedureInstance = this.procedureService.retrieveProcedureInstanceByWebId(nuxeoController, this.getWebId(request));
            nuxeoController.setCurrentDoc(procedureInstance.getOriginalDocument());
            ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, procedureInstance.getProcedureModelWebId());
            if (!this.checkTaskdocRight(nuxeoController, procedureModel, procedureInstance, portalControllerContext.getHttpServletRequest().getRemoteUser(), portalControllerContext.getHttpServletRequest().getParameter("displayContext"))) {
                form = new Form();
                request.setAttribute("errorText", (Object)"Acc\u00e8s interdit");
            } else {
                form = new Form(procedureModel, procedureInstance);
                this.procedureService.updateData(nuxeoController, form);
            }
        } else if (StringUtils.isNotEmpty((String)this.getId(request)) && StringUtils.equals((String)this.getDocType(request), (String)DocumentTypeEnum.TASKDOC.getDocType())) {
            ProcedureInstance procedureInstance = this.procedureService.retrieveProcedureInstanceById(nuxeoController, this.getId(request));
            nuxeoController.setCurrentDoc(procedureInstance.getOriginalDocument());
            ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, procedureInstance.getProcedureModelWebId());
            form = new Form(procedureModel, procedureInstance);
            try {
                Map initVariables = nuxeoController.getNuxeoCMSService().getFormsService().init(nuxeoController.getPortalCtx(), procedureInstance.getOriginalDocument(), null);
                procedureInstance.getGlobalVariablesValues().putAll(initVariables);
            }
            catch (PortalException e) {
                if (StringUtils.isNotBlank((String)e.getMessage())) {
                    request.setAttribute("errorText", (Object)e.getMessage());
                }
                throw new PortletException((Throwable)e);
            }
            catch (FormFilterException e) {
                this.addNotification(nuxeoController.getPortalCtx(), e.getMessage(), NotificationsType.ERROR, new Object[0]);
            }
            this.procedureService.updateData(nuxeoController, form);
        } else if (StringUtils.isNotEmpty((String)this.getWebId(request)) && StringUtils.equals((String)this.getDocType(request), (String)DocumentTypeEnum.RECORDFOLDER.getDocType())) {
            if (StringUtils.equals((String)this.getAction(request), (String)"adminrecord")) {
                ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, this.getWebId(request));
                form = new Form(procedureModel);
                Map recordTypes = this.procedureService.getRecordTypes(portalControllerContext);
                form.setRecordTypes(recordTypes);
            } else {
                ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, this.getWebId(request));
                form = new Form(procedureModel);
                try {
                    HashMap<String, String> variables = new HashMap<String, String>();
                    variables.put("pcd:startingStep", this.getAction(request));
                    Map initVariables = nuxeoController.getNuxeoCMSService().getFormsService().init(nuxeoController.getPortalCtx(), procedureModel.getOriginalDocument(), variables);
                    form.getProcedureModel().setStartingStep((String)initVariables.get("pcd:startingStep"));
                    form.setProcedureInstance(new ProcedureInstance(initVariables));
                }
                catch (PortalException e) {
                    if (StringUtils.isNotBlank((String)e.getMessage())) {
                        request.setAttribute("errorText", (Object)e.getMessage());
                    }
                    throw new PortletException((Throwable)e);
                }
                catch (FormFilterException e) {
                    this.addNotification(nuxeoController.getPortalCtx(), e.getMessage(), NotificationsType.ERROR, new Object[0]);
                }
                this.procedureService.updateData(nuxeoController, form);
            }
        } else if (StringUtils.isNotEmpty((String)this.getWebId(request)) && StringUtils.equals((String)this.getDocType(request), (String)DocumentTypeEnum.RECORD.getDocType())) {
            Record record = this.procedureService.retrieveRecordInstanceByWebId(nuxeoController, this.getWebId(request));
            nuxeoController.setCurrentDoc(record.getOriginalDocument());
            ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, record.getProcedureModelWebId());
            form = new Form(procedureModel, record);
            Map globalVariablesValues = record.getGlobalVariablesValues();
            if (StringUtils.isNotBlank((String)this.getAction(request))) {
                try {
                    HashMap<String, String> variables = new HashMap<String, String>();
                    variables.put("pcd:startingStep", this.getAction(request));
                    variables.put("rcdPath", record.getOriginalDocument().getPath());
                    variables.put("rcdFolderPath", procedureModel.getOriginalDocument().getPath());
                    variables.putAll(globalVariablesValues);
                    Map initVariables = nuxeoController.getNuxeoCMSService().getFormsService().init(nuxeoController.getPortalCtx(), procedureModel.getOriginalDocument(), variables);
                    form.getProcedureModel().setStartingStep((String)initVariables.get("pcd:startingStep"));
                    form.setProcedureInstance(new ProcedureInstance(initVariables));
                    globalVariablesValues = form.getProcedureInstance().getGlobalVariablesValues();
                }
                catch (PortalException e) {
                    if (StringUtils.isNotBlank((String)e.getMessage())) {
                        request.setAttribute("errorText", (Object)e.getMessage());
                    }
                    throw new PortletException((Throwable)e);
                }
                catch (FormFilterException e) {
                    this.addNotification(nuxeoController.getPortalCtx(), e.getMessage(), NotificationsType.ERROR, new Object[0]);
                }
            }
            this.procedureService.updateData(nuxeoController, form);
            try {
                if (!StringUtils.isEmpty((String)procedureModel.getRules())) {
                    new DatasInjection().shouldFire(form.getProcedureModel(), globalVariablesValues, "prepare");
                }
            }
            catch (FormFilterException e) {
                this.notificationsService.addSimpleNotification(new PortalControllerContext(this.portletContext, request, response), e.getMessage(), NotificationsType.ERROR);
                request.setAttribute("filterMessage", (Object)e.getMessage());
            }
        } else if (StringUtils.isNotBlank((String)this.getDashboardPath(request))) {
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(this.getDashboardPath(request));
            form = new Form(new ProcedureModel(documentContext.getDocument(), nuxeoController));
        } else if (StringUtils.equals((String)this.getAction(request), (String)"adminproc")) {
            form = new Form();
            Map recordTypes = this.procedureService.getRecordTypes(portalControllerContext);
            form.setRecordTypes(recordTypes);
        } else if (StringUtils.equals((String)this.getAction(request), (String)"adminrecord")) {
            form = new Form(ProcedureRepository.recordFolder());
            Map recordTypes = this.procedureService.getRecordTypes(portalControllerContext);
            form.setRecordTypes(recordTypes);
        } else {
            form = new Form();
        }
        if (response instanceof RenderResponse && form.getProcedureModel() != null) {
            ((RenderResponse)response).setTitle(form.getProcedureModel().getName());
        }
        return form;
    }

    private void validateModel(Form form, NuxeoController nuxeoController) {
        ProcedureModel procedureModel = form.getProcedureModel();
        if (procedureModel != null) {
            List steps = procedureModel.getSteps();
            if (steps == null || steps.size() == 0) {
                this.addNotification(nuxeoController.getPortalCtx(), "WARNING_NO_STEPS", NotificationsType.WARNING, new Object[0]);
            } else {
                for (Step step : steps) {
                    String stepName = StringUtils.defaultIfBlank((String)step.getStepName(), (String)step.getReference());
                    if (!StringUtils.isNotBlank((String)stepName)) continue;
                    List actions = step.getActions();
                    if (actions == null || actions.size() == 0) {
                        this.addNotification(nuxeoController.getPortalCtx(), "WARNING_STEP_WITHOUT_ACTION", NotificationsType.WARNING, new Object[]{stepName});
                        continue;
                    }
                    for (Action action : actions) {
                        String stepReference = action.getStepReference();
                        if (StringUtils.isBlank((String)stepReference)) {
                            this.addNotification(nuxeoController.getPortalCtx(), "WARNING_ACTION_WITHOUT_STEP", NotificationsType.WARNING, new Object[]{action.getLabel(), stepName});
                            continue;
                        }
                        if (StringUtils.equals((String)stepReference, (String)VIEW_ENDSTEP) || procedureModel.getStepsMap().get(stepReference) != null) continue;
                        this.addNotification(nuxeoController.getPortalCtx(), "WARNING_ACTION_WRONG_STEP", NotificationsType.WARNING, new Object[]{action.getLabel(), stepName});
                    }
                }
            }
            if (StringUtils.isBlank((String)procedureModel.getStartingStep())) {
                this.addNotification(nuxeoController.getPortalCtx(), "WARNING_NO_STARTING_STEP", NotificationsType.WARNING, new Object[0]);
            } else if (procedureModel.getStepsMap().get(procedureModel.getStartingStep()) == null) {
                this.addNotification(nuxeoController.getPortalCtx(), "WARNING_WRONG_STARTING_STEP", NotificationsType.WARNING, new Object[0]);
            }
        }
    }

    private void validateStep(Form form, NuxeoController nuxeoController) {
        ProcedureModel procedureModel = form.getProcedureModel();
        if (procedureModel != null && CollectionUtils.isNotEmpty((Collection)procedureModel.getSteps())) {
            List actions = form.getTheSelectedStep().getActions();
            if (CollectionUtils.isEmpty((Collection)actions)) {
                this.addNotification(nuxeoController.getPortalCtx(), "WARNING_THIS_STEP_WITHOUT_ACTION", NotificationsType.WARNING, new Object[0]);
            } else {
                for (Action action : actions) {
                    String stepReference = action.getStepReference();
                    if (StringUtils.isBlank((String)stepReference)) {
                        this.addNotification(nuxeoController.getPortalCtx(), "WARNING_THIS_STEP_ACTION_WITHOUT_STEP", NotificationsType.WARNING, new Object[]{action.getLabel()});
                        continue;
                    }
                    if (StringUtils.equals((String)stepReference, (String)VIEW_ENDSTEP) || procedureModel.getStepsMap().get(procedureModel.getStartingStep()) != null) continue;
                    this.addNotification(nuxeoController.getPortalCtx(), "WARNING_THIS_STEP_ACTION_WRONG_STEP", NotificationsType.WARNING, new Object[]{action.getLabel()});
                }
            }
        }
    }

    @ModelAttribute(value="procedureList")
    public List<ProcedureModel> getListProcedureModel(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        String procedurePath = this.getProcedurePath(request);
        return procedurePath != null ? this.procedureService.listProcedures(nuxeoController, procedurePath) : null;
    }

    @ModelAttribute(value="editProcedureUrl")
    public String getEditProcedureUrl(PortletRequest request, PortletResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        String editProcedureUrl = null;
        if (form.getProcedureModel() != null && form.getProcedureModel().getOriginalDocument() != null && form.getRecord() == null) {
            try {
                CMSPublicationInfos publicationInfos = NuxeoController.getCMSService().getPublicationInfos(nuxeoController.getCMSCtx(), form.getProcedureModel().getPath());
                if (publicationInfos.isEditableByUser()) {
                    editProcedureUrl = nuxeoController.getLink(form.getProcedureModel().getOriginalDocument(), "adminproc").getUrl();
                }
            }
            catch (CMSException e) {
                throw new PortletException((Throwable)e);
            }
        }
        return editProcedureUrl;
    }

    @ModelAttribute(value="linkProcedureUrl")
    public String getLinkProcedureUrl(PortletRequest request, PortletResponse response, @ModelAttribute(value="form") Form form) {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        return form.getProcedureModel() != null && form.getProcedureModel().getOriginalDocument() != null ? nuxeoController.getLink(form.getProcedureModel().getOriginalDocument()).getUrl() : null;
    }

    @ModelAttribute(value="addProcedureUrl")
    public String getAddProcedureUrl(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        String procedurePath = this.getProcedurePath(request);
        return this.procedureService.getAddUrl(nuxeoController, procedurePath, "adminproc", DocumentTypeEnum.PROCEDUREMODEL.getDocType());
    }

    @ModelAttribute(value="listeFiltres")
    public List<FormFilter> getListeFiltres(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        Map formsFilters = nuxeoController.getNuxeoCMSService().getCMSCustomizer().getFormsFilters();
        ArrayList<FormFilter> listeFiltres = new ArrayList<FormFilter>(formsFilters.size());
        for (Map.Entry entryFilter : formsFilters.entrySet()) {
            listeFiltres.add((FormFilter)entryFilter.getValue());
        }
        return listeFiltres;
    }

    @ModelAttribute(value="webIdPrefix")
    public String getWebIdPrefix(PortletRequest request, PortletResponse response) {
        return "procedure_";
    }

    @ResourceMapping(value="groupSearch")
    public void getProfils(ResourceRequest request, ResourceResponse response, @RequestParam(value="filter", required=false) String filter) throws PortletException {
        Group searchGroup = this.groupService.getEmptyGroup();
        searchGroup.setCn(filter + "*");
        List groups = this.groupService.search(searchGroup);
        ArrayList<Map> listeProfils = new ArrayList<Map>(groups.size());
        for (Group group : groups) {
            listeProfils.add(this.buildProfilEntry(group));
        }
        response.setContentType("application/json");
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(response.getPortletOutputStream(), listeProfils);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private Map<String, String> buildProfilEntry(Group group) {
        HashMap<String, String> superAdministrators = new HashMap<String, String>(2);
        superAdministrators.put("cn", group.getCn());
        superAdministrators.put("displayName", group.getCn());
        return superAdministrators;
    }

    @ResourceMapping(value="stepSearch")
    public void getSteps(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="filter", required=false) String filter, @RequestParam(value="includeEndstep", required=false) Boolean includeEndstep) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        ArrayList listeSteps = new ArrayList();
        List steps = form.getProcedureModel().getSteps();
        for (Step step : steps) {
            if (filter != null && !StringUtils.contains((String)step.getStepName(), (String)filter) && !StringUtils.contains((String)step.getReference(), (String)filter)) continue;
            HashMap<String, String> demoGroup = new HashMap<String, String>(2);
            demoGroup.put("id", step.getReference());
            demoGroup.put("text", step.getStepName());
            listeSteps.add(demoGroup);
        }
        if (BooleanUtils.isTrue((Boolean)includeEndstep)) {
            HashMap<String, String> endStep = new HashMap<String, String>(2);
            endStep.put("id", VIEW_ENDSTEP);
            endStep.put("text", bundle.getString("END_STEP"));
            listeSteps.add(endStep);
        }
        response.setContentType("application/json");
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(response.getPortletOutputStream(), listeSteps);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ResourceMapping(value="fieldSearch")
    public void getFields(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="filter", required=false) String filter, @RequestParam(value="defaultVars", required=false) Boolean defaultVars, @RequestParam(value="includeFieldSet", required=false) Boolean includeFieldSet) throws PortletException {
        ArrayList<Object> listeVar = new ArrayList<Object>();
        if (StringUtils.isNotBlank((String)filter)) {
            boolean exactMatch = false;
            for (Map.Entry entryVar : form.getProcedureModel().getVariables().entrySet()) {
                if (VariableTypesAllEnum.FIELDSET.equals((Object)((Variable)entryVar.getValue()).getType()) && BooleanUtils.isTrue((Boolean)includeFieldSet)) {
                    if (!StringUtils.equalsIgnoreCase((String)((Variable)entryVar.getValue()).getName(), (String)filter)) continue;
                    exactMatch = true;
                    listeVar.add(0, new Variable(ProcedureUtils.buildUniqueVariableName((Map)form.getProcedureModel().getVariables(), (String)filter), null, VariableTypesAllEnum.TEXT, null));
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((String)((Variable)entryVar.getValue()).getName(), (String)filter)) {
                    listeVar.add(0, entryVar.getValue());
                    exactMatch = true;
                    continue;
                }
                if (!StringUtils.containsIgnoreCase((String)((Variable)entryVar.getValue()).getName(), (String)filter) && !StringUtils.containsIgnoreCase((String)((Variable)entryVar.getValue()).getLabel(), (String)filter) || VariableTypesAllEnum.FIELDSET.equals((Object)((Variable)entryVar.getValue()).getType()) || VariableTypesAllEnum.FIELDLIST.equals((Object)((Variable)entryVar.getValue()).getType())) continue;
                listeVar.add(0, entryVar.getValue());
            }
            if (!exactMatch && BooleanUtils.isNotTrue((Boolean)defaultVars)) {
                listeVar.add(0, new Variable(ProcedureUtils.buildUniqueVariableName((Map)form.getProcedureModel().getVariables(), (String)filter), null, VariableTypesAllEnum.TEXT, null));
            }
        } else {
            Collection variables = form.getProcedureModel().getVariables().values();
            if (BooleanUtils.isTrue((Boolean)includeFieldSet)) {
                listeVar.addAll(variables);
            } else {
                for (Variable variable : variables) {
                    if (VariableTypesAllEnum.FIELDSET.equals((Object)variable.getType()) || VariableTypesAllEnum.FIELDLIST.equals((Object)variable.getType())) continue;
                    listeVar.add(variable);
                }
            }
            if (BooleanUtils.isTrue((Boolean)defaultVars)) {
                listeVar.add(Variable.DC_CREATOR);
                listeVar.add(Variable.DC_CREATED);
                listeVar.add(Variable.DC_LAST_CONTRIBUTOR);
                listeVar.add(Variable.DC_MODIFIED);
            }
        }
        Collections.sort(listeVar);
        response.setContentType("application/json");
        try {
            ObjectMapper mapper = new ObjectMapper();
            SimpleModule simpleModule = new SimpleModule("SimpleModule", new Version(1, 0, 0, null));
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            simpleModule.addSerializer(VariableTypesAllEnum.class, (JsonSerializer)new VariableTypesEnumJsonSerializer(bundle));
            mapper.registerModule((Module)simpleModule);
            mapper.writeValue(response.getPortletOutputStream(), listeVar);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ResourceMapping(value="modelSearch")
    public void getModels(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="filter", required=false) String filter) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        ArrayList listeProcedures = new ArrayList();
        List procedureModels = this.procedureService.retrieveProcedureModels(nuxeoController, this.getProcedurePath((PortletRequest)request), filter);
        for (ProcedureModel procedureModel : procedureModels) {
            HashMap<String, String> procedure = new HashMap<String, String>(2);
            procedure.put("id", procedureModel.getCurrentWebId());
            procedure.put("text", procedureModel.getName());
            listeProcedures.add(procedure);
        }
        response.setContentType("application/json");
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(response.getPortletOutputStream(), listeProcedures);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ResourceMapping(value="formulaireSearch")
    public void getFormulaire(ResourceRequest request, ResourceResponse response, @RequestParam(value="filter", required=false) String filter) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        List results = this.procedureService.retrieveStepsByName(nuxeoController, filter);
        response.setContentType("application/json");
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(response.getPortletOutputStream(), (Object)results);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ActionMapping(value="editProcedure", params={"changeMode"})
    public void changeModeProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        form.setAdvancedMode(!form.isAdvancedMode());
        response.setRenderParameter("action", CREATE_VIEW);
    }

    @ActionMapping(value="editStep", params={"changeMode"})
    public void changeModeStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        form.setAdvancedMode(!form.isAdvancedMode());
        response.setRenderParameter("action", EDIT_VIEW);
    }

    @ActionMapping(value="actionProcedure", params={"proceedProcedure"})
    public void proceedProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="actionId") String actionId) throws PortletException {
        if (StringUtils.isNotBlank((String)((String)request.getAttribute("errorText")))) {
            response.setRenderParameter("errorText", (String)request.getAttribute("errorText"));
            response.setRenderParameter("action", VIEW_ERROR);
            return;
        }
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        IFormsService formsService = nuxeoController.getNuxeoCMSService().getFormsService();
        HashMap uploadedFiles = new HashMap(form.getUploadedFiles().size());
        uploadedFiles.putAll(form.getUploadedFiles());
        try {
            Map globalVariablesValues = form.getProcedureInstance().getGlobalVariablesValues();
            if (StringUtils.isNotEmpty((String)this.getWebId((PortletRequest)request)) && StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.PROCEDUREMODEL.getDocType())) {
                String currentWebId = form.getProcedureModel().getCurrentWebId();
                globalVariablesValues = formsService.start(portalControllerContext, currentWebId, actionId, globalVariablesValues, uploadedFiles);
                this.manageEndStep(nuxeoController, globalVariablesValues, form);
            } else if (StringUtils.isNotEmpty((String)this.getWebId((PortletRequest)request)) && StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.PROCEDUREINSTANCE.getDocType())) {
                PropertyMap taskProperties = form.getProcedureInstance().getTaskDoc();
                globalVariablesValues = formsService.proceed(portalControllerContext, taskProperties, actionId, globalVariablesValues, uploadedFiles);
                this.manageEndStep(nuxeoController, globalVariablesValues, form);
            } else if (StringUtils.isNotEmpty((String)this.getId((PortletRequest)request)) && StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.TASKDOC.getDocType())) {
                PropertyMap taskProperties = form.getProcedureInstance().getTaskDoc();
                globalVariablesValues = formsService.proceed(portalControllerContext, taskProperties, actionId, globalVariablesValues, uploadedFiles);
                this.manageEndStep(nuxeoController, globalVariablesValues, form);
            } else if (StringUtils.isNotEmpty((String)this.getWebId((PortletRequest)request)) && StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.RECORDFOLDER.getDocType())) {
                String currentWebId = form.getProcedureModel().getCurrentWebId();
                globalVariablesValues = formsService.start(portalControllerContext, currentWebId, actionId, globalVariablesValues, uploadedFiles);
                this.manageEndStep(nuxeoController, globalVariablesValues, form);
            } else if (StringUtils.isNotEmpty((String)this.getWebId((PortletRequest)request)) && StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.RECORD.getDocType())) {
                String currentWebId = form.getProcedureModel().getCurrentWebId();
                if (!StringUtils.isEmpty((String)form.getProcedureModel().getRules())) {
                    new DatasInjection().shouldFire(form.getProcedureModel(), globalVariablesValues, "validate");
                }
                globalVariablesValues = formsService.start(portalControllerContext, currentWebId, actionId, globalVariablesValues, uploadedFiles);
                this.manageEndStep(nuxeoController, globalVariablesValues, form);
            } else {
                response.setRenderParameter("action", VIEW_PROCEDURE);
            }
        }
        catch (PortalException e) {
            if (StringUtils.isNotBlank((String)e.getMessage())) {
                response.setRenderParameter("errorText", e.getMessage());
                response.setRenderParameter("action", VIEW_ERROR);
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new PortletException((Throwable)e);
        }
        catch (FormFilterException e) {
            this.notificationsService.addSimpleNotification(portalControllerContext, e.getMessage(), NotificationsType.ERROR);
            request.setAttribute("filterMessage", (Object)e.getMessage());
            response.setRenderParameter("action", VIEW_PROCEDURE);
        }
    }

    private void manageEndStep(NuxeoController nuxeoController, Map<String, String> globalVariablesValues, Form form) throws PortletException {
        ActionResponse response = (ActionResponse)nuxeoController.getResponse();
        String cmsPath = globalVariablesValues.get("_redirectCmsPath");
        String displayContext = globalVariablesValues.get("_displayContext");
        if (StringUtils.isNotBlank((String)cmsPath)) {
            String notificationMessage;
            String redirectUrl = nuxeoController.getPortalUrlFactory().getCMSUrl(nuxeoController.getPortalCtx(), null, cmsPath, new HashMap(), null, displayContext, nuxeoController.getHideMetaDatas(), nuxeoController.getScope(), nuxeoController.getDisplayLiveVersion(), null);
            try {
                response.sendRedirect(redirectUrl);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
            String string = notificationMessage = StringUtils.isNotBlank((String)globalVariablesValues.get("_notificationMessage")) ? globalVariablesValues.get("_notificationMessage") : form.getTheCurrentStep().getStringMsg();
            if (StringUtils.isNotBlank((String)notificationMessage)) {
                this.notificationsService.addSimpleNotification(nuxeoController.getPortalCtx(), notificationMessage, NotificationsType.SUCCESS);
            }
        } else {
            response.setRenderParameter("action", VIEW_ENDSTEP);
        }
    }

    @ActionMapping(value="editProcedure", params={"saveProcedure"})
    public void saveProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        try {
            if (StringUtils.isNotBlank((String)form.getProcedureModel().getName())) {
                this.addAllFieldsToSet(form);
                this.addAllFiltersToSet(form);
                if (StringUtils.isNotEmpty((String)form.getProcedureModel().getCurrentWebId())) {
                    form.setProcedureModel(this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel()));
                } else {
                    form.setProcedureModel(this.procedureService.createProcedure(nuxeoController, form.getProcedureModel(), this.getProcedurePath((PortletRequest)request)));
                }
                this.addNotification(nuxeoController.getPortalCtx(), "MODEL_SAVED", NotificationsType.SUCCESS, new Object[0]);
                response.setRenderParameter("action", CREATE_VIEW);
            }
        }
        catch (WebIdException e) {
            this.addNotification(nuxeoController.getPortalCtx(), "WEBID_ERROR", NotificationsType.ERROR, new Object[0]);
        }
    }

    @ActionMapping(value="editProcedure", params={"exit"})
    public void exit(ActionRequest request, ActionResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        String redirectUrl = nuxeoController.getPortalUrlFactory().getBackURL(nuxeoController.getPortalCtx(), false);
        try {
            response.sendRedirect(redirectUrl);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ActionMapping(value="editProcedure", params={"deleteProcedure"})
    public void deleteProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.procedureService.deleteProcedure(nuxeoController, form.getProcedureModel());
        String redirectUrl = this.portalUrlFactory.getBackURL(nuxeoController.getPortalCtx(), false);
        try {
            response.sendRedirect(redirectUrl);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ActionMapping(value="editProcedure", params={"addStep"})
    public void addStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        Integer newIndex = form.getProcedureModel().getSteps().size();
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        form.setEditedStep(new Step(newIndex, form.getProcedureModel().getNewStepReference()));
        form.setSelectedStep(String.valueOf(newIndex));
        response.setRenderParameter("action", EDIT_VIEW);
    }

    @ActionMapping(value="editProcedure", params={"addTdb"})
    public void addTdb(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.addDashboard(request, response, form);
    }

    private void addDashboard(ActionRequest request, ActionResponse response, Form form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        Dashboard newDashboard = new Dashboard();
        newDashboard.setName(bundle.getString("PROCEDURE_DASHBOARD"));
        form.setEditedDashboard(newDashboard);
        form.setSelectedTdb(String.valueOf(form.getProcedureModel().getDashboards().size() + 1));
        response.setRenderParameter("action", EDIT_TDB);
    }

    @ActionMapping(value="editRecord", params={"addColumn"})
    public void addColumnEditRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        form.getTheSelectedTdb().getColumns().add(form.getNewColumn());
        form.setNewColumn(new Column());
        response.setRenderParameter("action", EDIT_RECORD_VIEW);
        response.setRenderParameter("activeTab", "dashboard");
    }

    @ActionMapping(value="editTdb", params={"addColumn"})
    public void addColumn(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        form.getTheSelectedTdb().getColumns().add(form.getNewColumn());
        form.setNewColumn(new Column());
        response.setRenderParameter("action", EDIT_TDB);
    }

    @ActionMapping(value="editTdb", params={"addExportVar"})
    public void addExportVar(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        form.getTheSelectedTdb().getExportVarList().add(form.getNewExportVar());
        form.setNewExportVar(null);
        response.setRenderParameter("action", EDIT_TDB);
    }

    @ActionMapping(value="editProcedure", params={"manageVariables"})
    public void manageVariables(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        Map variables = form.getProcedureModel().getVariables();
        ArrayList<Variable> sortedVariables = new ArrayList<Variable>(variables.size());
        for (Map.Entry entryVar : variables.entrySet()) {
            sortedVariables.add(new Variable((Variable)entryVar.getValue()));
        }
        Collections.sort(sortedVariables);
        ProcedureUtils.fillUsedInFields(sortedVariables, (List)form.getProcedureModel().getSteps());
        form.setEditedVariables(sortedVariables);
        response.setRenderParameter("action", MANAGE_VIEW);
    }

    @ActionMapping(value="manageVariables", params={"cancel"})
    public void cancel(ActionRequest request, ActionResponse response) {
        response.setRenderParameter("action", CREATE_VIEW);
    }

    @ActionMapping(value="manageVariables", params={"save"})
    public void save(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        List editedVariables = form.getEditedVariables();
        form.getProcedureModel().setVariables(new HashMap(editedVariables.size()));
        for (Variable variable : editedVariables) {
            form.getProcedureModel().getVariables().put(variable.getName(), variable);
        }
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        this.updateStepReferences(form);
        response.setRenderParameter("action", CREATE_VIEW);
    }

    @ActionMapping(value="manageVariables", params={"deleteVariable"})
    public void deleteVariable(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedVar") String selectedVar) throws PortletException {
        ListIterator listIterator = form.getEditedVariables().listIterator();
        while (listIterator.hasNext()) {
            Variable variable = (Variable)listIterator.next();
            if (!StringUtils.equals((String)selectedVar, (String)variable.getName())) continue;
            listIterator.remove();
        }
        response.setRenderParameter("action", MANAGE_VIEW);
    }

    @ActionMapping(value="manageVariables", params={"selectVariable"})
    public void selectVariable(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedVar", required=false) String selectedVar) throws PortletException {
        for (Variable variable : form.getEditedVariables()) {
            if (!StringUtils.equals((String)selectedVar, (String)variable.getName())) continue;
            form.setSelectedVariable(variable);
        }
        response.setRenderParameter("action", MANAGE_VIEW);
    }

    @ActionMapping(value="manageVariables", params={"saveVariable"})
    public void saveVariable(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        Variable selectedVariable = form.getSelectedVariable();
        if (StringUtils.isNotBlank((String)selectedVariable.getName())) {
            ListIterator<Variable> listIterator = form.getEditedVariables().listIterator();
            while (listIterator.hasNext()) {
                Variable variable = (Variable)listIterator.next();
                if (!StringUtils.equals((String)selectedVariable.getName(), (String)variable.getName())) continue;
                listIterator.remove();
                listIterator.add(selectedVariable);
            }
            form.setSelectedVariable(null);
        }
        response.setRenderParameter("action", MANAGE_VIEW);
    }

    @ActionMapping(value="editProcedure", params={"addObject"})
    public void addObject(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        form.getProcedureModel().getProcedureObjects().add(new ProcedureObject());
        response.setRenderParameter("action", CREATE_VIEW);
    }

    @ActionMapping(value="editProcedure", params={"deleteObject"})
    public void deleteObject(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedObject", required=false) String selectedObject) throws PortletException {
        form.getProcedureModel().getProcedureObjects().remove(Integer.valueOf(selectedObject));
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        response.setRenderParameter("action", CREATE_VIEW);
    }

    private String getWebId(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String webId = window.getProperty("osivia.services.procedure.webid");
        return webId;
    }

    private String getId(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String uuid = window.getProperty("osivia.services.procedure.uuid");
        return uuid;
    }

    private String getDocType(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String docType = window.getProperty("osivia.doctype");
        return docType;
    }

    private String getAction(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String action = window.getProperty("osivia.procedure.admin");
        return action;
    }

    private String getDashboardPath(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        return window.getPageProperty("osivia.procedure.dashboard.path");
    }

    private String getProcedurePath(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        return window.getProperty("osivia.services.procedure.procedurePath");
    }

    @ActionMapping(value="editProcedure", params={"editStep"})
    public void editStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        Step step = (Step)form.getProcedureModel().getSteps().get(NumberUtils.toInt((String)form.getSelectedStep()));
        form.setEditedStep(new Step(step));
        response.setRenderParameter("action", EDIT_VIEW);
    }

    @ActionMapping(value="editProcedure", params={"editTdb"})
    public void editTdb(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        Dashboard editedDashboard = (Dashboard)form.getProcedureModel().getDashboards().get(NumberUtils.toInt((String)form.getSelectedTdb()));
        form.setEditedDashboard(new Dashboard(editedDashboard));
        response.setRenderParameter("action", EDIT_TDB);
    }

    @ActionMapping(value="editStep", params={"cancelStep"})
    public void cancelStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        response.setRenderParameter("action", CREATE_VIEW);
        form.setSelectedField(null);
        form.setSelectedAction(null);
        form.setSelectedStep(null);
    }

    @ActionMapping(value="editTdb", params={"cancelTdb"})
    public void cancelTdb(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        response.setRenderParameter("action", request.getParameter("cancelTdb"));
    }

    @ActionMapping(value="editStep", params={"saveStep"})
    public void saveStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        this.updateStepReferences(form);
        Integer index = (int)form.getTheSelectedStep().getIndex();
        if (form.getProcedureModel().getSteps().size() <= index) {
            form.getProcedureModel().getSteps().add(form.getTheSelectedStep());
        } else {
            form.getProcedureModel().getSteps().set(index, form.getTheSelectedStep());
        }
    }

    @ActionMapping(value="editTdb", params={"saveTdb"})
    public void saveTdb(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        Integer index = Integer.valueOf(form.getSelectedTdb());
        if (form.getProcedureModel().getDashboards().size() <= index) {
            form.getProcedureModel().getDashboards().add(form.getTheSelectedTdb());
        } else {
            form.getProcedureModel().getDashboards().set(index, form.getTheSelectedTdb());
        }
        response.setRenderParameter("action", CREATE_VIEW);
    }

    @ActionMapping(value="editRecord", params={"saveRecord"})
    public void saveRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        if (StringUtils.isNotBlank((String)form.getProcedureModel().getName())) {
            this.addAllFieldsToSet(form);
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
            try {
                if (StringUtils.isNotEmpty((String)form.getProcedureModel().getCurrentWebId())) {
                    form.setProcedureModel(this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel()));
                } else {
                    form.setProcedureModel(this.procedureService.createProcedure(nuxeoController, form.getProcedureModel(), this.getProcedurePath((PortletRequest)request)));
                    String redirectUrl = nuxeoController.getPortalUrlFactory().getBackURL(nuxeoController.getPortalCtx(), false);
                    response.sendRedirect(redirectUrl);
                }
                sessionStatus.setComplete();
                this.addNotification(nuxeoController.getPortalCtx(), "MODEL_SAVED", NotificationsType.SUCCESS, new Object[0]);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
            catch (WebIdException e) {
                this.addNotification(nuxeoController.getPortalCtx(), "WEBID_ERROR", NotificationsType.ERROR, new Object[0]);
            }
        }
    }

    private void addAllFiltersToSet(Form form) {
        for (Step step : form.getProcedureModel().getSteps()) {
            for (Action action : step.getActions()) {
                HashSet filtersList = new HashSet();
                this.addAllFiltersToSet(filtersList, action.getFilters());
                action.setFiltersList(filtersList);
            }
            if (step.getInitAction() == null) continue;
            HashSet filtersList = new HashSet();
            this.addAllFiltersToSet(filtersList, step.getInitAction().getFilters());
            step.getInitAction().setFiltersList(filtersList);
        }
    }

    private void addAllFiltersToSet(Set<Filter> filtersList, List<Filter> filters) {
        filtersList.addAll(filters);
        for (Filter filter : filters) {
            if (filter.getFilters() == null) continue;
            this.addAllFiltersToSet(filtersList, filter.getFilters());
        }
    }

    private void addAllFieldsToSet(Form form) {
        for (Step step : form.getProcedureModel().getSteps()) {
            HashSet fieldsSet = new HashSet();
            this.addAllFieldsToSet(fieldsSet, step.getFields());
            step.setFieldsSet(fieldsSet);
        }
    }

    private void addAllFieldsToSet(Set<Field> fieldsSet, List<Field> fields) {
        fieldsSet.addAll(fields);
        for (Field field : fields) {
            if (field.getFields() == null) continue;
            this.addAllFieldsToSet(fieldsSet, field.getFields());
        }
    }

    private void updateStepReferences(Form form) {
        if (form.getTheSelectedStep() != null && !StringUtils.equals((String)form.getTheSelectedStep().getReference(), (String)form.getTheSelectedStep().getOldReference())) {
            List steps;
            if (StringUtils.equals((String)form.getProcedureModel().getStartingStep(), (String)form.getTheSelectedStep().getOldReference())) {
                form.getProcedureModel().setStartingStep(form.getTheSelectedStep().getReference());
            }
            if ((steps = form.getProcedureModel().getSteps()) != null) {
                for (Step step : steps) {
                    List actions = step.getActions();
                    if (actions == null) continue;
                    for (Action action : actions) {
                        if (!StringUtils.equals((String)action.getStepReference(), (String)form.getTheSelectedStep().getOldReference())) continue;
                        action.setStepReference(form.getTheSelectedStep().getReference());
                    }
                }
            }
        }
    }

    @ActionMapping(value="editStep", params={"deleteStep"})
    public void deleteStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        form.getProcedureModel().getSteps().remove(Integer.valueOf(form.getSelectedStep()));
        form.getProcedureModel().updateStepsIndexes();
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        response.setRenderParameter("action", CREATE_VIEW);
        form.setSelectedStep(null);
    }

    @ActionMapping(value="editTdb", params={"deleteTdb"})
    public void deleteTdb(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        form.getProcedureModel().getDashboards().remove(Integer.valueOf(form.getSelectedTdb()));
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        response.setRenderParameter("action", CREATE_VIEW);
        form.setSelectedTdb(null);
    }

    @ActionMapping(value="editTdb", params={"deleteCol"})
    public void deleteCol(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedCol", required=false) String selectedCol) throws PortletException {
        form.getTheSelectedTdb().getColumns().remove(Integer.valueOf(selectedCol));
        response.setRenderParameter("action", EDIT_TDB);
    }

    @ActionMapping(value="editTdb", params={"deleteExportVar"})
    public void deleteExportVar(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedExportVar", required=false) String selectedExportVar) throws PortletException {
        form.getTheSelectedTdb().getExportVarList().remove(Integer.valueOf(selectedExportVar));
        response.setRenderParameter("action", EDIT_TDB);
    }

    @ActionMapping(value="editRecord", params={"deleteCol"})
    public void deleteColEditRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedCol", required=false) String selectedCol) throws PortletException {
        if (((Column)form.getTheSelectedTdb().getColumns().get(Integer.valueOf(selectedCol))).isDeletable()) {
            form.getTheSelectedTdb().getColumns().remove(Integer.valueOf(selectedCol));
        }
        response.setRenderParameter("action", EDIT_RECORD_VIEW);
        response.setRenderParameter("activeTab", "dashboard");
    }

    private void editField(ActionResponse response, Form form, String action) {
        String[] path = form.getSelectedField().getPath().split(",");
        Field editedField = ProcedureUtils.getFieldByPath((List)form.getTheSelectedStep().getFields(), (String[])path);
        if (editedField != null) {
            form.getProcedureModel().getVariables().put(editedField.getName(), new Variable(editedField));
        }
        form.setProcedureInstance(null);
        response.setRenderParameter("activeTab", "form");
        response.setRenderParameter("activeFormTab", "edit");
        response.setRenderParameter("action", action);
    }

    @ActionMapping(value="editStep", params={"editField"})
    public void editFieldStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.editField(response, form, EDIT_VIEW);
    }

    @ActionMapping(value="editRecord", params={"editField"})
    public void editFieldList(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.editField(response, form, EDIT_RECORD_VIEW);
    }

    private void addField(ActionRequest request, ActionResponse response, Form form, String action, Boolean forceInput) throws PortletException {
        AddField addField = form.getNewField();
        if (StringUtils.isNotBlank((String)addField.getVariableName()) || StringUtils.isNotBlank((String)addField.getLabel())) {
            Map variables = form.getProcedureModel().getVariables();
            if (StringUtils.isBlank((String)addField.getVariableName())) {
                addField.setVariableName(ProcedureUtils.buildUniqueVariableName((Map)variables, (String)addField.getLabel()));
            } else {
                addField.setVariableName(ProcedureUtils.normalizeVariableName((String)addField.getVariableName()));
            }
            Field field = new Field(form.getTheSelectedStep().getNextPath(), addField, false);
            variables.put(addField.getVariableName(), new Variable(addField));
            this.updateProcedureWithForm(request, response, form, field, action, forceInput);
        } else {
            response.setRenderParameter("activeTab", "form");
            response.setRenderParameter("action", action);
        }
    }

    @ActionMapping(value="editStep", params={"addField"})
    public void addFieldInStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.addField(request, response, form, EDIT_VIEW, null);
    }

    @ActionMapping(value="editRecord", params={"addField"})
    public void addFieldInRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.addField(request, response, form, EDIT_RECORD_VIEW, Boolean.valueOf(true));
    }

    @ActionMapping(value="editRecord", params={"addFieldList"})
    public void addFieldListInRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        AddField addFieldList = form.getNewFieldList();
        addFieldList.setType(VariableTypesAllEnum.FIELDLIST);
        Map variables = form.getProcedureModel().getVariables();
        if (StringUtils.isBlank((String)addFieldList.getVariableName())) {
            addFieldList.setVariableName(ProcedureUtils.buildUniqueVariableName((Map)variables, (String)addFieldList.getLabel()));
        }
        Field field = new Field(form.getTheSelectedStep().getNextPath(), addFieldList, true);
        variables.put(addFieldList.getVariableName(), new Variable(addFieldList));
        this.updateProcedureWithForm(request, response, form, field, EDIT_RECORD_VIEW);
    }

    @ActionMapping(value="editStep", params={"addFieldSet"})
    public void addFieldSet(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        AddField newFieldSet = form.getNewFieldSet();
        newFieldSet.setType(VariableTypesAllEnum.FIELDSET);
        Map variables = form.getProcedureModel().getVariables();
        if (StringUtils.isBlank((String)newFieldSet.getVariableName())) {
            newFieldSet.setVariableName(ProcedureUtils.buildUniqueVariableName((Map)variables, (String)newFieldSet.getLabel()));
        }
        Field field = new Field(form.getTheSelectedStep().getNextPath(), newFieldSet, true);
        variables.put(newFieldSet.getVariableName(), new Variable(newFieldSet));
        this.updateProcedureWithForm(request, response, form, field, EDIT_VIEW);
    }

    @ActionMapping(value="actionProcedure", params={"applyRules"})
    public void applyRules(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException, IOException {
        try {
            if (!StringUtils.isEmpty((String)form.getProcedureModel().getRules())) {
                new DatasInjection().shouldFire(form.getProcedureModel(), form.getProcedureInstance().getGlobalVariablesValues(), "apply");
                new DatasInjection().shouldFire(form.getProcedureModel(), form.getProcedureInstance().getGlobalVariablesValues(), "prepare");
            }
        }
        catch (FormFilterException e) {
            this.notificationsService.addSimpleNotification(new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response), e.getMessage(), NotificationsType.ERROR);
            request.setAttribute("filterMessage", (Object)e.getMessage());
            response.setRenderParameter("action", VIEW_PROCEDURE);
        }
    }

    @ActionMapping(value="actionProcedure", params={"addFieldInList"})
    public void addFieldInList(ActionRequest request, ActionResponse response, @RequestParam(value="addFieldInList") String selectedFieldPath, @ModelAttribute(value="form") Form form) throws PortletException, IOException {
        JSONArray jsonValue;
        Field listField = ProcedureUtils.getFieldByFieldPath((List)form.getTheSelectedStep().getFields(), (String)selectedFieldPath);
        Map globalVariablesValues = form.getProcedureInstance().getGlobalVariablesValues();
        List fields = listField.getFields();
        String listFieldValue = (String)globalVariablesValues.get(listField.getName());
        if (StringUtils.isNotBlank((String)listFieldValue)) {
            try {
                jsonValue = JSONArray.fromObject((Object)listFieldValue);
            }
            catch (JSONException e) {
                jsonValue = new JSONArray();
            }
        } else {
            jsonValue = new JSONArray();
        }
        if (CollectionUtils.isNotEmpty((Collection)fields)) {
            JSONObject jsonObject = new JSONObject();
            for (Field field : fields) {
                String name = field.getName();
                String value = null;
                if (VariableTypesAllEnum.FILE.equals((Object)field.getType()) || VariableTypesAllEnum.PICTURE.equals((Object)field.getType())) {
                    ProcedureUploadedFile uploadedFile = (ProcedureUploadedFile)form.getUploadedFiles().get(name);
                    String nameFile = ProcedureServiceImpl.getFileKey((String)Integer.toString(jsonValue.size()), (Field)field);
                    form.getUploadedFiles().put(nameFile, uploadedFile);
                    if (uploadedFile == null) {
                        value = null;
                    } else if (uploadedFile.isDeleted()) {
                        value = null;
                    } else if (uploadedFile.getTemporaryFile() != null) {
                        JSONObject uploadedFileJsonValue = new JSONObject();
                        uploadedFileJsonValue.put((Object)"digest", (Object)this.getDigest(uploadedFile.getTemporaryFile()));
                        uploadedFileJsonValue.put((Object)"fileName", (Object)uploadedFile.getTemporaryMetadata().getFileName());
                        value = uploadedFileJsonValue.toString();
                    }
                } else {
                    value = (String)globalVariablesValues.get(name);
                }
                if (value != null) {
                    jsonObject.accumulate(name, (Object)value);
                }
                form.getUploadedFiles().remove(name);
                globalVariablesValues.remove(name);
            }
            jsonValue.add((Object)jsonObject);
        }
        globalVariablesValues.put(listField.getName(), jsonValue.toString());
        Record record = form.getRecord();
        if (record != null) {
            record.setGlobalVariablesValues(globalVariablesValues);
        }
        try {
            if (!StringUtils.isEmpty((String)form.getProcedureModel().getRules())) {
                new DatasInjection().shouldFire(form.getProcedureModel(), form.getProcedureInstance().getGlobalVariablesValues(), "prepare");
            }
        }
        catch (FormFilterException e) {
            this.notificationsService.addSimpleNotification(new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response), e.getMessage(), NotificationsType.ERROR);
            request.setAttribute("filterMessage", (Object)e.getMessage());
            response.setRenderParameter("action", VIEW_PROCEDURE);
        }
    }

    @ActionMapping(value="actionProcedure", params={"removeFieldInList"})
    public void removeFieldInList(ActionRequest request, ActionResponse response, @RequestParam(value="removeFieldInList") String submitValue, @ModelAttribute(value="form") Form form) throws PortletException {
        Object[] splittedValues = StringUtils.split((String)submitValue, (String)"|");
        if (ArrayUtils.isNotEmpty((Object[])splittedValues) && splittedValues.length == 2) {
            Object selectedFieldPath = splittedValues[0];
            Object rowIndex = splittedValues[1];
            if (StringUtils.isNotBlank((String)selectedFieldPath) && StringUtils.isNotBlank((String)rowIndex)) {
                Record record;
                Field listField = ProcedureUtils.getFieldByFieldPath((List)form.getTheSelectedStep().getFields(), (String)selectedFieldPath);
                Map globalVariablesValues = form.getProcedureInstance().getGlobalVariablesValues();
                String listFieldValue = (String)globalVariablesValues.get(listField.getName());
                int index = Integer.valueOf((String)rowIndex);
                JSONArray jsonValue = StringUtils.isNotBlank((String)listFieldValue) ? JSONArray.fromObject((Object)listFieldValue) : new JSONArray();
                jsonValue.remove(index);
                globalVariablesValues.put(listField.getName(), jsonValue.toString());
                for (Field field : listField.getFields()) {
                    String name = field.getName();
                    if (!VariableTypesAllEnum.FILE.equals((Object)field.getType()) && !VariableTypesAllEnum.PICTURE.equals((Object)field.getType())) continue;
                    for (int i = index; i < jsonValue.size(); ++i) {
                        String nextKey = ProcedureServiceImpl.getFileKey((String)Integer.toString(i + 1), (Field)field);
                        String curKey = ProcedureServiceImpl.getFileKey((String)Integer.toString(i), (Field)field);
                        ProcedureUploadedFile nextFile = (ProcedureUploadedFile)form.getUploadedFiles().get(nextKey);
                        if (nextFile != null) {
                            form.getUploadedFiles().put(curKey, nextFile);
                            continue;
                        }
                        form.getUploadedFiles().remove(curKey);
                    }
                    String curKey = ProcedureServiceImpl.getFileKey((String)Integer.toString(jsonValue.size()), (Field)field);
                    form.getUploadedFiles().remove(curKey);
                    form.getUploadedFiles().remove(name);
                }
                if (jsonValue.size() == 0) {
                    globalVariablesValues.remove(listField.getName());
                }
                if ((record = form.getRecord()) != null) {
                    record.setGlobalVariablesValues(globalVariablesValues);
                }
            }
        }
        try {
            if (!StringUtils.isEmpty((String)form.getProcedureModel().getRules())) {
                new DatasInjection().shouldFire(form.getProcedureModel(), form.getProcedureInstance().getGlobalVariablesValues(), "prepare");
            }
        }
        catch (FormFilterException e) {
            this.notificationsService.addSimpleNotification(new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response), e.getMessage(), NotificationsType.ERROR);
            request.setAttribute("filterMessage", (Object)e.getMessage());
            response.setRenderParameter("action", VIEW_PROCEDURE);
        }
    }

    @ActionMapping(value="actionProcedure", params={"editFieldInList"})
    public void editFieldInList(ActionRequest request, ActionResponse response, @RequestParam(value="editFieldInList") String submitValue, @ModelAttribute(value="form") Form form) throws PortletException {
        Object[] splittedValues = StringUtils.split((String)submitValue, (String)"|");
        if (ArrayUtils.isNotEmpty((Object[])splittedValues) && splittedValues.length == 2) {
            Object selectedFieldPath = splittedValues[0];
            Object rowIndex = splittedValues[1];
            if (StringUtils.isNotBlank((String)selectedFieldPath) && StringUtils.isNotBlank((String)rowIndex)) {
                Field listField = ProcedureUtils.getFieldByFieldPath((List)form.getTheSelectedStep().getFields(), (String)selectedFieldPath);
                Map globalVariablesValues = form.getProcedureInstance().getGlobalVariablesValues();
                String listFieldValue = (String)globalVariablesValues.get(listField.getName());
                int rowIdx = Integer.valueOf((String)rowIndex);
                JSONArray jsonValue = StringUtils.isNotBlank((String)listFieldValue) ? JSONArray.fromObject((Object)listFieldValue) : new JSONArray();
                for (int i = 0; i < jsonValue.size(); ++i) {
                    if (i != rowIdx) continue;
                    JSONObject jsonO = (JSONObject)jsonValue.get(i);
                    for (int j = 0; j < jsonO.names().size(); ++j) {
                        String name = jsonO.names().getString(j);
                        String value = jsonO.getString(name);
                        globalVariablesValues.put(name, value);
                    }
                }
                form.getSelectedListFieldRowIndex().put(selectedFieldPath, rowIndex);
                for (Field nestedField : listField.getFields()) {
                    ProcedureUploadedFile uploadedFile;
                    if (!VariableTypesAllEnum.FILE.equals((Object)nestedField.getType()) && !VariableTypesAllEnum.PICTURE.equals((Object)nestedField.getType())) continue;
                    ProcedureUploadedFile uploadedFileInList = (ProcedureUploadedFile)form.getUploadedFiles().get(ProcedureServiceImpl.getFileKey((String)rowIndex, (Field)nestedField));
                    if (uploadedFileInList != null) {
                        uploadedFile = new ProcedureUploadedFile();
                        ProcedureUploadedFileMetadata metaData = uploadedFileInList.getTemporaryMetadata();
                        if (metaData == null) {
                            metaData = new ProcedureUploadedFileMetadata();
                            if (uploadedFileInList.getOriginalMetadata() != null) {
                                metaData.setFileName(uploadedFileInList.getOriginalMetadata().getFileName());
                            }
                        }
                        uploadedFile.setTemporaryMetadata(metaData);
                    } else {
                        uploadedFile = (ProcedureUploadedFile)this.applicationContext.getBean(ProcedureUploadedFile.class);
                    }
                    form.getUploadedFiles().put(nestedField.getName(), uploadedFile);
                }
                Record record = form.getRecord();
                if (record != null) {
                    record.setGlobalVariablesValues(globalVariablesValues);
                }
            }
        }
        try {
            if (!StringUtils.isEmpty((String)form.getProcedureModel().getRules())) {
                new DatasInjection().shouldFire(form.getProcedureModel(), form.getProcedureInstance().getGlobalVariablesValues(), "prepare");
            }
        }
        catch (FormFilterException e) {
            this.notificationsService.addSimpleNotification(new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response), e.getMessage(), NotificationsType.ERROR);
            request.setAttribute("filterMessage", (Object)e.getMessage());
            response.setRenderParameter("action", VIEW_PROCEDURE);
        }
    }

    @ActionMapping(value="actionProcedure", params={"validateEditFieldInList"})
    public void validateEditFieldInList(ActionRequest request, ActionResponse response, @RequestParam(value="validateEditFieldInList") String submitValue, @ModelAttribute(value="form") Form form) throws PortletException, IOException {
        String selectedFieldPath = submitValue;
        String rowIndex = (String)form.getSelectedListFieldRowIndex().get(submitValue);
        if (StringUtils.isNotBlank((String)selectedFieldPath) && StringUtils.isNotBlank((String)rowIndex)) {
            Field listField = ProcedureUtils.getFieldByFieldPath((List)form.getTheSelectedStep().getFields(), (String)selectedFieldPath);
            Map globalVariablesValues = form.getProcedureInstance().getGlobalVariablesValues();
            String listFieldValue = (String)globalVariablesValues.get(listField.getName());
            int rowIdx = Integer.valueOf(rowIndex);
            JSONArray jsonValue = StringUtils.isNotBlank((String)listFieldValue) ? JSONArray.fromObject((Object)listFieldValue) : new JSONArray();
            List fields = listField.getFields();
            if (CollectionUtils.isNotEmpty((Collection)fields)) {
                JSONObject jsonObject = new JSONObject();
                for (Field field : fields) {
                    String value;
                    String name = field.getName();
                    if (VariableTypesAllEnum.FILE.equals((Object)field.getType()) || VariableTypesAllEnum.PICTURE.equals((Object)field.getType())) {
                        ProcedureUploadedFile uploadedFile = (ProcedureUploadedFile)form.getUploadedFiles().get(name);
                        String uploadKey = ProcedureServiceImpl.getFileKey((String)rowIndex, (Field)field);
                        if (uploadedFile.getTemporaryFile() == null && !uploadedFile.isDeleted()) {
                            uploadedFile = (ProcedureUploadedFile)form.getUploadedFiles().get(uploadKey);
                        } else {
                            form.getUploadedFiles().put(uploadKey, uploadedFile);
                        }
                        if (uploadedFile == null) {
                            value = null;
                        } else if (uploadedFile.isDeleted()) {
                            value = null;
                        } else if (uploadedFile.getTemporaryFile() != null) {
                            JSONObject uploadedFileJsonValue = new JSONObject();
                            uploadedFileJsonValue.put((Object)"digest", (Object)this.getDigest(uploadedFile.getTemporaryFile()));
                            uploadedFileJsonValue.put((Object)"fileName", (Object)uploadedFile.getTemporaryMetadata().getFileName());
                            value = uploadedFileJsonValue.toString();
                        } else {
                            value = jsonValue.getJSONObject(rowIdx).getString(name);
                        }
                    } else {
                        value = (String)globalVariablesValues.get(name);
                    }
                    if (value != null) {
                        jsonObject.accumulate(name, (Object)value);
                    }
                    globalVariablesValues.remove(name);
                }
                jsonValue.element(rowIdx, (Map)jsonObject);
            }
            globalVariablesValues.put(listField.getName(), jsonValue.toString());
            form.getSelectedListFieldRowIndex().remove(selectedFieldPath);
        }
        try {
            if (!StringUtils.isEmpty((String)form.getProcedureModel().getRules())) {
                new DatasInjection().shouldFire(form.getProcedureModel(), form.getProcedureInstance().getGlobalVariablesValues(), "prepare");
            }
        }
        catch (FormFilterException e) {
            this.notificationsService.addSimpleNotification(new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response), e.getMessage(), NotificationsType.ERROR);
            request.setAttribute("filterMessage", (Object)e.getMessage());
            response.setRenderParameter("action", VIEW_PROCEDURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDigest(File file) throws IOException {
        String digest;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            digest = DigestUtils.md5Hex((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return digest;
    }

    @ActionMapping(value="actionProcedure", params={"cancelEditFieldInList"})
    public void cancelEditFieldInList(ActionRequest request, ActionResponse response, @RequestParam(value="cancelEditFieldInList") String submitValue, @ModelAttribute(value="form") Form form) throws PortletException {
        if (StringUtils.isNotBlank((String)submitValue) && StringUtils.isNotBlank((String)((String)form.getSelectedListFieldRowIndex().get(submitValue)))) {
            Field listField = ProcedureUtils.getFieldByFieldPath((List)form.getTheSelectedStep().getFields(), (String)submitValue);
            Map globalVariablesValues = form.getProcedureInstance().getGlobalVariablesValues();
            List fields = listField.getFields();
            if (CollectionUtils.isNotEmpty((Collection)fields)) {
                for (Field field : fields) {
                    globalVariablesValues.remove(field.getName());
                }
            }
            form.getSelectedListFieldRowIndex().remove(submitValue);
        }
    }

    private void updateProcedureWithForm(ActionRequest request, ActionResponse response, Form form, Field field, String action) throws PortletException {
        this.updateProcedureWithForm(request, response, form, field, action, null);
    }

    private void updateProcedureWithForm(ActionRequest request, ActionResponse response, Form form, Field field, String action, Boolean input) throws PortletException {
        field.setPath(String.valueOf(form.getTheSelectedStep().getFields().size()));
        if (BooleanUtils.isTrue((Boolean)input)) {
            field.setInput(true);
        }
        form.getTheSelectedStep().getFields().add(field);
        ProcedureUtils.updateFieldsPath((List)form.getTheSelectedStep().getFields(), (String)"");
        form.setNewField(new AddField());
        form.setNewFieldSet(new AddField());
        form.setNewFieldList(new AddField());
        response.setRenderParameter("activeTab", "form");
        response.setRenderParameter("action", action);
    }

    private void updateForm(ActionResponse response, Form form, String activeTab, String action) {
        if (form.getTheSelectedStep() != null) {
            form.setSelectedField(null);
            ProcedureUtils.rebuildStep((Step)form.getTheSelectedStep());
        }
        if (form.getTheSelectedTdb() != null) {
            Collections.sort(form.getTheSelectedTdb().getColumns());
        }
        response.setRenderParameter("activeTab", activeTab);
        response.setRenderParameter("action", action);
    }

    @ActionMapping(value="editStep", params={"updateForm"})
    public void updateFormStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.updateForm(response, form, "form", EDIT_VIEW);
    }

    @ActionMapping(value="editRecord", params={"updateForm"})
    public void updateFormRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.updateForm(response, form, "form", EDIT_RECORD_VIEW);
    }

    @ActionMapping(value="editRecord", params={"updateDashboard"})
    public void updateDashboardRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.updateForm(response, form, "dashboard", EDIT_RECORD_VIEW);
    }

    @ActionMapping(value="editTdb", params={"updateDashboard"})
    public void updateDashboard(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="exportVarList", required=false) String exportVarList) throws PortletException {
        this.updateForm(response, form, "dashboard", EDIT_TDB);
        if (StringUtils.isNotBlank((String)exportVarList)) {
            form.getTheSelectedTdb().setExportVarList(Arrays.asList(StringUtils.split((String)exportVarList, (char)',')));
        }
    }

    @ActionMapping(value="editStep", params={"editButton"})
    public void editAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedButton") String index) throws PortletException {
        Action action;
        if (StringUtils.equals((String)index, (String)"-1")) {
            action = form.getTheSelectedStep().getInitAction();
        } else {
            List actions = form.getTheSelectedStep().getActions();
            action = (Action)actions.get(NumberUtils.toInt((String)index));
        }
        form.setSelectedAction(index);
        form.setEditedAction(new Action(action));
        Map variables = form.getProcedureModel().getVariables();
        ArrayList<Variable> sortedVariables = new ArrayList<Variable>(variables.size());
        for (Map.Entry entryVar : variables.entrySet()) {
            sortedVariables.add(new Variable((Variable)entryVar.getValue()));
        }
        Collections.sort(sortedVariables);
        form.setEditedVariables(sortedVariables);
        form.setSelectedFilter(null);
        response.setRenderParameter("action", VIEW_ACTION);
    }

    @ActionMapping(value="editStep", params={"addButton"})
    public void addButton(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        form.getTheSelectedStep().addAction();
        response.setRenderParameter("activeTab", "action");
        response.setRenderParameter("action", EDIT_VIEW);
    }

    @ActionMapping(value="editStep", params={"deleteButton"})
    public void deleteButton(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedButton") String index) throws PortletException {
        form.getTheSelectedStep().getActions().remove(Integer.valueOf(index));
        response.setRenderParameter("activeTab", "action");
        response.setRenderParameter("action", EDIT_VIEW);
    }

    private void fillEditFieldTab(ActionResponse response, Form form, String selectedFieldPath, String action) {
        Field fieldByFieldPath = ProcedureUtils.getFieldByFieldPath((List)form.getTheSelectedStep().getFields(), (String)selectedFieldPath);
        form.setSelectedField(fieldByFieldPath);
        response.setRenderParameter("activeTab", "form");
        response.setRenderParameter("activeFormTab", "edit");
        response.setRenderParameter("action", action);
    }

    @ActionMapping(value="editStep", params={"selectField"})
    public void fillEditFieldTabStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedFieldPath") String selectedFieldPath) {
        this.fillEditFieldTab(response, form, selectedFieldPath, EDIT_VIEW);
    }

    @ActionMapping(value="editRecord", params={"selectField"})
    public void fillEditFieldTabList(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedFieldPath") String selectedFieldPath) {
        this.fillEditFieldTab(response, form, selectedFieldPath, EDIT_RECORD_VIEW);
    }

    @ActionMapping(value="editAction", params={"addFilter"})
    public void addFilter(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedFilterId") String filterId) throws PortletException {
        int newPath;
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        Map formsFilters = nuxeoController.getNuxeoCMSService().getCMSCustomizer().getFormsFilters();
        FormFilter selectedFilter = (FormFilter)formsFilters.get(filterId);
        if (form.getTheSelectedAction().getFilters().isEmpty()) {
            newPath = 0;
        } else {
            String lastPath = ((Filter)form.getTheSelectedAction().getFilters().get(form.getTheSelectedAction().getFilters().size() - 1)).getFilterPath();
            newPath = Integer.parseInt(lastPath) + 1;
        }
        Filter newFilter = new Filter(selectedFilter, String.valueOf(newPath));
        form.getTheSelectedAction().getFilters().add(newFilter);
        response.setRenderParameter("action", VIEW_ACTION);
    }

    @ActionMapping(value="editAction", params={"deleteFilter"})
    public void deleteFilter(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        ProcedureUtils.removeFilterByFilterPath((Action)form.getTheSelectedAction(), (String)form.getSelectedFilter().getFilterPath());
        form.setSelectedFilter(null);
        response.setRenderParameter("action", VIEW_ACTION);
        response.setRenderParameter("activeTab", "");
    }

    @ActionMapping(value="editAction", params={"cancelAction"})
    public void cancelAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        response.setRenderParameter("action", EDIT_VIEW);
        response.setRenderParameter("activeTab", "action");
    }

    @ActionMapping(value="editAction", params={"cancelAction=toStep"})
    public void cancelActionToEditStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        response.setRenderParameter("action", EDIT_VIEW);
    }

    @ActionMapping(value="editAction", params={"cancelAction=toProc"})
    public void cancelActionToEditProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        response.setRenderParameter("action", CREATE_VIEW);
    }

    @ActionMapping(value="editTdb", params={"cancelAction=toProc"})
    public void cancelEditTdbActionToEditProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        response.setRenderParameter("action", CREATE_VIEW);
    }

    @ActionMapping(value="editAction", params={"editFilter"})
    public void editFilter(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        ProcedureUtils.updateFilter((List)form.getTheSelectedAction().getFilters(), (Filter)form.getSelectedFilter());
        response.setRenderParameter("action", VIEW_ACTION);
        response.setRenderParameter("activeTab", "edit");
    }

    @ActionMapping(value="editAction", params={"selectFilter"})
    public void fillEditTab(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedFilterPath") String selectedFilterPath) {
        if (form.getSelectedFilter() != null && StringUtils.equals((String)form.getSelectedFilter().getFilterPath(), (String)selectedFilterPath)) {
            form.setSelectedFilter(null);
            response.setRenderParameter("activeTab", "");
        } else {
            Filter filterByFilterPath = ProcedureUtils.getFilterByFilterPath((List)form.getTheSelectedAction().getFilters(), (String)selectedFilterPath);
            form.setSelectedFilter(filterByFilterPath);
            response.setRenderParameter("activeTab", "edit");
        }
        response.setRenderParameter("action", VIEW_ACTION);
    }

    @ActionMapping(value="editAction", params={"saveAction"})
    public void saveAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        Action theSelectedAction = form.getTheSelectedAction();
        Integer index = NumberUtils.toInt((String)form.getSelectedAction());
        if (index < 0) {
            form.getTheSelectedStep().setInitAction(theSelectedAction);
        } else if (form.getTheSelectedStep().getActions().size() <= index) {
            form.getTheSelectedStep().getActions().add(theSelectedAction);
        } else {
            form.getTheSelectedStep().getActions().set(index, theSelectedAction);
        }
        response.setRenderParameter("action", EDIT_VIEW);
        response.setRenderParameter("activeTab", "action");
    }

    @ActionMapping(value="editAction", params={"updateForm"})
    public void updateFormAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        ProcedureUtils.rebuildAction((Action)form.getTheSelectedAction());
        form.setSelectedFilter(null);
        response.setRenderParameter("action", VIEW_ACTION);
    }

    private void deleteField(ActionResponse response, Form form, String action) {
        if (form.getSelectedField().isDeletable()) {
            ProcedureUtils.removeFieldsByFieldPath((Step)form.getTheSelectedStep(), (String)form.getSelectedField().getPath());
            form.setSelectedField(null);
        }
        response.setRenderParameter("activeTab", "form");
        response.setRenderParameter("activeFormTab", "");
        response.setRenderParameter("action", action);
    }

    @ActionMapping(value="editStep", params={"deleteField"})
    public void deleteFieldStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.deleteField(response, form, EDIT_VIEW);
    }

    @ActionMapping(value="editRecord", params={"deleteField"})
    public void deleteFieldList(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.deleteField(response, form, EDIT_RECORD_VIEW);
    }

    @ActionMapping(value="editRecord", params={"deleteRecord"})
    public void deleteRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.procedureService.deleteProcedure(nuxeoController, form.getProcedureModel());
        String redirectUrl = this.portalUrlFactory.getBackURL(nuxeoController.getPortalCtx(), false);
        try {
            response.sendRedirect(redirectUrl);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ResourceMapping(value="vocabulary-search")
    public void vocabularySearch(ResourceRequest request, ResourceResponse response, @RequestParam(name="vocabularyId", required=false) String vocabularyId, @RequestParam(name="filter", required=false) String filter) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        JSONArray results = this.procedureService.searchVocabularyValues(portalControllerContext, vocabularyId, filter);
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(results.toString());
        printWriter.close();
    }

    @ResourceMapping(value="record-search")
    public void recordSearch(ResourceRequest request, ResourceResponse response, @RequestParam(name="recordFolderWebId", required=false) String recordFolderWebId, @RequestParam(name="filter", required=false) String filter) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        JSONArray results = this.procedureService.searchRecords(portalControllerContext, recordFolderWebId, filter);
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(results.toString());
        printWriter.close();
    }

    @ActionMapping(value="actionProcedure", params={"upload-file"})
    public void uploadFile(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.procedureService.uploadFile(portalControllerContext, form);
    }

    @ActionMapping(value="actionProcedure", params={"delete-file"})
    public void deleteFile(ActionRequest request, ActionResponse response, @RequestParam(value="delete-file") String variableName, @ModelAttribute(value="form") Form form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.procedureService.deleteFile(portalControllerContext, form, variableName);
    }

    @ResourceMapping(value="picture-preview")
    public void picturePreview(ResourceRequest request, ResourceResponse response, @RequestParam(value="variableName") String variableName, @ModelAttribute(value="form") Form form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.procedureService.picturePreview(portalControllerContext, form, variableName);
    }

    private void addNotification(PortalControllerContext portalControllerContext, String key, NotificationsType notificationType, Object ... args) {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        String message = bundle.getString(key, args);
        this.notificationsService.addSimpleNotification(portalControllerContext, message, notificationType);
    }
}

