/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.osivia.portal.api.portlet.Refreshable;
import org.osivia.services.procedure.portlet.model.Action;
import org.osivia.services.procedure.portlet.model.AddField;
import org.osivia.services.procedure.portlet.model.Column;
import org.osivia.services.procedure.portlet.model.Dashboard;
import org.osivia.services.procedure.portlet.model.DocumentTypeEnum;
import org.osivia.services.procedure.portlet.model.Field;
import org.osivia.services.procedure.portlet.model.Filter;
import org.osivia.services.procedure.portlet.model.ProcedureInstance;
import org.osivia.services.procedure.portlet.model.ProcedureModel;
import org.osivia.services.procedure.portlet.model.ProcedureUploadedFile;
import org.osivia.services.procedure.portlet.model.Record;
import org.osivia.services.procedure.portlet.model.Step;
import org.osivia.services.procedure.portlet.model.Variable;
import org.osivia.services.procedure.portlet.model.VariableTypesAllEnum;
import org.osivia.services.procedure.portlet.model.VariableTypesAltEnum;

@Refreshable
public class Form {
    private ProcedureModel procedureModel;
    private String selectedStep;
    private String selectedAction;
    private String selectedTdb;
    private ProcedureInstance procedureInstance;
    private Record record;
    private AddField newField;
    private AddField newFieldSet;
    private AddField newFieldList;
    private Column newColumn;
    private String newExportVar;
    private Filter selectedFilter;
    private Field selectedField;
    private Variable selectedVariable;
    private boolean advancedMode;
    private VariableTypesAllEnum[] variableTypesEnum = VariableTypesAllEnum.filteredValues();
    private VariableTypesAltEnum[] variableTypesAltEnum = VariableTypesAltEnum.values();
    private List<ProcedureInstance> procedureInstances;
    private Step editedStep;
    private Action editedAction;
    private Dashboard editedDashboard;
    private List<Variable> editedVariables;
    private Map<String, String> recordTypes;
    private Map<String, String> selectedListFieldRowIndex;
    private final Map<String, ProcedureUploadedFile> uploadedFiles;

    public Form(ProcedureModel procedureModel) {
        this.procedureModel = procedureModel;
        this.newField = new AddField();
        this.newFieldSet = new AddField();
        this.newFieldList = new AddField();
        this.newColumn = new Column();
        this.uploadedFiles = new HashMap();
        this.selectedListFieldRowIndex = new HashMap();
    }

    public Form(ProcedureModel procedureModel, ProcedureInstance procedureInstance) {
        this.procedureModel = procedureModel;
        this.procedureInstance = procedureInstance;
        if (procedureInstance != null && procedureModel != null) {
            for (Step step : procedureModel.getSteps()) {
                if (!StringUtils.equals((String)procedureInstance.getCurrentStep(), (String)step.getReference())) continue;
                this.selectedStep = String.valueOf(step.getIndex());
                break;
            }
        }
        this.newField = new AddField();
        this.newFieldSet = new AddField();
        this.newFieldList = new AddField();
        this.newColumn = new Column();
        this.uploadedFiles = new HashMap();
        this.selectedListFieldRowIndex = new HashMap();
    }

    public Form(ProcedureModel procedureModel, Record record) {
        this.procedureModel = procedureModel;
        this.record = record;
        this.uploadedFiles = new HashMap();
        this.selectedListFieldRowIndex = new HashMap();
    }

    public Form() {
        this.newField = new AddField();
        this.newFieldSet = new AddField();
        this.newFieldList = new AddField();
        this.newColumn = new Column();
        this.uploadedFiles = new HashMap();
        this.selectedListFieldRowIndex = new HashMap();
    }

    public Step getTheSelectedStep() {
        if (StringUtils.isNotBlank((String)this.procedureModel.getProcedureType()) && DocumentTypeEnum.RECORDFOLDER.equals((Object)this.procedureModel.getDocumentType())) {
            return (Step)this.procedureModel.getSteps().get(0);
        }
        return this.editedStep;
    }

    public Step getTheCurrentStep() {
        String returnStep;
        if (this.getProcedureInstance() != null && StringUtils.isNotEmpty((String)this.getProcedureInstance().getCurrentStep())) {
            returnStep = this.getProcedureInstance().getCurrentStep();
        } else if (this.getRecord() != null) {
            if (StringUtils.equals((String)this.getProcedureModel().getStartingStep(), (String)"formulaire")) {
                return (Step)this.getProcedureModel().getSteps().get(0);
            }
            returnStep = this.getProcedureModel().getStartingStep();
        } else {
            returnStep = this.getProcedureModel().getStartingStep();
        }
        if (StringUtils.isNotBlank((String)this.getProcedureModel().getWebIdParent())) {
            for (Step parentStep : this.getProcedureModel().getProcedureParent().getSteps()) {
                if (!StringUtils.equals((String)returnStep, (String)parentStep.getReference())) continue;
                Step step = (Step)this.getProcedureModel().getSteps().get(0);
                parentStep.setFields(step.getFields());
                return parentStep;
            }
        } else {
            for (Step step : this.getProcedureModel().getSteps()) {
                if (!StringUtils.equals((String)returnStep, (String)step.getReference())) continue;
                return step;
            }
        }
        return null;
    }

    public Action getTheSelectedAction() {
        if (StringUtils.equals((String)this.selectedAction, (String)"-1")) {
            return this.getTheSelectedStep().getInitAction();
        }
        return this.editedAction;
    }

    public Dashboard getTheSelectedTdb() {
        if (StringUtils.isNotBlank((String)this.procedureModel.getProcedureType()) && DocumentTypeEnum.RECORDFOLDER.equals((Object)this.procedureModel.getDocumentType())) {
            return (Dashboard)this.procedureModel.getDashboards().get(0);
        }
        return this.editedDashboard;
    }

    public boolean isSelectedTdbPersisted() {
        int dashBoardsAmnt;
        int selectedTdbIndex;
        return !StringUtils.isNotBlank((String)this.getSelectedTdb()) || (selectedTdbIndex = NumberUtils.toInt((String)this.getSelectedTdb())) < (dashBoardsAmnt = this.getProcedureModel().getDashboards().size());
    }

    public String getSelectedStep() {
        return this.selectedStep;
    }

    public void setSelectedStep(String selectedStep) {
        this.selectedStep = selectedStep;
    }

    public ProcedureModel getProcedureModel() {
        return this.procedureModel;
    }

    public void setProcedureModel(ProcedureModel procedureModel) {
        this.procedureModel = procedureModel;
    }

    public ProcedureInstance getProcedureInstance() {
        return this.procedureInstance;
    }

    public void setProcedureInstance(ProcedureInstance procedureInstance) {
        this.procedureInstance = procedureInstance;
    }

    public AddField getNewField() {
        if (this.newField != null) {
            return this.newField;
        }
        return new AddField();
    }

    public void setNewField(AddField newField) {
        this.newField = newField;
    }

    public String getSelectedAction() {
        return this.selectedAction;
    }

    public void setSelectedAction(String selectedAction) {
        this.selectedAction = selectedAction;
    }

    public Filter getSelectedFilter() {
        return this.selectedFilter;
    }

    public void setSelectedFilter(Filter selectedFilter) {
        this.selectedFilter = selectedFilter;
    }

    public Field getSelectedField() {
        return this.selectedField;
    }

    public void setSelectedField(Field selectedField) {
        this.selectedField = selectedField;
    }

    public AddField getNewFieldSet() {
        if (this.newFieldSet != null) {
            return this.newFieldSet;
        }
        return new AddField();
    }

    public void setNewFieldSet(AddField newFieldSet) {
        this.newFieldSet = newFieldSet;
    }

    public boolean isAdvancedMode() {
        return this.advancedMode;
    }

    public void setAdvancedMode(boolean advancedMode) {
        this.advancedMode = advancedMode;
    }

    public VariableTypesAllEnum[] getVariableTypesEnum() {
        return this.variableTypesEnum;
    }

    public void setVariableTypesEnum(VariableTypesAllEnum[] variableTypesEnum) {
        this.variableTypesEnum = variableTypesEnum;
    }

    public List<ProcedureInstance> getProcedureInstances() {
        return this.procedureInstances;
    }

    public void setProcedureInstances(List<ProcedureInstance> procedureInstances) {
        this.procedureInstances = procedureInstances;
    }

    public Variable getSelectedVariable() {
        return this.selectedVariable;
    }

    public void setSelectedVariable(Variable selectedVariable) {
        this.selectedVariable = selectedVariable;
    }

    public String getSelectedTdb() {
        return this.selectedTdb;
    }

    public void setSelectedTdb(String selectedTdb) {
        this.selectedTdb = selectedTdb;
    }

    public Column getNewColumn() {
        if (this.newColumn == null) {
            this.newColumn = new Column();
        }
        return this.newColumn;
    }

    public void setNewColumn(Column newColumn) {
        this.newColumn = newColumn;
    }

    public Record getRecord() {
        return this.record;
    }

    public void setRecord(Record record) {
        this.record = record;
    }

    public VariableTypesAltEnum[] getVariableTypesAltEnum() {
        return this.variableTypesAltEnum;
    }

    public void setVariableTypesAltEnum(VariableTypesAltEnum[] variableTypesAltEnum) {
        this.variableTypesAltEnum = variableTypesAltEnum;
    }

    public String getNewExportVar() {
        return this.newExportVar;
    }

    public void setNewExportVar(String newExportVar) {
        this.newExportVar = newExportVar;
    }

    public Step getEditedStep() {
        return this.editedStep;
    }

    public void setEditedStep(Step editedStep) {
        this.editedStep = editedStep;
    }

    public Action getEditedAction() {
        return this.editedAction;
    }

    public void setEditedAction(Action editedAction) {
        this.editedAction = editedAction;
    }

    public Dashboard getEditedDashboard() {
        return this.editedDashboard;
    }

    public void setEditedDashboard(Dashboard editedDashboard) {
        this.editedDashboard = editedDashboard;
    }

    public List<Variable> getEditedVariables() {
        return this.editedVariables;
    }

    public void setEditedVariables(List<Variable> editedVariables) {
        this.editedVariables = editedVariables;
    }

    public Map<String, String> getRecordTypes() {
        return this.recordTypes;
    }

    public void setRecordTypes(Map<String, String> recordTypes) {
        this.recordTypes = recordTypes;
    }

    public AddField getNewFieldList() {
        return this.newFieldList;
    }

    public void setNewFieldList(AddField newFieldList) {
        this.newFieldList = newFieldList;
    }

    public Map<String, ProcedureUploadedFile> getUploadedFiles() {
        return this.uploadedFiles;
    }

    public Map<String, String> getSelectedListFieldRowIndex() {
        return this.selectedListFieldRowIndex;
    }

    public void setSelectedListFieldRowIndex(Map<String, String> selectedListFieldRowIndex) {
        this.selectedListFieldRowIndex = selectedListFieldRowIndex;
    }
}

