/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.model;

import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.procedure.portlet.model.FilePath;
import org.osivia.services.procedure.portlet.model.ProcedureObjectInstance;

public class ProcedureInstance {
    private Map<String, String> globalVariablesValues = new HashMap();
    private String currentStep;
    private String taskTitle;
    private String procedureModelWebId;
    private Map<String, FilePath> filesPath = new HashMap();
    private Map<String, ProcedureObjectInstance> procedureObjectInstances;
    private PropertyMap taskDoc;
    private Document originalDocument;
    private String url;

    public ProcedureInstance() {
        this.setProcedureObjects(new HashMap());
        this.procedureObjectInstances = new HashMap();
    }

    public ProcedureInstance(String currentStep) {
        this();
        this.currentStep = currentStep;
    }

    public ProcedureInstance(Document document) {
        this();
        PropertyList objectsList;
        PropertyList fileList;
        PropertyMap documentProperties = document.getProperties();
        this.setTaskDoc(documentProperties.getMap("pi:task"));
        this.currentStep = documentProperties.getString("pi:currentStep");
        this.setProcedureModelWebId(documentProperties.getString("pi:procedureModelWebId"));
        this.setOriginalDocument(document);
        PropertyMap gvvList = documentProperties.getMap("pi:globalVariablesValues");
        if (gvvList != null) {
            for (Map.Entry gvvO : gvvList.getMap().entrySet()) {
                this.globalVariablesValues.put(gvvO.getKey(), (String)gvvO.getValue());
            }
        }
        if ((fileList = documentProperties.getList("pi:attachments")) != null) {
            for (Object fileO : fileList.list()) {
                PropertyMap file = (PropertyMap)fileO;
                FilePath filePath = new FilePath();
                filePath.setVariableName(file.getString("variableName"));
                filePath.setFileName(file.getString("fileName"));
                this.filesPath.put(filePath.getVariableName(), filePath);
            }
        }
        if ((objectsList = documentProperties.getList("pi:procedureObjectInstances")) != null) {
            for (Object procedureObjectInstanceO : objectsList.list()) {
                PropertyMap procedureObjectM = (PropertyMap)procedureObjectInstanceO;
                ProcedureObjectInstance procedureObjectInstance = new ProcedureObjectInstance();
                procedureObjectInstance.setName(procedureObjectM.getString("name"));
                procedureObjectInstance.setProcedureObjectid(procedureObjectM.getString("procedureObjectId"));
                this.procedureObjectInstances.put(procedureObjectInstance.getName(), procedureObjectInstance);
            }
        }
    }

    public ProcedureInstance(Map<String, String> variables) {
        this();
        this.globalVariablesValues = variables;
    }

    public Map<String, JSON> getJsonValues() {
        HashMap<String, JSONArray> jsonValues;
        if (MapUtils.isEmpty((Map)this.globalVariablesValues)) {
            jsonValues = null;
        } else {
            jsonValues = new HashMap<String, JSONArray>(this.globalVariablesValues.size());
            for (Map.Entry entry : this.globalVariablesValues.entrySet()) {
                Object json;
                String name = (String)entry.getKey();
                String value = StringUtils.trim((String)((String)entry.getValue()));
                try {
                    json = StringUtils.startsWith((String)value, (String)"[") ? JSONArray.fromObject((Object)value) : (StringUtils.startsWith((String)value, (String)"{") ? JSONObject.fromObject((Object)value) : null);
                }
                catch (JSONException e) {
                    json = null;
                }
                if (json == null) continue;
                jsonValues.put(name, (JSONArray)json);
            }
        }
        return jsonValues;
    }

    public Map<String, String> getGlobalVariablesValues() {
        return this.globalVariablesValues;
    }

    public void setGlobalVariablesValues(Map<String, String> globalVariablesValues) {
        this.globalVariablesValues = globalVariablesValues;
    }

    public String getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(String currentStep) {
        this.currentStep = currentStep;
    }

    public String getTaskTitle() {
        return this.taskTitle;
    }

    public void setTaskTitle(String taskTitle) {
        this.taskTitle = taskTitle;
    }

    public Map<String, FilePath> getFilesPath() {
        return this.filesPath;
    }

    public void setFilesPath(Map<String, FilePath> filesPath) {
        this.filesPath = filesPath;
    }

    public Map<String, ProcedureObjectInstance> getProcedureObjects() {
        return this.procedureObjectInstances;
    }

    public void setProcedureObjects(Map<String, ProcedureObjectInstance> procedureObjectInstancess) {
        this.procedureObjectInstances = procedureObjectInstancess;
    }

    public Map<String, ProcedureObjectInstance> getProcedureObjectInstances() {
        return this.procedureObjectInstances;
    }

    public void setProcedureObjectInstances(Map<String, ProcedureObjectInstance> procedureObjectInstances) {
        this.procedureObjectInstances = procedureObjectInstances;
    }

    public PropertyMap getTaskDoc() {
        return this.taskDoc;
    }

    public void setTaskDoc(PropertyMap taskDoc) {
        this.taskDoc = taskDoc;
    }

    public String getProcedureModelWebId() {
        return this.procedureModelWebId;
    }

    public void setProcedureModelWebId(String procedureModelWebId) {
        this.procedureModelWebId = procedureModelWebId;
    }

    public Document getOriginalDocument() {
        return this.originalDocument;
    }

    public void setOriginalDocument(Document originalDocument) {
        this.originalDocument = originalDocument;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

