/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.rss.common.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.rss.feedRss.portlet.model.ItemRssModel;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ItemCreatCommand
implements INuxeoCommand {
    private ItemRssModel form;
    protected static final Log logger = LogFactory.getLog(ItemCreatCommand.class);

    public ItemCreatCommand(ItemRssModel form) {
        this.form = form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Session nuxeoSession) throws Exception {
        Document document;
        block2: {
            DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
            DocRef parent = new DocRef(this.form.getPath());
            PropertyMap properties = new PropertyMap();
            properties.set("rssi:author", this.form.getAuthor());
            properties.set("rssi:category", this.form.getCategory());
            properties.set("rssi:description", this.form.getDescription());
            properties.set("dc:description", this.form.getDescription());
            properties.set("rssi:enclosure", this.form.getEnclosure());
            properties.set("rssi:guid", this.form.getGuid());
            properties.set("rssi:link", this.form.getLink());
            properties.set("rssi:pubDate", this.form.getPubDate());
            properties.set("rssi:source", this.form.getSourceRss());
            properties.set("rssi:title", this.form.getTitle());
            properties.set("dc:title", this.form.getTitle());
            properties.set("rssi:syncId", this.form.getIdConteneur());
            document = documentService.createDocument(parent, "RssItem", null, properties);
            if (this.form.getEnclosure() == null) break block2;
            URL url = new URL(this.form.getEnclosure());
            File file = File.createTempFile("rss-enclosure-", "tmp");
            BufferedInputStream in = null;
            BufferedOutputStream out = null;
            try {
                in = new BufferedInputStream(url.openStream());
                out = new BufferedOutputStream(new FileOutputStream(file));
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
            FileBlob blob = new FileBlob(file);
            documentService.setBlob((DocRef)document, (Blob)blob, "rssi:picture");
            file.delete();
        }
        return document;
    }

    public String getId() {
        return null;
    }
}

