/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.rss.common.utility;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.services.rss.common.model.FeedRssModel;
import org.osivia.services.rss.common.model.Picture;
import org.osivia.services.rss.feedRss.portlet.model.ItemRssModel;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

public class RssUtility {
    protected static final Log logger = LogFactory.getLog(RssUtility.class);
    static final String TITLE = "title";
    static final String DESCRIPTION = "description";
    static final String CHANNEL = "channel";
    static final String LINK = "link";
    static final String AUTHOR = "author";
    static final String ITEM = "item";
    static final String PUB_DATE = "pubDate";
    static final String GUID = "guid";
    static final String CATEGORY = "category";
    static final String SOURCE = "source";
    static final String ENCLOSURE = "enclosure";

    public static List<ItemRssModel> readRss(FeedRssModel feed) {
        logger.info((Object)"Lecture du flux RSS");
        String description = "";
        String title = "";
        String link = "";
        String author = "";
        Date pubDate = null;
        String guid = "";
        String category = "";
        String enclosure = "";
        String sourceRss = "";
        Picture visual = null;
        String idConteneur = feed.getSyncId();
        ItemRssModel rss = null;
        ArrayList<ItemRssModel> list = new ArrayList<ItemRssModel>();
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy", Locale.ENGLISH);
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            URL url = null;
            try {
                url = new URL(feed.getUrl());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            InputStream in = RssUtility.read(url);
            XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    String localPart;
                    switch (localPart = event.asStartElement().getName().getLocalPart()) {
                        case "item": {
                            event = eventReader.nextEvent();
                            break;
                        }
                        case "title": {
                            title = RssUtility.getCharacterData(event, eventReader);
                            break;
                        }
                        case "link": {
                            link = RssUtility.getCharacterData(event, eventReader);
                            break;
                        }
                        case "description": {
                            description = RssUtility.getCharacterDataSanitazier(event, eventReader);
                            break;
                        }
                        case "author": {
                            author = RssUtility.getCharacterData(event, eventReader);
                            break;
                        }
                        case "category": {
                            category = RssUtility.getCharacterData(event, eventReader);
                            break;
                        }
                        case "enclosure": {
                            enclosure = RssUtility.getEnclosure(event, eventReader);
                            break;
                        }
                        case "guid": {
                            guid = RssUtility.getCharacterData(event, eventReader);
                            break;
                        }
                        case "pubDate": {
                            try {
                                pubDate = format.parse(RssUtility.getCharacterData(event, eventReader).substring(0, 16));
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case "source": {
                            sourceRss = RssUtility.getCharacterData(event, eventReader);
                        }
                    }
                    continue;
                }
                if (!event.isEndElement() || event.asEndElement().getName().getLocalPart() != ITEM) continue;
                rss = new ItemRssModel(title, link, description, author, pubDate, guid, idConteneur, category, enclosure, sourceRss, visual);
                list.add(rss);
                event = eventReader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public static String getCharacterData(XMLEvent event, XMLEventReader eventReader) throws XMLStreamException {
        String result = "";
        event = eventReader.nextEvent();
        if (event instanceof Characters) {
            result = event.asCharacters().getData();
        }
        return result;
    }

    public static String getCharacterDataSanitazier(XMLEvent event, XMLEventReader eventReader) throws XMLStreamException {
        String result = "";
        event = eventReader.nextEvent();
        if (event instanceof Characters) {
            PolicyFactory policy = new HtmlPolicyBuilder().allowElements(new String[]{"b", "i", "u", "em", "strong"}).toFactory();
            result = policy.sanitize(event.asCharacters().getData());
        }
        return result;
    }

    public static String getEnclosure(XMLEvent event, XMLEventReader eventReader) throws XMLStreamException {
        String result = "";
        QName hrefQName = new QName("", "url");
        result = event.asStartElement().getAttributeByName(hrefQName).getValue();
        return result;
    }

    public static InputStream read(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

