/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.rss.feedRss.portlet.controller;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.services.rss.common.model.ContainerRssModel;
import org.osivia.services.rss.common.validator.ContainerFormValidator;
import org.osivia.services.rss.feedRss.portlet.service.FeedService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"}, params={"edit=container"})
public class EditContainerController {
    @Autowired
    protected PortletContext portletContext;
    @Autowired
    public ApplicationContext applicationContext;
    @Autowired
    protected FeedService service;
    @Autowired
    private ContainerFormValidator formValidator;
    @Autowired
    protected IBundleFactory bundleFactory;
    @Autowired
    protected INotificationsService notificationsService;
    public static final String DOCID = "id";

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException {
        return "editContainer";
    }

    @ActionMapping(value="modif")
    public void add(ActionRequest request, ActionResponse response, @Validated @ModelAttribute(value="form") ContainerRssModel form, BindingResult result, SessionStatus status) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (result.hasErrors()) {
            response.setRenderParameter("edit", "container");
        } else {
            this.service.modifContainer(portalControllerContext, form);
            status.setComplete();
        }
    }

    @ActionMapping(value="del")
    public void del(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ContainerRssModel form, SessionStatus status) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.removeContainer(portalControllerContext, form);
        status.setComplete();
    }

    @InitBinder(value={"form"})
    public void formInitBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.formValidator});
    }

    @ModelAttribute(value="form")
    public ContainerRssModel getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getMapContainer(portalControllerContext);
    }
}

