/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.rss.common.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.rss.common.command.ItemCreatCommand;
import org.osivia.services.rss.common.command.ItemListCommand;
import org.osivia.services.rss.common.repository.ContainerRepository;
import org.osivia.services.rss.common.repository.ItemRepository;
import org.osivia.services.rss.feedRss.portlet.model.ItemRssModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Repository;

@Repository
@Scope(value="prototype")
public class ItemRepositoryImpl
implements ItemRepository {
    @Autowired
    private DocumentDAO documentDAO;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    public ContainerRepository repositoryContainer;
    String FEEDS_PROPERTY = "rssc:feeds";
    String DISPLAY_NAME_PROPERTY = "displayName";
    String URL_PROPERTY = "url";
    String ID_PROPERTY = "syncId";
    private static final String WEB_ID_PROPERTY = "ttc:webid";
    private static final String VIGNETTE_PROPERTY = "ttc:vignette";
    private static final String DESCRIPTION_PROPERTY = "dc:description";

    public void creatItem(PortalControllerContext portalControllerContext, ItemRssModel model) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(ItemCreatCommand.class, new Object[]{model});
        nuxeoController.executeNuxeoCommand(command);
    }

    private ItemRssModel fillItem(Document document, NuxeoController nuxeoController) {
        String id = document.getString("rssi:syncId");
        String title = document.getString("rssi:title");
        String link = document.getString("rssi:link");
        String description = document.getString(DESCRIPTION_PROPERTY);
        if (description != null && description.contains("<img")) {
            description = description.contains("<a") ? description.replaceAll("<a.*a>", "") : description.replaceAll("<img.*>", "");
        }
        String autor = document.getString("rssi:author");
        String category = document.getString("rssi:category");
        String enclosure = document.getString("rssi:enclosure");
        Date pubdate = document.getDate("rssi:pubDate");
        String guid = document.getString("rssi:guid");
        String sources = document.getString("rssi:source");
        ItemRssModel item = new ItemRssModel();
        item.setIdConteneur(id);
        item.setTitle(title);
        item.setLink(link);
        item.setDescription(description);
        item.setAuthor(autor);
        item.setCategory(category);
        item.setEnclosure(enclosure);
        item.setPubDate(pubdate);
        item.setGuid(guid);
        item.setSourceRss(sources);
        return item;
    }

    public void creatItems(PortalControllerContext portalControllerContext, List<ItemRssModel> items) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        for (ItemRssModel item : items) {
            item.setPath(nuxeoController.getCurrentDocumentContext().getCmsPath());
            INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(ItemCreatCommand.class, new Object[]{item});
            nuxeoController.executeNuxeoCommand(command);
        }
    }

    public void removeItems(PortalControllerContext portalControllerContext, List<ItemRssModel> items) throws PortletException {
    }

    public Map<String, String> getDocumentProperties(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        DocumentDTO dto = this.documentDAO.toDTO(portalControllerContext, document);
        PropertyMap vignettePropertyMap = document.getProperties().getMap(VIGNETTE_PROPERTY);
        String vignetteUrl = vignettePropertyMap == null || vignettePropertyMap.isEmpty() ? null : nuxeoController.createFileLink(document, VIGNETTE_PROPERTY);
        String icon = dto.getIcon();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("id", document.getString(WEB_ID_PROPERTY));
        properties.put("title", document.getTitle());
        properties.put("vignette", vignetteUrl);
        properties.put("icon", icon);
        properties.put("description", document.getString(DESCRIPTION_PROPERTY));
        return properties;
    }

    public List<ItemRssModel> getListItemRss(PortalControllerContext portalControllerContext, String syncid) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand nuxeoCommand = (INuxeoCommand)this.applicationContext.getBean(ItemListCommand.class, new Object[]{syncid});
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(nuxeoCommand);
        ArrayList<ItemRssModel> items = new ArrayList<ItemRssModel>(documents.size());
        for (Document document : documents) {
            ItemRssModel item = this.fillItem(document, nuxeoController);
            items.add(item);
        }
        return items;
    }
}

