/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.rss.feedRss.portlet.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.services.rss.common.model.ContainerRssModel;
import org.osivia.services.rss.common.model.FeedRssModel;
import org.osivia.services.rss.common.model.Picture;
import org.osivia.services.rss.common.repository.ContainerRepository;
import org.osivia.services.rss.common.repository.ItemRepository;
import org.osivia.services.rss.common.utility.RssUtility;
import org.osivia.services.rss.feedRss.portlet.repository.FeedRepository;
import org.osivia.services.rss.feedRss.portlet.service.FeedService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FeedServiceImpl
implements FeedService {
    @Autowired
    public FeedRepository repository;
    @Autowired
    public ItemRepository repositoryItem;
    @Autowired
    public ContainerRepository repositoryContainer;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    protected static final Log logger = LogFactory.getLog(FeedServiceImpl.class);

    public ContainerRssModel getListFeed(PortalControllerContext portalControllerContext) throws PortletException {
        return this.repository.getListFeedRss(portalControllerContext);
    }

    public void creatFeed(PortalControllerContext portalControllerContext, FeedRssModel model) throws PortletException {
        ContainerRssModel container = (ContainerRssModel)this.applicationContext.getBean(ContainerRssModel.class);
        ArrayList<FeedRssModel> list = new ArrayList<FeedRssModel>();
        list.add(model);
        container.setFeedSources(list);
        this.repository.creatFeed(portalControllerContext, container);
    }

    public void synchro(PortalControllerContext portalControllerContext) throws PortletException {
        ContainerRssModel model = this.repository.getListFeedRss(portalControllerContext);
        for (FeedRssModel feed : model.getFeedSources()) {
            List items = RssUtility.readRss((FeedRssModel)feed);
            if (items == null || items.size() < 1) continue;
            List itemsNuxeo = this.repositoryItem.getListItemRss(portalControllerContext, feed.getSyncId());
            ArrayList itemsSav = new ArrayList(items);
            if (itemsNuxeo.size() != 0) {
                items.removeAll(itemsNuxeo);
            }
            if (items != null && items.size() != 0) {
                this.repositoryItem.creatItems(portalControllerContext, items);
            }
            if (itemsNuxeo == null) continue;
            itemsNuxeo.removeAll(itemsSav);
            if (itemsNuxeo == null || itemsNuxeo.size() == 0) continue;
            this.repositoryItem.removeItems(portalControllerContext, itemsNuxeo);
        }
    }

    public Document getCurrentDocument(PortalControllerContext portalControllerContext) throws PortletException {
        return this.repository.getCurrentDocument(portalControllerContext);
    }

    public Map<String, String> getMapFeed(PortalControllerContext portalControllerContext) throws PortletException {
        Map map = this.repository.getMapFeed(portalControllerContext);
        return map;
    }

    public FeedRssModel getMapFeed(PortalControllerContext portalControllerContext, String id, String name, String url, int index) throws PortletException {
        FeedRssModel mod = this.repository.getMapFeed(portalControllerContext, id, name, url, index);
        return mod;
    }

    public void modFeed(PortalControllerContext portalControllerContext, FeedRssModel model) throws PortletException {
        this.repository.modFeed(portalControllerContext, model);
    }

    public void delFeed(PortalControllerContext portalControllerContext, FeedRssModel model) throws PortletException {
        this.repository.delFeed(portalControllerContext, model);
    }

    public ContainerRssModel getMapContainer(PortalControllerContext portalControllerContext) throws PortletException {
        ContainerRssModel container = (ContainerRssModel)this.applicationContext.getBean(ContainerRssModel.class);
        Document doc = this.repository.getCurrentDocument(portalControllerContext);
        container.setPath(doc.getPath());
        container.setName(doc.getTitle());
        container.setDocId(doc.getId());
        Set map = this.repositoryContainer.getMapContainer(portalControllerContext);
        container.setMap(map);
        return container;
    }

    public void modifContainer(PortalControllerContext portalControllerContext, ContainerRssModel model) throws PortletException, IOException {
        this.repositoryContainer.modifContainer(portalControllerContext, model);
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        String redirectionUrl = this.getRedirectionUrl(portalControllerContext, false, model.getPath());
        response.sendRedirect(redirectionUrl);
    }

    public void removeContainer(PortalControllerContext portalControllerContext, ContainerRssModel model) throws PortletException, IOException {
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        String docid = model.getDocId();
        this.repositoryContainer.remove(portalControllerContext, docid);
        String path = StringUtils.substringBeforeLast((String)model.getPath(), (String)"/");
        String redirectionUrl = this.getRedirectionUrl(portalControllerContext, false, path);
        response.sendRedirect(redirectionUrl);
    }

    private String getRedirectionUrl(PortalControllerContext portalControllerContext, boolean refresh, String path) throws PortletException {
        return this.portalUrlFactory.getCMSUrl(portalControllerContext, null, path, null, null, "refreshPageAndNavigation", null, null, null, null);
    }

    public void uploadVisual(PortalControllerContext portalControllerContext, FeedRssModel form) throws PortletException, IOException {
        Picture visual = form.getVisual();
        visual.setUpdated(true);
        visual.setDeleted(false);
        MultipartFile upload = visual.getUpload();
        File temporaryFile = File.createTempFile("visual-", ".tmp");
        temporaryFile.deleteOnExit();
        upload.transferTo(temporaryFile);
        visual.setTemporaryFile(temporaryFile);
        form.setVisual(visual);
    }

    public void deleteVisual(PortalControllerContext portalControllerContext, FeedRssModel form) throws PortletException {
        Picture visual = form.getVisual();
        visual.setUpdated(false);
        visual.setDeleted(true);
    }

    public void setVisual(PortalControllerContext portalControllerContext, FeedRssModel form) throws PortletException {
    }
}

