/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.rss.common.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PathRef;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.rss.common.utility.RssUtility;
import org.osivia.services.rss.feedRss.portlet.model.ItemRssModel;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CreateRssItemsCommand
implements INuxeoCommand {
    private final String parentPath;
    private final List<ItemRssModel> items;
    private final Log log;

    public CreateRssItemsCommand(String parentPath, List<ItemRssModel> items) {
        this.parentPath = parentPath;
        this.items = items;
        this.log = LogFactory.getLog(this.getClass());
    }

    public Object execute(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        PathRef parent = new PathRef(this.parentPath);
        for (ItemRssModel item : this.items) {
            try {
                this.createItem(documentService, (DocRef)parent, item);
            }
            catch (Exception e) {
                this.log.error((Object)e.getLocalizedMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createItem(DocumentService documentService, DocRef parent, ItemRssModel item) throws Exception {
        block6: {
            URL url;
            PropertyMap properties = new PropertyMap();
            properties.set("rssi:author", item.getAuthor());
            properties.set("rssi:category", item.getCategory());
            properties.set("rssi:description", item.getDescription());
            properties.set("dc:description", item.getDescription());
            properties.set("rssi:enclosure", item.getEnclosure());
            properties.set("rssi:guid", item.getGuid());
            properties.set("rssi:link", item.getLink());
            properties.set("rssi:pubDate", item.getPubDate());
            properties.set("rssi:source", item.getSourceRss());
            properties.set("rssi:title", item.getTitle());
            properties.set("dc:title", item.getTitle());
            properties.set("rssi:syncId", item.getIdConteneur());
            Document document = documentService.createDocument(parent, "RssItem", null, properties);
            if (StringUtils.isBlank((String)item.getEnclosure())) {
                url = null;
            } else {
                try {
                    url = new URL(item.getEnclosure());
                }
                catch (MalformedURLException e) {
                    url = null;
                    this.log.error((Object)e.getLocalizedMessage());
                }
            }
            if (url == null) break block6;
            File file = File.createTempFile("rss-enclosure-", "tmp");
            BufferedInputStream in = null;
            BufferedOutputStream out = null;
            Proxy proxy = RssUtility.getProxy();
            try {
                URLConnection urlConnection = url.openConnection(proxy);
                in = new BufferedInputStream(urlConnection.getInputStream());
                out = new BufferedOutputStream(new FileOutputStream(file));
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
            FileBlob blob = new FileBlob(file);
            documentService.setBlob((DocRef)document, (Blob)blob, "rssi:picture");
            file.delete();
        }
    }

    public String getId() {
        return null;
    }
}

