/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.rss.feedRss.portlet.validator;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.osivia.services.rss.common.model.FeedRssModel;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class FeedFormValidator
implements Validator {
    public boolean supports(Class<?> clazz) {
        return FeedRssModel.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        FeedRssModel form = (FeedRssModel)target;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"url", (String)"NotEmpty");
        if (!errors.hasFieldErrors()) {
            try {
                new URL(form.getUrl()).toURI();
            }
            catch (MalformedURLException | URISyntaxException e) {
                errors.rejectValue("url", "Invalid");
            }
            if (form.getMap().containsValue(form.getUrl())) {
                errors.rejectValue("url", "Duplicated");
            }
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"displayName", (String)"NotEmpty");
        if (form.getMap().containsKey(form.getDisplayName())) {
            errors.rejectValue("displayName", "Duplicated");
        }
    }

    public static boolean isValid(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

