/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.search.selector.scope.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.search.selector.scope.portlet.model.ScopeSelectorForm;
import org.osivia.services.search.selector.scope.portlet.model.ScopeSelectorSettings;
import org.osivia.services.search.selector.scope.portlet.model.SearchScope;
import org.osivia.services.search.selector.scope.portlet.repository.ScopeSelectorRepository;
import org.osivia.services.search.selector.scope.portlet.service.ScopeSelectorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ScopeSelectorServiceImpl
implements ScopeSelectorService {
    private static final String LABEL_WINDOW_PROPERTY = "foad.scope-selector.label";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ScopeSelectorRepository repository;

    public ScopeSelectorSettings getSettings(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        ScopeSelectorSettings settings = (ScopeSelectorSettings)this.applicationContext.getBean(ScopeSelectorSettings.class);
        String label = window.getProperty(LABEL_WINDOW_PROPERTY);
        settings.setLabel(label);
        settings.setSelectorId("scope");
        return settings;
    }

    public void save(PortalControllerContext portalControllerContext, ScopeSelectorSettings settings) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String label = StringUtils.trimToNull((String)settings.getLabel());
        window.setProperty(LABEL_WINDOW_PROPERTY, label);
    }

    public ScopeSelectorForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        boolean empty;
        PortletRequest request = portalControllerContext.getRequest();
        ScopeSelectorSettings settings = this.getSettings(portalControllerContext);
        Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
        List selectorValues = (List)selectors.get("scope");
        if (CollectionUtils.isEmpty((Collection)selectorValues)) {
            empty = true;
        } else {
            String selectorValue = (String)selectorValues.get(0);
            empty = StringUtils.isEmpty((String)selectorValue);
        }
        ScopeSelectorForm form = (ScopeSelectorForm)this.applicationContext.getBean(ScopeSelectorForm.class);
        String label = settings.getLabel();
        form.setLabel(label);
        SearchScope scope = empty ? SearchScope.GLOBAL : SearchScope.LOCAL;
        form.setScope(scope);
        List<SearchScope> scopes = Arrays.asList(SearchScope.values());
        form.setScopes(scopes);
        return form;
    }

    public void select(PortalControllerContext portalControllerContext, ScopeSelectorForm form) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        ScopeSelectorSettings settings = this.getSettings(portalControllerContext);
        String selectorId = settings.getSelectorId();
        if (StringUtils.isNotEmpty((String)selectorId)) {
            Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
            SearchScope scope = form.getScope();
            if (SearchScope.LOCAL.equals((Object)scope)) {
                Document root = this.repository.getRoot(portalControllerContext);
                String rootPath = root.getPath();
                if (StringUtils.isEmpty((String)rootPath)) {
                    selectors.remove(selectorId);
                } else {
                    ArrayList<String> selectorValues = new ArrayList<String>(1);
                    selectorValues.add(rootPath);
                    selectors.put(selectorId, selectorValues);
                }
            } else {
                selectors.remove(selectorId);
            }
            response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
        }
    }
}

