/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.statistics.repository;

import bsh.EvalError;
import bsh.Interpreter;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.statistics.model.StatisticsConfiguration;
import org.osivia.services.statistics.model.StatisticsVersion;
import org.osivia.services.statistics.repository.IStatisticsRepository;
import org.osivia.services.statistics.repository.ListDocumentsCommand;
import org.osivia.services.statistics.repository.StatisticsRepositoryImpl;
import org.osivia.services.statistics.util.NXQLFormater;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class StatisticsRepositoryImpl
implements IStatisticsRepository {
    private static final String PERIODS_NUMBER_WINDOW_PROPERTY = "osivia.statistics.number";
    private static final String REQUEST_WINDOW_PROPERTY = "osivia.statistics.request";
    private static final String VERSION_WINDOW_PROPERTY = "osivia.statistics.version";
    private final IBundleFactory bundleFactory;

    public StatisticsRepositoryImpl() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public StatisticsConfiguration getConfiguration(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        StatisticsConfiguration configuration = new StatisticsConfiguration();
        configuration.setNumber(NumberUtils.toInt((String)window.getProperty("osivia.statistics.number")));
        configuration.setRequest(window.getProperty("osivia.statistics.request"));
        configuration.setVersion(StatisticsVersion.fromName((String)window.getProperty("osivia.statistics.version")));
        return configuration;
    }

    public void saveConfiguration(PortalControllerContext portalControllerContext, StatisticsConfiguration configuration) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        window.setProperty("osivia.statistics.number", String.valueOf(configuration.getNumber()));
        window.setProperty("osivia.statistics.request", StringUtils.trimToNull((String)configuration.getRequest()));
        window.setProperty("osivia.statistics.version", configuration.getVersion().getName());
    }

    public Map<String, Integer[]> getDocumentsCountsByPeriods(PortalControllerContext portalControllerContext, StatisticsConfiguration configuration) throws PortletException {
        Integer[] counts;
        LinkedHashMap<String, Integer[]> results = new LinkedHashMap<String, Integer[]>(configuration.getNumber());
        Locale locale = portalControllerContext.getRequest().getLocale();
        List periods = this.getPeriods(2, configuration.getNumber() + 1, locale);
        Iterator iterator = periods.iterator();
        Period firstPeriod = (Period)iterator.next();
        Period period = (Period)iterator.next();
        int periodCount = 0;
        int aggregateCount = 0;
        List documents = this.getDocuments(portalControllerContext, configuration);
        for (Document document : documents) {
            Date date = document.getDate("dc:created");
            if (date == null) continue;
            if (firstPeriod != null) {
                if (Period.access$000((Period)firstPeriod).after(date)) {
                    ++aggregateCount;
                    continue;
                }
                firstPeriod = null;
            }
            while (Period.access$000((Period)period).before(date) && iterator.hasNext()) {
                Integer[] counts2 = new Integer[]{periodCount, aggregateCount};
                results.put(Period.access$100((Period)period), counts2);
                period = (Period)iterator.next();
                periodCount = 0;
            }
            ++periodCount;
            ++aggregateCount;
        }
        while (iterator.hasNext()) {
            counts = new Integer[]{periodCount, aggregateCount};
            results.put(Period.access$100((Period)period), counts);
            period = (Period)iterator.next();
        }
        counts = new Integer[]{periodCount, aggregateCount};
        results.put(Period.access$100((Period)period), counts);
        return results;
    }

    private NuxeoController getNuxeoController(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        PortletContext portletContext = portalControllerContext.getPortletCtx();
        return new NuxeoController(request, response, portletContext);
    }

    private List<Period> getPeriods(int type, int number, Locale locale) {
        DateFormat dateFormat;
        Object[] periods = new Period[number];
        Calendar calendar = GregorianCalendar.getInstance(locale);
        if (3 == type) {
            int firstDayOfWeek = calendar.getFirstDayOfWeek();
            while (calendar.get(7) != firstDayOfWeek) {
                calendar.add(5, -1);
            }
            calendar = DateUtils.truncate((Calendar)calendar, (int)5);
        } else {
            calendar = DateUtils.truncate((Calendar)calendar, (int)type);
        }
        if (3 == type) {
            Bundle bundle = this.bundleFactory.getBundle(locale);
            dateFormat = new SimpleDateFormat("'" + bundle.getString("WEEK") + "' w", locale);
        } else {
            dateFormat = 2 == type ? new SimpleDateFormat("MMM yyyy") : SimpleDateFormat.getDateInstance(2, locale);
        }
        for (int i = 0; i < number; ++i) {
            Date date = calendar.getTime();
            Period period = new Period(this);
            Period.access$102((Period)period, (String)dateFormat.format(date));
            Period.access$002((Period)period, (Date)date);
            periods[i] = period;
            calendar.add(type, -1);
        }
        CollectionUtils.reverseArray((Object[])periods);
        return Arrays.asList(periods);
    }

    private List<Document> getDocuments(PortalControllerContext portalControllerContext, StatisticsConfiguration configuration) throws PortletException {
        List<Object> results;
        String request;
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        try {
            request = this.beanShellInterpretation(nuxeoController, configuration);
        }
        catch (EvalError e) {
            throw new PortletException((Throwable)e);
        }
        if (request != null) {
            NuxeoQueryFilterContext filter = configuration.getVersion().getFilter();
            ListDocumentsCommand command = new ListDocumentsCommand(request, filter);
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            results = documents.list();
        } else {
            results = new ArrayList<Document>(0);
        }
        return results;
    }

    private String beanShellInterpretation(NuxeoController nuxeoController, StatisticsConfiguration configuration) throws EvalError {
        String result = null;
        String request = configuration.getRequest();
        if (!StringUtils.contains((String)request, (String)"basePath") || nuxeoController.getBasePath() != null) {
            PortletRequest portletRequest = nuxeoController.getRequest();
            Interpreter interpreter = new Interpreter();
            interpreter.set("params", (Object)PageSelectors.decodeProperties((String)portletRequest.getParameter("selectors")));
            interpreter.set("basePath", (Object)nuxeoController.getBasePath());
            interpreter.set("NXQLFormater", (Object)new NXQLFormater());
            result = (String)interpreter.eval(request);
        }
        return result;
    }
}

