/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.taskbar.common.repository;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.panels.PanelPlayer;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.taskbar.common.model.Task;
import org.osivia.services.taskbar.common.model.TaskbarConfiguration;
import org.osivia.services.taskbar.common.model.TaskbarView;
import org.osivia.services.taskbar.common.repository.ITaskbarRepository;
import org.springframework.stereotype.Repository;

@Repository
public class TaskbarRepositoryImpl
implements ITaskbarRepository {
    private static final String ORDER_WINDOW_PROPERTY = "osivia.taskbar.order";
    private static final String VIEW_WINDOW_PROPERTY = "osivia.taskbar.view";
    private static final String ORDER_SEPARATOR = "|";
    private final ITaskbarService taskbarService = (ITaskbarService)Locator.findMBean(ITaskbarService.class, (String)"osivia:service=TaskbarService");
    private final IPortalUrlFactory portalURLFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final IBundleFactory bundleFactory;

    public TaskbarRepositoryImpl() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public TaskbarConfiguration getConfiguration(PortalControllerContext portalControllerContext) throws PortletException {
        List<String> order;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        TaskbarConfiguration configuration = new TaskbarConfiguration();
        String orderProperty = window.getProperty(ORDER_WINDOW_PROPERTY);
        if (orderProperty == null) {
            order = this.initOrder();
            window.setProperty(ORDER_WINDOW_PROPERTY, StringUtils.join(order, (String)ORDER_SEPARATOR));
        } else {
            order = Arrays.asList(StringUtils.split((String)orderProperty, (String)ORDER_SEPARATOR));
        }
        configuration.setOrder(order);
        TaskbarView view = TaskbarView.fromName((String)window.getProperty(VIEW_WINDOW_PROPERTY));
        configuration.setView(view);
        return configuration;
    }

    private List<String> initOrder() {
        ArrayList<String> orderedTasks = new ArrayList<String>(2);
        orderedTasks.add("HOME");
        orderedTasks.add("CMS_NAVIGATION");
        return orderedTasks;
    }

    public void saveConfiguration(PortalControllerContext portalControllerContext, TaskbarConfiguration configuration) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        window.setProperty(ORDER_WINDOW_PROPERTY, StringUtils.join((Collection)configuration.getOrder(), (String)ORDER_SEPARATOR));
        window.setProperty(VIEW_WINDOW_PROPERTY, configuration.getView().getName());
    }

    public List<TaskbarTask> getNavigationTasks(PortalControllerContext portalControllerContext) throws PortletException {
        List<Object> navigationTasks;
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        String basePath = nuxeoController.getBasePath();
        if (StringUtils.isEmpty((String)basePath)) {
            navigationTasks = new ArrayList<TaskbarTask>(0);
        } else {
            try {
                navigationTasks = this.taskbarService.getNavigationTasks(portalControllerContext, basePath);
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
        }
        return navigationTasks;
    }

    public List<TaskbarTask> getCustomTasks(PortalControllerContext portalControllerContext) throws PortletException {
        try {
            return this.taskbarService.getCustomTasks(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void updateTasks(PortalControllerContext portalControllerContext, List<Task> tasks) throws PortletException {
        String activeId;
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        try {
            activeId = this.taskbarService.getActiveId(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        for (Task task : tasks) {
            task.setActive(StringUtils.equals((String)activeId, (String)task.getId()));
            this.updateTaskName(portalControllerContext, task);
            if ("HOME".equals(task.getId())) {
                task.setPath(nuxeoController.getBasePath());
            }
            if (task.getPath() != null) {
                String url = this.portalURLFactory.getCMSUrl(portalControllerContext, null, task.getPath(), null, null, "taskbar", null, null, "1", null);
                task.setUrl(url);
                continue;
            }
            if (task.getMaximizedPlayer() == null) continue;
            PanelPlayer player = task.getMaximizedPlayer();
            HashMap<String, String> properties = new HashMap<String, String>();
            if (player.getProperties() != null) {
                properties.putAll(player.getProperties());
            }
            properties.put("osivia.taskbar.id", task.getId());
            if (task.getName() != null) {
                properties.put("osivia.title", task.getName());
            }
            properties.put("osivia.back.reset", String.valueOf(true));
            properties.put("osivia.navigation.reset", String.valueOf(true));
            try {
                String url = this.portalURLFactory.getStartPortletUrl(portalControllerContext, player.getInstance(), properties, false);
                task.setUrl(url);
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    public void updateTaskName(PortalControllerContext portalControllerContext, Task task) throws PortletException {
        Locale locale;
        Bundle bundle;
        String name;
        if (task.getKey() != null && (name = (bundle = this.bundleFactory.getBundle(locale = portalControllerContext.getRequest().getLocale())).getString(task.getKey())) != null) {
            task.setName(name);
        }
    }

    private NuxeoController getNuxeoController(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        PortletContext portletContext = portalControllerContext.getPortletCtx();
        return new NuxeoController(request, response, portletContext);
    }
}

