/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.taskbar.common.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletException;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.panels.IPanelsService;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.services.taskbar.common.model.Task;
import org.osivia.services.taskbar.common.model.TaskbarConfiguration;
import org.osivia.services.taskbar.common.repository.ITaskbarRepository;
import org.osivia.services.taskbar.common.service.ITaskbarPortletService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskbarPortletServiceImpl
implements ITaskbarPortletService {
    @Autowired
    private ITaskbarRepository taskbarRepository;
    private final IPanelsService panelsService = (IPanelsService)Locator.findMBean(IPanelsService.class, (String)"osivia:service=PanelsService");

    public List<Task> getTasks(PortalControllerContext portalControllerContext) throws PortletException {
        TaskbarConfiguration configuration = this.taskbarRepository.getConfiguration(portalControllerContext);
        List order = configuration.getOrder();
        List cmsTasks = this.taskbarRepository.getNavigationTasks(portalControllerContext);
        List customTasks = this.taskbarRepository.getCustomTasks(portalControllerContext);
        HashMap<String, TaskbarTask> customTasksMap = new HashMap<String, TaskbarTask>(customTasks.size());
        for (TaskbarTask customTask : customTasks) {
            customTasksMap.put(customTask.getId(), customTask);
        }
        ArrayList<Task> tasks = new ArrayList<Task>(Math.max(cmsTasks.size() + order.size() - 1, 0));
        for (String id : order) {
            if ("CMS_NAVIGATION".equals(id)) {
                for (TaskbarTask cmsTask : cmsTasks) {
                    Task task = new Task(cmsTask);
                    tasks.add(task);
                }
                continue;
            }
            TaskbarTask customTask = (TaskbarTask)customTasksMap.get(id);
            if (customTask == null) continue;
            Task task = new Task(customTask);
            tasks.add(task);
        }
        return tasks;
    }

    public void updateTasks(PortalControllerContext portalControllerContext, List<Task> tasks) throws PortletException {
        this.taskbarRepository.updateTasks(portalControllerContext, tasks);
    }

    public Task start(PortalControllerContext portalControllerContext, String id) throws PortletException {
        Task result = null;
        List tasks = this.getTasks(portalControllerContext);
        for (Task task : tasks) {
            if (!id.equals(task.getId())) continue;
            result = task;
            break;
        }
        if (result != null) {
            ArrayList<Task> results = new ArrayList<Task>(1);
            results.add(result);
            this.taskbarRepository.updateTasks(portalControllerContext, results);
        }
        try {
            this.panelsService.resetTaskDependentPanels(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return result;
    }

    public List<Task> getOrderedTasks(PortalControllerContext portalControllerContext) throws PortletException {
        TaskbarConfiguration configuration = this.taskbarRepository.getConfiguration(portalControllerContext);
        List order = configuration.getOrder();
        List customTasks = this.taskbarRepository.getCustomTasks(portalControllerContext);
        HashMap<String, TaskbarTask> customTasksMap = new HashMap<String, TaskbarTask>(customTasks.size());
        for (TaskbarTask customTask : customTasks) {
            customTasksMap.put(customTask.getId(), customTask);
        }
        ArrayList<Task> orderedTasks = new ArrayList<Task>(order.size());
        for (String id : order) {
            TaskbarTask customTask;
            Object task = "CMS_NAVIGATION".equals(id) ? this.createNavigationTask() : ((customTask = (TaskbarTask)customTasksMap.get(id)) != null ? new Task(customTask) : null);
            if (task == null) continue;
            this.taskbarRepository.updateTaskName(portalControllerContext, task);
            orderedTasks.add((Task)task);
        }
        return orderedTasks;
    }

    public List<Task> getAvailableTasks(PortalControllerContext portalControllerContext) throws PortletException {
        TaskbarConfiguration configuration = this.taskbarRepository.getConfiguration(portalControllerContext);
        List order = configuration.getOrder();
        List customTasks = this.taskbarRepository.getCustomTasks(portalControllerContext);
        ArrayList<Task> availableTasks = new ArrayList<Task>(customTasks.size() + 1);
        if (!order.contains("CMS_NAVIGATION")) {
            Task task = this.createNavigationTask();
            this.taskbarRepository.updateTaskName(portalControllerContext, task);
            availableTasks.add(task);
        }
        for (TaskbarTask customTask : customTasks) {
            if (order.contains(customTask.getId())) continue;
            Task task = new Task(customTask);
            this.taskbarRepository.updateTaskName(portalControllerContext, task);
            availableTasks.add(task);
        }
        return availableTasks;
    }

    private Task createNavigationTask() {
        Task task = new Task();
        task.setId("CMS_NAVIGATION");
        task.setKey("CMS_NAVIGATION_TASK");
        task.setIcon("glyphicons glyphicons-magic");
        return task;
    }

    public TaskbarConfiguration getConfiguration(PortalControllerContext portalControllerContext) throws PortletException {
        return this.taskbarRepository.getConfiguration(portalControllerContext);
    }

    public void saveConfiguration(PortalControllerContext portalControllerContext, TaskbarConfiguration configuration) throws PortletException {
        this.taskbarRepository.saveConfiguration(portalControllerContext, configuration);
    }
}

