/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.taskbar.portlet.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.portlet.PortalGenericPortlet;
import org.osivia.services.taskbar.common.model.TaskbarConfiguration;
import org.osivia.services.taskbar.common.model.TaskbarView;
import org.osivia.services.taskbar.common.service.ITaskbarPortletService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"ADMIN"})
public class TaskbarAdminController
extends PortalGenericPortlet
implements PortletContextAware {
    private PortletContext portletContext;
    @Autowired
    private ITaskbarPortletService taskbarService;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        List orderedTasks = this.taskbarService.getOrderedTasks(portalControllerContext);
        request.setAttribute("orderedTasks", (Object)orderedTasks);
        List availableTasks = this.taskbarService.getAvailableTasks(portalControllerContext);
        request.setAttribute("availableTasks", (Object)availableTasks);
        return "admin";
    }

    @ActionMapping(value="save")
    public void save(ActionRequest request, ActionResponse response, @ModelAttribute(value="configuration") TaskbarConfiguration configuration, @RequestParam(value="order") String order) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        configuration.setOrder(Arrays.asList(StringUtils.split((String)order, (String)"|")));
        this.taskbarService.saveConfiguration(portalControllerContext, configuration);
        response.setWindowState(WindowState.NORMAL);
        response.setPortletMode(PortletMode.VIEW);
    }

    @ModelAttribute(value="configuration")
    public TaskbarConfiguration getConfiguration(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.taskbarService.getConfiguration(portalControllerContext);
    }

    @ModelAttribute(value="order")
    public String getOrder(PortletRequest request, PortletResponse response, @ModelAttribute(value="configuration") TaskbarConfiguration configuration) {
        return StringUtils.join((Collection)configuration.getOrder(), (String)"|");
    }

    @ModelAttribute(value="views")
    public List<TaskbarView> getViews(PortletRequest request, PortletResponse response) throws PortletException {
        return Arrays.asList(TaskbarView.values());
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }
}

