/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.taskbar.common.service;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletException;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.panels.IPanelsService;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItemType;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.services.taskbar.common.model.Task;
import org.osivia.services.taskbar.common.model.TaskbarConfiguration;
import org.osivia.services.taskbar.common.repository.ITaskbarRepository;
import org.osivia.services.taskbar.common.service.ITaskbarPortletService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskbarPortletServiceImpl
implements ITaskbarPortletService {
    @Autowired
    private ITaskbarRepository taskbarRepository;
    private final IPanelsService panelsService = (IPanelsService)Locator.findMBean(IPanelsService.class, (String)"osivia:service=PanelsService");

    public List<Task> getTasks(PortalControllerContext portalControllerContext) throws PortletException {
        TaskbarConfiguration configuration = this.taskbarRepository.getConfiguration(portalControllerContext);
        List order = configuration.getOrder();
        ArrayList remainingIds = new ArrayList(order);
        remainingIds.remove("CMS_NAVIGATION");
        List navigationTasks = this.taskbarRepository.getNavigationTasks(portalControllerContext);
        ArrayList<Object> displayedTasks = new ArrayList<Object>(navigationTasks.size());
        for (TaskbarTask navigationTask : navigationTasks) {
            if (TaskbarItemType.TRANSVERSAL.equals((Object)navigationTask.getType())) {
                remainingIds.remove(navigationTask.getId());
            }
            if (navigationTask.isDisabled() || navigationTask.isHidden()) continue;
            displayedTasks.add(navigationTask);
        }
        if (!remainingIds.isEmpty()) {
            boolean bl;
            TaskbarItems items = this.taskbarRepository.getTaskbarItems(portalControllerContext);
            ArrayList<TaskbarTask> remainingTasks = new ArrayList<TaskbarTask>(remainingIds.size());
            boolean bl2 = true;
            for (String id : order) {
                TaskbarItem item;
                if ("CMS_NAVIGATION".equals(id)) {
                    displayedTasks.addAll(0, remainingTasks);
                    remainingTasks.clear();
                    bl = false;
                    continue;
                }
                if (!remainingIds.contains(id) || (item = items.get(id)) == null) continue;
                TaskbarTask remainingTask = this.taskbarRepository.createRemainingTask(portalControllerContext, item);
                remainingTasks.add(remainingTask);
            }
            if (bl) {
                displayedTasks.addAll(0, remainingTasks);
            } else {
                displayedTasks.addAll(remainingTasks);
            }
        }
        ArrayList<Task> tasks = new ArrayList<Task>(displayedTasks.size());
        for (TaskbarTask taskbarTask : displayedTasks) {
            Task task = new Task(taskbarTask);
            tasks.add(task);
        }
        return tasks;
    }

    public void updateTasks(PortalControllerContext portalControllerContext, List<Task> tasks) throws PortletException {
        this.taskbarRepository.updateTasks(portalControllerContext, tasks);
    }

    public Task start(PortalControllerContext portalControllerContext, String id) throws PortletException {
        Task result = null;
        List tasks = this.getTasks(portalControllerContext);
        for (Task task : tasks) {
            if (!id.equals(task.getId())) continue;
            result = task;
            break;
        }
        if (result != null) {
            ArrayList<Task> results = new ArrayList<Task>(1);
            results.add(result);
            this.taskbarRepository.updateTasks(portalControllerContext, results);
        }
        try {
            this.panelsService.resetTaskDependentPanels(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return result;
    }

    public List<TaskbarItem> getOrderedItems(PortalControllerContext portalControllerContext) throws PortletException {
        TaskbarConfiguration configuration = this.taskbarRepository.getConfiguration(portalControllerContext);
        List order = configuration.getOrder();
        TaskbarItems items = this.taskbarRepository.getTaskbarItems(portalControllerContext);
        ArrayList<TaskbarItem> orderedItems = new ArrayList<TaskbarItem>();
        for (String id : order) {
            TaskbarItem item;
            if ("CMS_NAVIGATION".equals(id)) {
                item = this.taskbarRepository.createVirtualItem(portalControllerContext);
            } else {
                item = items.get(id);
                if (item != null && !TaskbarItemType.TRANSVERSAL.equals((Object)item.getType())) {
                    item = null;
                }
            }
            if (item == null) continue;
            orderedItems.add(item);
        }
        return orderedItems;
    }

    public List<TaskbarItem> getAvailableItems(PortalControllerContext portalControllerContext) throws PortletException {
        TaskbarConfiguration configuration = this.taskbarRepository.getConfiguration(portalControllerContext);
        List order = configuration.getOrder();
        TaskbarItems items = this.taskbarRepository.getTaskbarItems(portalControllerContext);
        ArrayList<TaskbarItem> availableItems = new ArrayList<TaskbarItem>();
        if (!order.contains("CMS_NAVIGATION")) {
            TaskbarItem item = this.taskbarRepository.createVirtualItem(portalControllerContext);
            availableItems.add(item);
        }
        for (TaskbarItem item : items.getAll()) {
            if (!TaskbarItemType.TRANSVERSAL.equals((Object)item.getType()) || order.contains(item.getId())) continue;
            availableItems.add(item);
        }
        return availableItems;
    }

    public TaskbarConfiguration getConfiguration(PortalControllerContext portalControllerContext) throws PortletException {
        return this.taskbarRepository.getConfiguration(portalControllerContext);
    }

    public void saveConfiguration(PortalControllerContext portalControllerContext, TaskbarConfiguration configuration) throws PortletException {
        this.taskbarRepository.saveConfiguration(portalControllerContext, configuration);
    }
}

