/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.taskbar.portlet.service;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletException;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.panels.IPanelsService;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItemType;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.services.taskbar.portlet.model.Task;
import org.osivia.services.taskbar.portlet.model.TaskbarSettings;
import org.osivia.services.taskbar.portlet.repository.TaskbarRepository;
import org.osivia.services.taskbar.portlet.service.TaskbarPortletService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class TaskbarPortletServiceImpl
implements TaskbarPortletService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private TaskbarRepository repository;
    @Autowired
    private IPanelsService panelsService;

    public List<Task> getTasks(PortalControllerContext portalControllerContext, TaskbarSettings settings) throws PortletException {
        List order = settings.getOrder();
        ArrayList remainingIds = new ArrayList(order);
        remainingIds.remove("CMS_NAVIGATION");
        List navigationTasks = this.repository.getNavigationTasks(portalControllerContext);
        ArrayList<Object> displayedTasks = new ArrayList<Object>(navigationTasks.size());
        TaskbarTask searchTask = null;
        for (TaskbarTask navigationTask : navigationTasks) {
            if (TaskbarItemType.TRANSVERSAL.equals((Object)navigationTask.getType())) {
                remainingIds.remove(navigationTask.getId());
            }
            if (!navigationTask.isDisabled() && !navigationTask.isHidden()) {
                displayedTasks.add(navigationTask);
            }
            if (!"SEARCH".equals(navigationTask.getId())) continue;
            searchTask = navigationTask;
        }
        if (!remainingIds.isEmpty()) {
            boolean bl;
            TaskbarItems items = this.repository.getTaskbarItems(portalControllerContext);
            ArrayList<TaskbarTask> remainingTasks = new ArrayList<TaskbarTask>(remainingIds.size());
            boolean bl2 = true;
            for (String id : order) {
                if ("CMS_NAVIGATION".equals(id)) {
                    displayedTasks.addAll(0, remainingTasks);
                    remainingTasks.clear();
                    bl = false;
                    continue;
                }
                if (!remainingIds.contains(id)) continue;
                TaskbarItem item = items.get(id);
                if ("SEARCH".equals(id) && searchTask != null) {
                    remainingTasks.add(searchTask);
                    continue;
                }
                if (item == null) continue;
                TaskbarTask remainingTask = this.repository.createRemainingTask(portalControllerContext, item);
                remainingTasks.add(remainingTask);
            }
            if (bl) {
                displayedTasks.addAll(0, remainingTasks);
            } else {
                displayedTasks.addAll(remainingTasks);
            }
        }
        ArrayList<Task> tasks = new ArrayList<Task>(displayedTasks.size());
        for (TaskbarTask taskbarTask : displayedTasks) {
            Task task = (Task)this.applicationContext.getBean(Task.class, new Object[]{taskbarTask});
            tasks.add(task);
        }
        return tasks;
    }

    public void updateTasks(PortalControllerContext portalControllerContext, List<Task> tasks) throws PortletException {
        this.repository.updateTasks(portalControllerContext, tasks);
    }

    public Task start(PortalControllerContext portalControllerContext, TaskbarSettings settings, String id) throws PortletException {
        Task result = null;
        List tasks = this.getTasks(portalControllerContext, settings);
        for (Task task : tasks) {
            if (!id.equals(task.getId())) continue;
            result = task;
            break;
        }
        if (result != null) {
            ArrayList<Task> results = new ArrayList<Task>(1);
            results.add(result);
            this.repository.updateTasks(portalControllerContext, results);
        }
        try {
            this.panelsService.resetTaskDependentPanels(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return result;
    }

    public List<TaskbarItem> getOrderedItems(PortalControllerContext portalControllerContext) throws PortletException {
        TaskbarSettings settings = this.repository.getSettings(portalControllerContext);
        List order = settings.getOrder();
        TaskbarItems items = this.repository.getTaskbarItems(portalControllerContext);
        ArrayList<TaskbarItem> orderedItems = new ArrayList<TaskbarItem>();
        for (String id : order) {
            TaskbarItem item;
            if ("CMS_NAVIGATION".equals(id)) {
                item = this.repository.createVirtualItem(portalControllerContext);
            } else {
                item = items.get(id);
                if (item != null && !TaskbarItemType.TRANSVERSAL.equals((Object)item.getType()) && !"SEARCH".equals(id)) {
                    item = null;
                }
            }
            if (item == null) continue;
            orderedItems.add(item);
        }
        return orderedItems;
    }

    public List<TaskbarItem> getAvailableItems(PortalControllerContext portalControllerContext) throws PortletException {
        TaskbarSettings settings = this.repository.getSettings(portalControllerContext);
        List order = settings.getOrder();
        TaskbarItems items = this.repository.getTaskbarItems(portalControllerContext);
        ArrayList<TaskbarItem> availableItems = new ArrayList<TaskbarItem>();
        if (!order.contains("CMS_NAVIGATION")) {
            TaskbarItem item = this.repository.createVirtualItem(portalControllerContext);
            availableItems.add(item);
        }
        for (TaskbarItem item : items.getAll()) {
            if (!TaskbarItemType.TRANSVERSAL.equals((Object)item.getType()) && !"SEARCH".equals(item.getId()) || order.contains(item.getId())) continue;
            availableItems.add(item);
        }
        return availableItems;
    }

    public TaskbarSettings getSettings(PortalControllerContext portalControllerContext) throws PortletException {
        return this.repository.getSettings(portalControllerContext);
    }

    public void saveSettings(PortalControllerContext portalControllerContext, TaskbarSettings settings) throws PortletException {
        this.repository.saveSettings(portalControllerContext, settings);
    }
}

