/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.versions.portlet.service.impl;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.versions.portlet.command.CreateExplicitVersion;
import org.osivia.services.versions.portlet.command.GetListVersionsCommand;
import org.osivia.services.versions.portlet.command.RestoreVersionCommand;
import org.osivia.services.versions.portlet.dao.DataToModel;
import org.osivia.services.versions.portlet.model.Version;
import org.osivia.services.versions.portlet.model.Versions;
import org.osivia.services.versions.portlet.service.VersionsService;
import org.springframework.stereotype.Service;

@Service
public class VersionsServiceImpl
implements VersionsService {
    private DataToModel dataToModel = DataToModel.getInstance();

    public Versions getListVersions(PortletRequest request, PortletResponse response, PortletContext portletContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, portletContext);
        Document currentDoc = this.getCurrentDocument(request, response, portletContext);
        Documents versionsAsDocs = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new GetListVersionsCommand(currentDoc));
        return this.dataToModel.toVersions(versionsAsDocs);
    }

    public void restoreVersion(PortletRequest request, PortletResponse response, PortletContext portletContext, String versionId) {
        NuxeoController nuxeoController = new NuxeoController(request, response, portletContext);
        nuxeoController.executeNuxeoCommand((INuxeoCommand)new RestoreVersionCommand(versionId));
    }

    public void createVersion(PortletRequest request, PortletResponse response, PortletContext portletContext, Versions versions, Version form) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, portletContext);
        Document currentDocument = this.getCurrentDocument(request, response, portletContext);
        Document document = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new CreateExplicitVersion(currentDocument, form.getComment()));
        versions.add((Object)this.dataToModel.toVersion(document));
    }

    public Document getCurrentDocument(PortletRequest request, PortletResponse response, PortletContext portletContext) throws PortletException {
        String currentPath = request.getParameter("osivia.cms.contentPath");
        if (currentPath == null) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            currentPath = window.getProperty("osivia.cms.contentPath");
        }
        NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)portletContext, (String)currentPath);
        return documentContext.getDoc();
    }
}

