/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.plugin.player;

import fr.toutatice.portail.cms.nuxeo.api.FileBrowserView;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.player.INuxeoPlayerModule;
import fr.toutatice.portail.cms.nuxeo.api.plugin.PluginModule;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;
import org.osivia.portal.api.player.Player;

public class PictureBookPlayer
extends PluginModule
implements INuxeoPlayerModule {
    public PictureBookPlayer(PortletContext portletContext) {
        super(portletContext);
    }

    public Player getCMSPictureBookPlayer(DocumentContext<Document> documentContext) {
        Document doc = (Document)documentContext.getDoc();
        BasicPublicationInfos navigationInfos = (BasicPublicationInfos)documentContext.getPublicationInfos(BasicPublicationInfos.class);
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.title", doc.getTitle());
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.cms.displayLiveVersion", navigationInfos.getState().toString());
        windowProperties.put("osivia.cms.style", "picturebook");
        windowProperties.put("osivia.nuxeoRequest", NuxeoController.createFolderRequest(documentContext, (boolean)false));
        windowProperties.put("osivia.cms.pageSize", "24");
        windowProperties.put("osivia.cms.pageSizeMax", "96");
        windowProperties.put("osivia.cms.maxItems", "96");
        Player player = new Player();
        player.setWindowProperties(windowProperties);
        player.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return player;
    }

    public Player getCMSPlayer(DocumentContext<Document> documentContext) {
        Document document = (Document)documentContext.getDoc();
        if ("PictureBook".equals(document.getType())) {
            boolean workspace;
            BasicPublicationInfos navigationInfos = (BasicPublicationInfos)documentContext.getPublicationInfos(BasicPublicationInfos.class);
            boolean bl = workspace = navigationInfos.isContextualized() && navigationInfos.isLiveSpace();
            if (workspace) {
                Player properties = this.getNuxeoCustomizer().getCMSFileBrowser(documentContext);
                Map windowProperties = properties.getWindowProperties();
                windowProperties.put("osivia.title", document.getTitle());
                windowProperties.put("osivia.defaultView", FileBrowserView.THUMBNAILS.getName());
                return properties;
            }
            return this.getCMSPictureBookPlayer(documentContext);
        }
        return null;
    }
}

