/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.plugin.list;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.portlet.PortletModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.cms.impl.BasicPermissions;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.Notifications;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.widgets.plugin.util.UploadFilesCommand;

public class PicturebookTemplateModule
extends PortletModule {
    private static final int FILE_UPLOAD_NOTIFICATIONS_DURATION = 1000;
    private final INotificationsService notificationsService = (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");

    public PicturebookTemplateModule(PortletContext portletContext) {
        super(portletContext);
    }

    protected void doView(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty("osivia.cms.uri");
        if (StringUtils.isNotEmpty((String)path)) {
            NuxeoDocumentContext document = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)portletContext);
            request.setAttribute("editable", (Object)((BasicPermissions)document.getPermissions(BasicPermissions.class)).isEditableByUser());
            request.setAttribute("parentId", (Object)((BasicPublicationInfos)document.getPublicationInfos(BasicPublicationInfos.class)).getLiveId());
        }
    }

    public void processAction(PortalControllerContext portalControllerContext) throws PortletException {
        ActionRequest request = (ActionRequest)portalControllerContext.getRequest();
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        String action = request.getParameter("javax.portlet.action");
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, portalControllerContext.getPortletCtx());
        Bundle bundle = this.getBundleFactory().getBundle(request.getLocale());
        if (PortletMode.VIEW.equals((Object)request.getPortletMode()) && "fileUpload".equals(action)) {
            Notifications notifications;
            String parentId = request.getParameter("parentId");
            try {
                DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
                PortletFileUpload fileUpload = new PortletFileUpload((FileItemFactory)fileItemFactory);
                List fileItems = fileUpload.parseRequest(request);
                ArrayList<FileItem> acceptedFileItems = new ArrayList<FileItem>(fileItems.size());
                for (FileItem fileItem : fileItems) {
                    boolean accepted;
                    try {
                        MimeType mimeType = new MimeType(fileItem.getContentType());
                        String primaryType = mimeType.getPrimaryType();
                        accepted = "image".equals(primaryType);
                    }
                    catch (MimeTypeParseException e) {
                        accepted = false;
                    }
                    if (accepted) {
                        acceptedFileItems.add(fileItem);
                        continue;
                    }
                    Notifications rejectedFileNotifications = new Notifications(NotificationsType.WARNING, 1000);
                    rejectedFileNotifications.addMessage(bundle.getString("MESSAGE_FILE_UPLOAD_REJECTED_FILE", new Object[]{fileItem.getName()}));
                    this.notificationsService.addNotifications(portalControllerContext, rejectedFileNotifications);
                }
                if (!acceptedFileItems.isEmpty()) {
                    UploadFilesCommand command = new UploadFilesCommand(parentId, acceptedFileItems);
                    nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                    request.setAttribute("osivia.updateContents", (Object)"true");
                    notifications = new Notifications(NotificationsType.SUCCESS, 1000);
                    notifications.addMessage(bundle.getString("MESSAGE_FILE_UPLOAD_SUCCESS"));
                } else {
                    notifications = null;
                }
            }
            catch (FileUploadException e) {
                notifications = new Notifications(NotificationsType.ERROR, 1000);
                notifications.addMessage(bundle.getString("MESSAGE_FILE_UPLOAD_ERROR"));
            }
            this.notificationsService.addNotifications(portalControllerContext, notifications);
        }
    }
}

