/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.issued.portlet.controller;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.Date;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.widgets.issued.portlet.model.IssuedForm;
import org.osivia.services.widgets.issued.portlet.model.converter.DatePropertyEditor;
import org.osivia.services.widgets.issued.portlet.model.validation.IssuedFormValidator;
import org.osivia.services.widgets.issued.portlet.service.IssuedService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"form"})
public class IssuedController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private IssuedService service;
    @Autowired
    private DatePropertyEditor datePropertyEditor;
    @Autowired
    private IssuedFormValidator validator;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException {
        return "view";
    }

    @RenderMapping(params={"warning=true"})
    public String warning(RenderRequest request, RenderResponse response) throws PortletException {
        return "warning";
    }

    @ActionMapping(value="save")
    public void save(ActionRequest request, ActionResponse response, @Validated @ModelAttribute(value="form") IssuedForm form, BindingResult result, SessionStatus sessionStatus) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!result.hasErrors()) {
            sessionStatus.setComplete();
            this.service.save(portalControllerContext, form);
        }
    }

    @ModelAttribute(value="form")
    public IssuedForm getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    @InitBinder(value={"form"})
    public void formInitBinder(PortletRequestDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)this.datePropertyEditor);
        binder.addValidators(new Validator[]{this.validator});
        binder.setDisallowedFields(new String[]{"displayInformations"});
    }
}

