/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.issued.portlet.service;

import java.io.IOException;
import java.util.Date;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.widgets.issued.portlet.model.IssuedForm;
import org.osivia.services.widgets.issued.portlet.repository.IssuedRepository;
import org.osivia.services.widgets.issued.portlet.service.IssuedService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class IssuedServiceImpl
implements IssuedService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IssuedRepository repository;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;

    @Override
    public IssuedForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        String path = this.getCurrentPath(portalControllerContext);
        IssuedForm form = (IssuedForm)this.applicationContext.getBean(IssuedForm.class);
        Date date = this.repository.getIssuedDate(portalControllerContext, path);
        form.setDate(date);
        return form;
    }

    @Override
    public void save(PortalControllerContext portalControllerContext, IssuedForm form) throws PortletException, IOException {
        PortletRequest request = portalControllerContext.getRequest();
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        String path = this.getCurrentPath(portalControllerContext);
        boolean publish = this.repository.setIssuedDate(portalControllerContext, path, form.getDate());
        String message = bundle.getString("UPDATE_ISSUED_DATE_MESSAGE_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
        if (publish) {
            String url = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, path, null, null, "refreshPageAndNavigation", null, null, null, null);
            response.sendRedirect(url);
        } else {
            response.setRenderParameter("warning", String.valueOf(true));
        }
    }

    private String getCurrentPath(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = this.getWindow(portalControllerContext);
        return window.getProperty("osivia.issued.path");
    }

    private PortalWindow getWindow(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        return WindowFactory.getWindow((PortletRequest)request);
    }
}

