/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.plugin.ew;

import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindowHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class CriteriaListEditableWindow
extends EditableWindow {
    public static final String CRITERIA_LIST_SCHEMA = "crtlistfgt:criteriaListFragment";
    protected static final String CRITERIA_SEPARATOR = " and ";
    protected static final String CRITERION_LIST_SEPARATOR = ",";
    protected static final String CRITERION_EQUAL = " = ";
    protected static final String QUOTE = "'";

    public CriteriaListEditableWindow(String instancePortlet, String prefixWindow) {
        super(instancePortlet, prefixWindow);
    }

    public Map<String, String> fillProps(Document doc, PropertyMap fragment, Boolean modeEditionPage) {
        Map properties = super.fillGenericProps(doc, fragment, modeEditionPage);
        PropertyMap schema = this.getListSchema(doc, fragment);
        PropertyMap requestCriteria = (PropertyMap)schema.get("requestCriteria");
        String request = this.buildRequest(requestCriteria);
        properties.put("osivia.nuxeoRequest", request);
        properties.put("osivia.cms.displayLiveVersion", "__inherited");
        properties.put("osivia.cms.style", schema.getString("style"));
        properties.putAll(this.fillDisplayProperties(schema, new HashMap<String, String>()));
        properties.put("osivia.beanShell", String.valueOf(false));
        properties.put("osivia.cms.scope", null);
        properties.put("osivia.cms.hideMetaDatas", "1");
        properties.put("osivia.displayNuxeoRequest", String.valueOf(false));
        properties.put("osivia.cms.requestFilteringPolicy", null);
        properties.put("osivia.permaLinkRef", null);
        properties.put("osivia.rssLinkRef", null);
        properties.put("osivia.rssTitle", null);
        return properties;
    }

    protected PropertyMap getListSchema(Document doc, PropertyMap fragment) {
        return EditableWindowHelper.findSchemaByRefURI((Document)doc, (String)CRITERIA_LIST_SCHEMA, (String)fragment.getString("uri"));
    }

    protected Map<String, String> fillDisplayProperties(PropertyMap schema, Map<String, String> properties) {
        PropertyMap displayCriteria = (PropertyMap)schema.get("displayCriteria");
        properties.put("osivia.cms.maxItems", (String)displayCriteria.get("nbItems"));
        properties.put("osivia.cms.pageSize", (String)displayCriteria.get("nbItemsPerPage"));
        return properties;
    }

    private String buildRequest(PropertyMap requestCriteria) {
        String currentDocId = (String)requestCriteria.get("currentDocId");
        String currentSpaceId = (String)requestCriteria.get("currentSpaceId");
        Object docTypes = this.getDocTypes(requestCriteria);
        PropertyList keyWords = (PropertyList)requestCriteria.get("keyWords");
        String searchArea = (String)requestCriteria.get("searchArea");
        String order = (String)requestCriteria.get("order");
        String docTypesCriterion = this.getDocTypesCriterion(new StringBuffer(), docTypes);
        String keyWordsCriterion = this.getKeyWordsCriterion(new StringBuffer(), keyWords, StringUtils.isBlank((String)docTypesCriterion));
        String searchAreaCriterion = this.getSearchAreaCriterion(new StringBuffer(), searchArea, currentDocId, currentSpaceId, StringUtils.isBlank((String)docTypesCriterion) && keyWords.isEmpty());
        String orderCriterion = this.getOrderCriterion(new StringBuffer(), order);
        StringBuffer clause = new StringBuffer().append(docTypesCriterion).append(keyWordsCriterion).append(searchAreaCriterion).append(orderCriterion);
        return clause.toString();
    }

    protected Object getDocTypes(PropertyMap requestCriteria) {
        return requestCriteria.get("docTypes");
    }

    protected String getDocTypesCriterion(StringBuffer docTypesCriterion, Object docTypes) {
        PropertyList docTypesList;
        if (docTypes != null && docTypes instanceof PropertyList && !(docTypesList = (PropertyList)docTypes).isEmpty()) {
            docTypesCriterion.append(" ecm:primaryType in (").append(this.generateQuotedList(new StringBuffer(), docTypesList)).append(")");
        }
        return docTypesCriterion.toString();
    }

    protected String getKeyWordsCriterion(StringBuffer keyWordsCriterion, PropertyList keyWords, boolean firstCriterion) {
        String keywordsProperty = System.getProperty("nuxeo.keywords.property", "ttc:keywords");
        if (!keyWords.isEmpty()) {
            if (!firstCriterion) {
                keyWordsCriterion.append(CRITERIA_SEPARATOR);
            }
            keyWordsCriterion.append(keywordsProperty).append(" IN (").append(this.generateQuotedList(new StringBuffer(), keyWords)).append(")");
        }
        return keyWordsCriterion.toString();
    }

    protected String getSearchAreaCriterion(StringBuffer searchAreaCriterion, String searchArea, String currentDocId, String currentSpaceId, boolean firstCriterion) {
        if (StringUtils.isNotBlank((String)searchArea)) {
            if (!firstCriterion) {
                searchAreaCriterion.append(CRITERIA_SEPARATOR);
            }
            if ("ttc:spaceID".equals(searchArea)) {
                if (!StringUtils.isBlank((String)currentSpaceId)) {
                    searchAreaCriterion.append("ttc:spaceID").append(CRITERION_EQUAL).append(QUOTE).append(currentSpaceId).append(QUOTE);
                }
            } else {
                searchAreaCriterion.append(searchArea).append(CRITERION_EQUAL).append(QUOTE).append(currentDocId).append(QUOTE);
            }
        }
        return searchAreaCriterion.toString();
    }

    protected String getOrderCriterion(StringBuffer orderCriterion, String order) {
        if (StringUtils.isNotBlank((String)order)) {
            orderCriterion.append(" order by ").append(order);
        }
        return orderCriterion.toString();
    }

    protected StringBuffer generateQuotedList(StringBuffer criterion, PropertyList properties) {
        int index = 1;
        for (Object docType : properties.list()) {
            criterion.append(QUOTE).append((String)docType).append(QUOTE);
            if (index < properties.size()) {
                criterion.append(CRITERION_LIST_SEPARATOR);
            }
            ++index;
        }
        return criterion;
    }

    public List<String> prepareDelete(Document doc, String refURI) {
        ArrayList<String> propertiesToRemove = new ArrayList<String>();
        this.prepareDeleteGeneric(propertiesToRemove, doc, refURI);
        Integer indexToRemove = EditableWindowHelper.findIndexByRefURI((Document)doc, (String)CRITERIA_LIST_SCHEMA, (String)refURI);
        propertiesToRemove.add(CRITERIA_LIST_SCHEMA.concat("/").concat(indexToRemove.toString()));
        return propertiesToRemove;
    }
}

