/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.issued.plugin.service;

import fr.toutatice.portail.cms.nuxeo.api.ContextualizationHelper;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.Permissions;
import org.osivia.portal.api.cms.PublicationInfos;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.contribution.IContributionService;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.services.widgets.issued.plugin.model.IssuedMenubarModule;
import org.osivia.services.widgets.issued.plugin.service.IssuedPluginService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssuedPluginServiceImpl
implements IssuedPluginService {
    @Autowired
    private IssuedMenubarModule menubarModule;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IMenubarService menubarService;
    @Autowired
    private IBundleFactory bundleFactory;

    public void customizeMenubarModules(CustomizationContext customizationContext, List<MenubarModule> menubarModules) {
        menubarModules.add((MenubarModule)this.menubarModule);
    }

    public void addMenubarItem(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext documentContext) throws PortalException {
        if (this.accept(portalControllerContext, documentContext)) {
            HttpServletRequest servletRequest = portalControllerContext.getHttpServletRequest();
            Bundle bundle = this.bundleFactory.getBundle(servletRequest.getLocale());
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("osivia.issued.path", documentContext.getCmsPath());
            String id = "UPDATE_ISSUED_DATE";
            String title = bundle.getString("UPDATE_ISSUED_DATE_MENUBAR_ITEM");
            String icon = "glyphicons glyphicons-calendar";
            MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
            int order = 13;
            String url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "osivia-services-widgets-issued-instance", properties, PortalUrlType.MODAL);
            MenubarItem menubarItem = new MenubarItem(id, title, icon, (MenubarContainer)parent, order, "javascript:;", null, null, null);
            Map data = menubarItem.getData();
            data.put("target", "#osivia-modal");
            data.put("load-url", url);
            menubar.add(menubarItem);
        }
    }

    private boolean accept(PortalControllerContext portalControllerContext, DocumentContext documentContext) {
        boolean accept;
        if (ContextualizationHelper.isCurrentDocContextualized((PortalControllerContext)portalControllerContext) && documentContext != null && documentContext.getDocumentType() != null && !StringUtils.equals((String)"PortalSite", (String)documentContext.getDocumentType().getName())) {
            NuxeoDocumentContext nuxeoDocumentContext;
            PublicationInfos publicationInfos = documentContext.getPublicationInfos();
            Permissions permissions = documentContext.getPermissions();
            accept = !publicationInfos.isLiveSpace() && permissions.isEditable() ? (this.isLive(portalControllerContext, documentContext) ? true : (documentContext instanceof NuxeoDocumentContext ? !(nuxeoDocumentContext = (NuxeoDocumentContext)documentContext).isRemoteProxy() : true)) : false;
        } else {
            accept = false;
        }
        return accept;
    }

    private boolean isLive(PortalControllerContext portalControllerContext, DocumentContext documentContext) {
        PortletRequest request = portalControllerContext.getRequest();
        IContributionService.EditionState editionState = (IContributionService.EditionState)request.getAttribute("osivia.editionState");
        return editionState != null && documentContext != null && StringUtils.equals((String)IContributionService.EditionState.CONTRIBUTION_MODE_EDITION, (String)editionState.getContributionMode()) && StringUtils.equals((String)documentContext.getCmsPath(), (String)editionState.getDocPath());
    }
}

