/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.move.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import java.util.List;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.osivia.services.widgets.move.portlet.model.MoveWindowProperties;
import org.osivia.services.widgets.move.portlet.repository.MoveRepository;
import org.osivia.services.widgets.move.portlet.repository.command.MoveDocumentCommand;
import org.osivia.services.widgets.move.portlet.repository.command.RemoveAllPermissionsCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class MoveRepositoryImpl
implements MoveRepository {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ICMSServiceLocator cmsServiceLocator;

    public String getBasePath(PortalControllerContext portalControllerContext, MoveWindowProperties windowProperties) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        return nuxeoController.getComputedPath(windowProperties.getBasePath());
    }

    public String getNavigationPath(PortalControllerContext portalControllerContext, MoveWindowProperties windowProperties, String basePath) throws PortletException {
        CMSItem navigationItem;
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        String documentPath = windowProperties.getPath();
        if (StringUtils.isEmpty((String)documentPath)) {
            navigationItem = null;
        } else {
            try {
                navigationItem = cmsService.getPortalNavigationItem(cmsContext, basePath, documentPath);
                if (navigationItem == null) {
                    CMSObjectPath objectPath = CMSObjectPath.parse((String)documentPath);
                    CMSObjectPath parentObjectPath = objectPath.getParent();
                    navigationItem = cmsService.getPortalNavigationItem(cmsContext, basePath, parentObjectPath.toString());
                }
            }
            catch (CMSException e) {
                throw new PortletException((Throwable)e);
            }
        }
        String navigationPath = navigationItem == null ? null : navigationItem.getNavigationPath();
        return navigationPath;
    }

    public Document getDocument(PortalControllerContext portalControllerContext, String path) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
        return documentContext.getDocument();
    }

    public void move(PortalControllerContext portalControllerContext, String basePath, List<String> identifiers, String targetPath) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        NuxeoDocumentContext targetDocumentContext = nuxeoController.getDocumentContext(targetPath);
        NuxeoPublicationInfos targetPublicationInfos = targetDocumentContext.getPublicationInfos();
        String targetId = targetPublicationInfos.getLiveId();
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(MoveDocumentCommand.class, new Object[]{identifiers, targetId});
        nuxeoController.executeNuxeoCommand(command);
        Document sourceRoot = this.getRootDocument(cmsContext, basePath);
        Document targetRoot = this.getRootDocument(cmsContext, targetPath);
        if (!StringUtils.equals((String)sourceRoot.getPath(), (String)targetRoot.getPath())) {
            command = (INuxeoCommand)this.applicationContext.getBean(RemoveAllPermissionsCommand.class, new Object[]{identifiers});
            nuxeoController.executeNuxeoCommand(command);
        }
    }

    private Document getRootDocument(CMSServiceCtx cmsContext, String basePath) throws PortletException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        Document currentSpace = null;
        Document root = null;
        String path = basePath;
        while (root == null && StringUtils.isNotEmpty((String)path)) {
            DocumentType spaceType;
            CMSItem spaceConfig;
            try {
                spaceConfig = cmsService.getSpaceConfig(cmsContext, path);
            }
            catch (CMSException e) {
                throw new PortletException((Throwable)e);
            }
            if (currentSpace == null) {
                currentSpace = (Document)spaceConfig.getNativeItem();
            }
            if ((spaceType = spaceConfig.getType()) != null && spaceType.isRoot()) {
                root = (Document)spaceConfig.getNativeItem();
            }
            CMSObjectPath objectPath = CMSObjectPath.parse((String)path);
            CMSObjectPath parentObjectPath = objectPath.getParent();
            path = parentObjectPath.toString();
        }
        if (root == null) {
            root = currentSpace;
        }
        return root;
    }

    public Document getUserWorkspace(PortalControllerContext portalControllerContext) throws PortletException {
        CMSItem cmsItem;
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        try {
            cmsItem = cmsService.getUserWorkspace(cmsContext);
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
        return (Document)cmsItem.getNativeItem();
    }
}

