/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.delete.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.widgets.delete.portlet.model.DeleteForm;
import org.osivia.services.widgets.delete.portlet.model.DeleteItem;
import org.osivia.services.widgets.delete.portlet.model.comparator.DeleteItemComparator;
import org.osivia.services.widgets.delete.portlet.repository.DeleteRepository;
import org.osivia.services.widgets.delete.portlet.service.DeleteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class DeleteServiceImpl
implements DeleteService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DeleteRepository repository;
    @Autowired
    private DeleteItemComparator deleteItemComparator;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;
    @Autowired
    private DocumentDAO documentDao;

    public DeleteForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        DeleteItem item;
        DocumentDTO document;
        TreeSet<DeleteItem> items;
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty("osivia.delete.path");
        Object[] identifiers = StringUtils.split((String)window.getProperty("osivia.delete.identifiers"), (String)",");
        List documents = StringUtils.isNotEmpty((String)path) ? Collections.singletonList(this.repository.getDocument(portalControllerContext, path)) : (ArrayUtils.isNotEmpty((Object[])identifiers) ? this.repository.getDocuments(portalControllerContext, (String[])identifiers) : null);
        DeleteForm form = (DeleteForm)this.applicationContext.getBean(DeleteForm.class);
        if (CollectionUtils.isEmpty((Collection)documents)) {
            items = null;
        } else {
            items = new TreeSet<DeleteItem>((Comparator<DeleteItem>)this.deleteItemComparator);
            Map childrenCounts = this.repository.getChildrenCounts(portalControllerContext, documents);
            Map remoteProxiesMap = this.repository.haveRemoteProxies(portalControllerContext, documents);
            form.setRemoteProxiesCount(remoteProxiesMap.size());
            for (Document document2 : documents) {
                DeleteItem item2 = (DeleteItem)this.applicationContext.getBean(DeleteItem.class);
                DocumentDTO dto = this.documentDao.toDTO(document2);
                item2.setDocument(dto);
                Integer childrenCount = (Integer)childrenCounts.get(document2);
                item2.setChildrenCount(childrenCount);
                boolean remoteProxies = BooleanUtils.isTrue((Boolean)((Boolean)remoteProxiesMap.get(document2)));
                item2.setRemoteProxies(remoteProxies);
                items.add(item2);
            }
        }
        form.setItems(items);
        String redirectionPath = window.getProperty("osivia.delete.redirection-path");
        if (StringUtils.isEmpty((String)redirectionPath) && StringUtils.isNotEmpty((String)path)) {
            redirectionPath = StringUtils.substringBeforeLast((String)path, (String)"/");
        } else if (StringUtils.isEmpty((String)redirectionPath) && CollectionUtils.isNotEmpty(items) && (document = (item = (DeleteItem)items.first()).getDocument()) != null) {
            redirectionPath = StringUtils.substringBeforeLast((String)document.getPath(), (String)"/");
        }
        form.setRedirectionPath(redirectionPath);
        return form;
    }

    public void delete(PortalControllerContext portalControllerContext, DeleteForm form) throws PortletException, IOException {
        String redirectionPath;
        PortletRequest request = portalControllerContext.getRequest();
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        SortedSet items = form.getItems();
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            ArrayList<String> identifiers = new ArrayList<String>(items.size());
            for (DeleteItem item : items) {
                DocumentDTO document = item.getDocument();
                if (document == null) continue;
                identifiers.add(document.getId());
            }
            try {
                this.repository.delete(portalControllerContext, identifiers);
                String message = bundle.getString("DELETE_SUCCESS_MESSAGE");
                this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
            }
            catch (NuxeoException e) {
                String message = bundle.getString("DELETE_ERROR_MESSAGE");
                this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.ERROR);
            }
        }
        if (StringUtils.isNotEmpty((String)(redirectionPath = form.getRedirectionPath()))) {
            String redirectionUrl = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, redirectionPath, null, null, "refreshPageAndNavigation", null, null, null, null);
            response.sendRedirect(redirectionUrl);
        }
    }
}

