/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.move.portlet.controller;

import java.io.IOException;
import java.io.PrintWriter;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.widgets.move.portlet.model.MoveForm;
import org.osivia.services.widgets.move.portlet.model.validation.MoveFormValidator;
import org.osivia.services.widgets.move.portlet.service.MoveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"form"})
public class MoveController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private MoveService service;
    @Autowired
    private MoveFormValidator validator;

    @RenderMapping
    public String view() {
        return "view";
    }

    @ActionMapping(value="move")
    public void move(ActionRequest request, ActionResponse response, @Validated @ModelAttribute(value="form") MoveForm form, BindingResult result, SessionStatus sessionStatus) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!result.hasErrors()) {
            sessionStatus.setComplete();
            this.service.move(portalControllerContext, form);
        }
    }

    @ResourceMapping(value="browse")
    public void browse(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        String data = this.service.browse(portalControllerContext);
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(data);
        printWriter.close();
    }

    @ModelAttribute(value="form")
    public MoveForm getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    @InitBinder(value={"form"})
    public void formInitBinder(PortletRequestDataBinder binder) {
        binder.addValidators(new Validator[]{this.validator});
    }
}

