/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.rename.plugin.service;

import fr.toutatice.portail.cms.nuxeo.api.ContextualizationHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.Permissions;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.services.widgets.rename.plugin.model.RenameMenubarModule;
import org.osivia.services.widgets.rename.plugin.service.RenamePluginService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RenamePluginServiceImpl
implements RenamePluginService {
    @Autowired
    private RenameMenubarModule menubarModule;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IMenubarService menubarService;
    @Autowired
    private IBundleFactory bundleFactory;

    public void customizeMenubarModules(CustomizationContext customizationContext, List<MenubarModule> menubarModules) {
        menubarModules.add((MenubarModule)this.menubarModule);
    }

    public void addMenubarItem(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext documentContext) throws PortalException {
        if (ContextualizationHelper.isCurrentDocContextualized((PortalControllerContext)portalControllerContext) && documentContext != null) {
            DocumentType type = documentContext.getDocumentType();
            Permissions permissions = documentContext.getPermissions();
            if (type != null && type.isEditable() && permissions.isEditable()) {
                HttpServletRequest servletRequest = portalControllerContext.getHttpServletRequest();
                Bundle bundle = this.bundleFactory.getBundle(servletRequest.getLocale());
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("osivia.rename.path", documentContext.getCmsPath());
                String id = "RENAME";
                String title = bundle.getString("RENAME_MENUBAR_ITEM");
                String icon = "glyphicons glyphicons-edit";
                MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
                int order = 1;
                String url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "osivia-services-widgets-rename-instance", properties, PortalUrlType.MODAL);
                MenubarItem menubarItem = new MenubarItem(id, title, icon, (MenubarContainer)parent, order, "javascript:", null, null, null);
                Map data = menubarItem.getData();
                data.put("target", "#osivia-modal");
                data.put("load-url", url);
                data.put("title", title);
                menubar.add(menubarItem);
            }
        }
    }
}

