/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.portlet;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.core.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.core.PortletErrorHandler;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.services.wiki.services.DocumentUpdateCommand;
import org.osivia.portal.services.wiki.services.WikiDocumentBean;
import org.osivia.portal.services.wiki.services.WikiMode;
import org.osivia.portal.services.wiki.services.WikiService;

public class WikiPortlet
extends CMSPortlet {
    public static final String DOCUMENT_ATTRIBUTE_NAME = "osivia.services.wiki.document";
    public static final String VIEW_URL_ATTRIBUTE_NAME = "osivia.services.wiki.viewUrl";
    public static final String LIVE_URL_ATTRIBUTE_NAME = "osivia.services.wiki.liveUrl";
    public static final String EDIT_URL_ATTRIBUTE_NAME = "osivia.services.wiki.editUrl";
    public static final String MODE_PARAMETER_NAME = "osivia.services.wiki.mode";
    public static final String TITLE_PARAMETER_NAME = "osivia.services.wiki.title";
    public static final String WEB_URL_PARAMETER_NAME = "osivia.services.wiki.webUrl";
    public static final String DATA_PARAMETER_NAME = "osivia.services.wiki.data";
    private static final String PATH_PAGE_VIEW = "/WEB-INF/jsp/wiki/view.jsp";
    private static final String PATH_PAGE_LIVE = "/WEB-INF/jsp/wiki/live.jsp";
    private static final String PATH_PAGE_EDIT = "/WEB-INF/jsp/wiki/edit.jsp";
    private static final String PATH_PAGE_ADMIN = "/WEB-INF/jsp/wiki/admin.jsp";
    private static final String PORTLET_MODE_ADMIN = "admin";
    private static final String URL_SERVICE_ATTRIBUTE_NAME = "UrlService";
    private IPortalUrlFactory portalUrlFactory;
    private WikiService wikiService;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.portalUrlFactory = (IPortalUrlFactory)this.getPortletContext().getAttribute(URL_SERVICE_ATTRIBUTE_NAME);
        if (this.portalUrlFactory == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("Resource");
            throw new PortletException(resourceBundle.getString("WIKI_PORTLET_INIT_ERROR"));
        }
        this.wikiService = WikiService.getInstance();
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String mode = request.getParameter(MODE_PARAMETER_NAME);
        String data = request.getParameter(DATA_PARAMETER_NAME);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        String contentPath = nuxeoController.getItemNavigationPath();
        WikiDocumentBean document = new WikiDocumentBean(contentPath, data);
        try {
            DocumentUpdateCommand command = new DocumentUpdateCommand(document);
            nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        }
        catch (Exception e) {
            if (!(e instanceof PortletException)) {
                throw new PortletException((Throwable)e);
            }
            throw (PortletException)e;
        }
        response.setRenderParameter(MODE_PARAMETER_NAME, mode);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            String requestDispatcherPath;
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            WikiMode mode = WikiMode.fromValue((String)request.getParameter(MODE_PARAMETER_NAME));
            WikiDocumentBean document = this.wikiService.getWikiDocumentBean(nuxeoController, request, mode);
            request.setAttribute(DOCUMENT_ATTRIBUTE_NAME, (Object)document);
            if (WikiMode.LIVE.equals((Object)mode)) {
                PortletURL editPortletUrl = response.createRenderURL();
                editPortletUrl.setParameter(MODE_PARAMETER_NAME, WikiMode.EDITION.getValue());
                String editUrl = this.portalUrlFactory.adaptPortalUrlToPopup((PortletRequest)request, editPortletUrl.toString(), 0);
                request.setAttribute(EDIT_URL_ATTRIBUTE_NAME, (Object)editUrl);
                PortletURL viewPortletUrl = response.createRenderURL();
                String viewUrl = this.portalUrlFactory.adaptPortalUrlToNavigation((PortletRequest)request, viewPortletUrl.toString());
                request.setAttribute(VIEW_URL_ATTRIBUTE_NAME, (Object)viewUrl);
                requestDispatcherPath = PATH_PAGE_LIVE;
            } else if (WikiMode.EDITION.equals((Object)mode)) {
                PortletURL livePortletUrl = response.createActionURL();
                livePortletUrl.setParameter(MODE_PARAMETER_NAME, WikiMode.LIVE.getValue());
                String liveUrl = this.portalUrlFactory.adaptPortalUrlToPopup((PortletRequest)request, livePortletUrl.toString(), 1);
                request.setAttribute(LIVE_URL_ATTRIBUTE_NAME, (Object)liveUrl);
                PortletURL callbackPortletUrl = response.createRenderURL();
                callbackPortletUrl.setParameter(MODE_PARAMETER_NAME, WikiMode.LIVE.getValue());
                String callbackUrl = this.portalUrlFactory.adaptPortalUrlToPopup((PortletRequest)request, callbackPortletUrl.toString(), 2);
                request.setAttribute("osivia.popupCallbackUrl", (Object)callbackUrl);
                requestDispatcherPath = PATH_PAGE_EDIT;
            } else {
                PortletURL livePortletUrl = response.createRenderURL();
                livePortletUrl.setParameter(MODE_PARAMETER_NAME, WikiMode.LIVE.getValue());
                String liveUrl = this.portalUrlFactory.adaptPortalUrlToNavigation((PortletRequest)request, livePortletUrl.toString());
                request.setAttribute(LIVE_URL_ATTRIBUTE_NAME, (Object)liveUrl);
                requestDispatcherPath = PATH_PAGE_VIEW;
            }
            response.setTitle(document.getTitle());
            response.setContentType("text/html");
            this.getPortletContext().getRequestDispatcher(requestDispatcherPath).include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (Exception e) {
            if (!(e instanceof PortletException)) {
                throw new PortletException((Throwable)e);
            }
            throw (PortletException)e;
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(PATH_PAGE_ADMIN).include(request, response);
    }
}

