/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.portlet.RenderRequest;
import org.apache.commons.lang.StringUtils;
import org.cyberneko.html.parsers.DOMParser;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.osivia.portal.services.wiki.services.WikiDocumentBean;
import org.osivia.portal.services.wiki.services.WikiMode;
import org.osivia.portal.services.wiki.services.dom4j.generator.AbstractWikiGenerator;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WikiService {
    public static final String NUXEO_TITLE_PROPERTY_NAME = "dc:title";
    public static final String NUXEO_WEB_URL_PROPERTY_NAME = "webc:url";
    public static final String NUXEO_DATA_PROPERTY_NAME = "wikisection:data";
    public static final String RESOURCE_BUNDLE_NAME = "Resource";
    public static final String KEY_INVALID_WIKI_CONTENT = "INVALID_WIKI_CONTENT";
    public static final String KEY_WIKI_PORTLET_INIT_ERROR = "WIKI_PORTLET_INIT_ERROR";
    private static WikiService instance;

    private WikiService() {
    }

    public static WikiService getInstance() {
        if (instance == null) {
            instance = new WikiService();
        }
        return instance;
    }

    public WikiDocumentBean getWikiDocumentBean(NuxeoController nuxeoController, RenderRequest request, WikiMode mode) throws Exception {
        WikiDocumentBean wikiDocumentBean = new WikiDocumentBean();
        String path = nuxeoController.getItemNavigationPath();
        wikiDocumentBean.setPath(path);
        if (!WikiMode.VIEW.equals((Object)mode)) {
            nuxeoController.setDisplayLiveVersion("1");
        }
        Document document = nuxeoController.fetchDocument(path);
        String title = document.getTitle();
        wikiDocumentBean.setTitle(title);
        String webUrl = document.getProperties().getString(NUXEO_WEB_URL_PROPERTY_NAME);
        wikiDocumentBean.setWebUrl(webUrl);
        String displayContent = "";
        String data = document.getProperties().getString(NUXEO_DATA_PROPERTY_NAME);
        if (StringUtils.isNotEmpty((String)data)) {
            if (WikiMode.EDITION.equals((Object)mode)) {
                displayContent = data;
            } else {
                try {
                    Node rootNode = this.parseWikiContent(data);
                    displayContent = this.generateWikiHtmlData(nuxeoController, rootNode);
                }
                catch (SAXException e) {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, request.getLocale());
                    displayContent = resourceBundle.getString(KEY_INVALID_WIKI_CONTENT);
                }
            }
        }
        wikiDocumentBean.setContent(displayContent);
        return wikiDocumentBean;
    }

    public Node parseWikiContent(String wikiContent) throws IOException, SAXException {
        wikiContent = this.codeTagsProtection(wikiContent);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(wikiContent.getBytes("UTF-8"));
        InputSource inputSource = new InputSource(inputStream);
        DOMParser parser = new DOMParser();
        parser.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        parser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)"UTF-8");
        parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
        parser.parse(inputSource);
        org.w3c.dom.Document document = parser.getDocument();
        return document;
    }

    private String codeTagsProtection(String wikiContent) {
        String startTag = "<code>";
        String endTag = "</code>";
        ArrayList<String> result = new ArrayList<String>();
        String[] startSplit = wikiContent.split("(?i)" + startTag);
        String content = startSplit[0].replaceAll("\\\\<", "&amp;lt;");
        result.add(content);
        for (int i = 1; i < startSplit.length; ++i) {
            String[] endSplit = startSplit[i].split("(?i)" + endTag);
            result.add(startTag);
            String codeContent = endSplit[0].replaceAll("<", "&amp;lt;");
            result.add(codeContent);
            result.add(endTag);
            for (int j = 1; j < endSplit.length; ++j) {
                content = endSplit[j].replaceAll("\\\\<", "&amp;lt;");
                result.add(content);
            }
        }
        return StringUtils.join(result, null);
    }

    public String generateWikiHtmlData(NuxeoController nuxeoController, Node node) throws IOException {
        Element element = AbstractWikiGenerator.dom4jGeneration((NuxeoController)nuxeoController, (Node)node);
        String htmlData = this.writeHtmlData(element);
        return htmlData;
    }

    private String writeHtmlData(Element htmlElement) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);
        HTMLWriter htmlWriter = null;
        String resultat = null;
        try {
            htmlWriter = new HTMLWriter((OutputStream)bufferedOutput);
            htmlWriter.setEscapeText(false);
            htmlWriter.write(htmlElement);
            resultat = output.toString("UTF-8");
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            ((OutputStream)bufferedOutput).close();
            output.close();
            htmlWriter.close();
        }
        return resultat;
    }
}

