/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services.dom4j.generator;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.dom4j.Element;
import org.osivia.portal.services.wiki.services.dom4j.generator.AbstractWikiGenerator;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextWikiGenerator
extends AbstractWikiGenerator {
    private static TextWikiGenerator instance;

    private TextWikiGenerator() {
    }

    public static synchronized TextWikiGenerator getInstance() {
        if (instance == null) {
            instance = new TextWikiGenerator();
        }
        return instance;
    }

    protected Element generate(NuxeoController nuxeoController, Node node, Element parent, Element root) {
        String text = node.getTextContent();
        if (StringUtils.isNotEmpty((String)text)) {
            List textElements = this.getTextElements(text);
            boolean newParagraph = false;
            for (String textElement : textElements) {
                if (textElement == null) {
                    parent = null;
                    newParagraph = false;
                    continue;
                }
                textElement = newParagraph ? " " + textElement.trim() : StringUtils.stripEnd((String)textElement, null);
                if (parent == null) {
                    parent = TextWikiGenerator.createNewParagraph((Element)root);
                }
                parent.addText(textElement);
                newParagraph = true;
            }
        }
        return parent;
    }

    private List<String> getTextElements(String text) {
        int i;
        String[] rawData = StringUtils.splitPreserveAllTokens((String)text, (String)SystemUtils.LINE_SEPARATOR);
        ArrayList<String> result = new ArrayList<String>();
        if (rawData.length > 0 && StringUtils.isNotBlank((String)rawData[0])) {
            result.add(rawData[0]);
        }
        boolean lineBreaked = false;
        for (i = 1; i < rawData.length - 1; ++i) {
            if (StringUtils.isBlank((String)rawData[i])) {
                if (lineBreaked) continue;
                result.add(null);
                lineBreaked = true;
                continue;
            }
            result.add(rawData[i]);
            lineBreaked = false;
        }
        i = rawData.length - 1;
        if (i > 0 && StringUtils.isNotBlank((String)rawData[i])) {
            result.add(rawData[i]);
        }
        return result;
    }
}

