/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services.dom4j.generator;

import org.apache.commons.lang.StringUtils;
import org.osivia.portal.services.wiki.services.dom4j.generator.AbstractWikiGenerator;
import org.osivia.portal.services.wiki.services.dom4j.generator.CodeWikiGenerator;
import org.osivia.portal.services.wiki.services.dom4j.generator.CommentWikiGenerator;
import org.osivia.portal.services.wiki.services.dom4j.generator.LinkWikiGenerator;
import org.osivia.portal.services.wiki.services.dom4j.generator.ListWikiGenerator;
import org.osivia.portal.services.wiki.services.dom4j.generator.PictureWikiGenerator;
import org.osivia.portal.services.wiki.services.dom4j.generator.SectionWikiGenerator;
import org.osivia.portal.services.wiki.services.dom4j.generator.TableWikiGenerator;
import org.osivia.portal.services.wiki.services.dom4j.generator.TitleWikiGenerator;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public enum WikiGenerators {
    CODE("code", (AbstractWikiGenerator)CodeWikiGenerator.getInstance()),
    COMMENT("comment", (AbstractWikiGenerator)CommentWikiGenerator.getInstance()),
    LINK("a", (AbstractWikiGenerator)LinkWikiGenerator.getInstance()),
    PICTURE("img", (AbstractWikiGenerator)PictureWikiGenerator.getInstance()),
    SECTION("section", (AbstractWikiGenerator)SectionWikiGenerator.getInstance()),
    TABLE("table", (AbstractWikiGenerator)TableWikiGenerator.getInstance()),
    H1("h1", (AbstractWikiGenerator)TitleWikiGenerator.getH1Instance()),
    H2("h2", (AbstractWikiGenerator)TitleWikiGenerator.getH2Instance()),
    H3("h3", (AbstractWikiGenerator)TitleWikiGenerator.getH3Instance()),
    UNORDERED_LIST("ul", (AbstractWikiGenerator)ListWikiGenerator.getUlInstance()),
    ORDERED_LIST("ol", (AbstractWikiGenerator)ListWikiGenerator.getOlInstance());

    private final String nodeName;
    private final AbstractWikiGenerator generator;

    private WikiGenerators(String nodeName, AbstractWikiGenerator generator) {
        this.nodeName = nodeName;
        this.generator = generator;
    }

    public static AbstractWikiGenerator getGenerator(Node node) {
        if (node != null) {
            WikiGenerators[] values;
            for (WikiGenerators value : values = WikiGenerators.values()) {
                if (!StringUtils.equalsIgnoreCase((String)value.nodeName, (String)node.getNodeName())) continue;
                return value.generator;
            }
        }
        return null;
    }
}

