/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.cyberneko.html.parsers.DOMParser;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.services.wiki.services.DocumentUpdateCommand;
import org.osivia.portal.services.wiki.services.WikiDocumentBean;
import org.osivia.portal.services.wiki.services.generators.WikiContentGenerator;
import org.osivia.portal.services.wiki.services.generators.WikiSummaryGenerator;
import org.osivia.portal.services.wiki.utils.WikiMode;
import org.osivia.portal.services.wiki.utils.WikiUtils;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class WikiService {
    private static final Pattern TITLE_PATTERN = Pattern.compile("[^\\\\]*<h1[ ]*(id=['\"](.+)['\"])?.*>(.+)</h1>.*", 2);
    private static final int REGEX_GROUP_TITLE_ID = 2;
    private static final int REGEX_GROUP_TITLE_CONTENT = 3;
    private static final Pattern CODE_PATTERN = Pattern.compile(".*((<code>)|(</code>)).*", 2);
    private static final int REGEX_GROUP_BEGIN_CODE = 2;
    private static final int REGEX_GROUP_END_CODE = 3;
    private static WikiService instance;
    private final IBundleFactory bundleFactory;
    private final INotificationsService notificationsService;

    private WikiService(PortletContext portletContext) {
        IInternationalizationService internationalizationService = (IInternationalizationService)portletContext.getAttribute("InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.notificationsService = (INotificationsService)portletContext.getAttribute("NotificationsService");
    }

    public static WikiService getInstance(PortletContext portletContext) {
        if (instance == null) {
            instance = new WikiService(portletContext);
        }
        return instance;
    }

    public WikiDocumentBean getWikiDocumentBean(NuxeoController nuxeoController, WikiMode mode, String currentTitleId) throws CMSException, PortletException {
        WikiDocumentBean wikiDocumentBean = new WikiDocumentBean();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
        String pathProperty = window.getProperty("osivia.cms.uri");
        if (StringUtils.isEmpty((String)pathProperty)) {
            wikiDocumentBean.setTitle("Wiki");
            wikiDocumentBean.setContent("<p>Non renseign\u00e9</p>");
        } else {
            String path = nuxeoController.getLivePath(pathProperty);
            wikiDocumentBean.setPath(path);
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            CMSPublicationInfos cmsPublicationInfos = NuxeoController.getCMSService().getPublicationInfos(cmsContext, path);
            boolean editable = cmsPublicationInfos.isEditableByUser();
            wikiDocumentBean.setEditable(editable);
            String liveId = cmsPublicationInfos.getLiveId();
            wikiDocumentBean.setLiveId(liveId);
            nuxeoController.setDisplayLiveVersion(mode.getNuxeoDisplayLiveVersion());
            try {
                String data;
                Document document = nuxeoController.fetchDocument(path);
                String title = document.getTitle();
                wikiDocumentBean.setTitle(title);
                String webUrl = document.getProperties().getString("webc:url");
                wikiDocumentBean.setWebUrl(webUrl);
                String type = document.getType();
                boolean wikiBook = StringUtils.equals((String)"WikiBook", (String)type);
                wikiDocumentBean.setWikiBook(wikiBook);
                String displayContent = "";
                String summary = null;
                if (wikiBook) {
                    data = document.getProperties().getString("wikibook:resume");
                    summary = this.generateWikiBookSummaryHtmlData(nuxeoController);
                } else {
                    data = document.getProperties().getString("wikisection:data");
                }
                if (StringUtils.isNotEmpty((String)data)) {
                    if (WikiMode.EDITION.equals((Object)mode)) {
                        if (currentTitleId != null) {
                            String[] splitData = this.splitWikiData(nuxeoController, data, currentTitleId);
                            displayContent = splitData[1];
                        } else {
                            displayContent = data;
                        }
                    } else {
                        Node rootNode = this.parseWikiContent(data);
                        displayContent = this.generateWikiContentHtmlData(nuxeoController, rootNode);
                        if (!wikiBook) {
                            summary = this.generateWikiSummaryHtmlData(nuxeoController, rootNode);
                        }
                    }
                }
                wikiDocumentBean.setContent(displayContent);
                wikiDocumentBean.setSummary(summary);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        return wikiDocumentBean;
    }

    public String[] splitWikiData(NuxeoController nuxeoController, String data, String currentTitleId) {
        int status = 0;
        StringBuffer before = new StringBuffer();
        StringBuffer current = new StringBuffer();
        StringBuffer after = new StringBuffer();
        StringBuffer[] buffers = new StringBuffer[]{before, current, after};
        boolean code = false;
        String[] lines = StringUtils.splitPreserveAllTokens((String)data, (String)SystemUtils.LINE_SEPARATOR);
        for (int i = 0; i < lines.length; ++i) {
            String line = StringUtils.chomp((String)lines[i]);
            boolean lastLine = i == lines.length - 1;
            code = this.splitWikiDataCodeHandling(code, line);
            status = this.splitWikiDataLineHandling(nuxeoController, currentTitleId, buffers, status, line, code, lastLine);
        }
        return new String[]{before.toString(), current.toString(), after.toString()};
    }

    private boolean splitWikiDataCodeHandling(boolean code, String line) {
        boolean newCode = code;
        Matcher codeMatcher = CODE_PATTERN.matcher(line);
        if (codeMatcher.matches()) {
            if (codeMatcher.group(2) != null) {
                newCode = true;
            }
            if (codeMatcher.group(3) != null) {
                newCode = false;
            }
        }
        return newCode;
    }

    private int splitWikiDataLineHandling(NuxeoController nuxeoController, String currentTitleId, StringBuffer[] buffers, int status, String line, boolean code, boolean lastLine) {
        Matcher matcher;
        int newStatus = status;
        String newLine = line;
        if (!code && (matcher = TITLE_PATTERN.matcher(line)).matches()) {
            String id = matcher.group(2);
            if (id == null) {
                id = WikiUtils.generateUniqueTitleAnchor((NuxeoController)nuxeoController, (String)matcher.group(3));
            }
            if (StringUtils.equals((String)currentTitleId, (String)id) || newStatus == 1) {
                ++newStatus;
            }
        }
        if (!lastLine) {
            newLine = newLine + SystemUtils.LINE_SEPARATOR;
        }
        buffers[newStatus].append(newLine);
        return newStatus;
    }

    public Node parseWikiContent(String wikiContent) throws IOException, SAXException {
        String protectedWikiContent = "<div>" + this.codeTagsProtection(wikiContent) + "</div>";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(protectedWikiContent.getBytes("UTF-8"));
        InputSource inputSource = new InputSource(inputStream);
        DOMParser parser = new DOMParser();
        parser.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        parser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)"UTF-8");
        parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
        parser.parse(inputSource);
        return parser.getDocument();
    }

    private String codeTagsProtection(String wikiContent) {
        String startTag = "<code>";
        String endTag = "</code>";
        ArrayList<String> result = new ArrayList<String>();
        String[] startSplit = wikiContent.split("(?i)" + startTag);
        String content = startSplit[0].replaceAll("\\\\<", "&lt;");
        result.add(content);
        for (int i = 1; i < startSplit.length; ++i) {
            String[] endSplit = startSplit[i].split("(?i)" + endTag);
            result.add(startTag);
            String codeContent = endSplit[0].replaceAll("<", "&lt;");
            result.add(codeContent);
            result.add(endTag);
            for (int j = 1; j < endSplit.length; ++j) {
                content = endSplit[j].replaceAll("\\\\<", "&lt;");
                result.add(content);
            }
        }
        return StringUtils.join(result, null);
    }

    public String generateWikiContentHtmlData(NuxeoController nuxeoController, Node node) throws IOException {
        Element element = WikiContentGenerator.getInstance().dom4jGeneration(nuxeoController, node);
        return element.asXML();
    }

    public String generateWikiSummaryHtmlData(NuxeoController nuxeoController, Node node) throws IOException {
        Element element = WikiSummaryGenerator.getInstance().dom4jGeneration(nuxeoController, node);
        if (StringUtils.isEmpty((String)element.getStringValue())) {
            return null;
        }
        return element.asXML();
    }

    public String generateWikiBookSummaryHtmlData(NuxeoController nuxeoController) throws CMSException, PortletException {
        Element ul = this.recursiveWikiBookSummaryGeneration(nuxeoController, null);
        String htmlData = null;
        if (ul != null) {
            htmlData = ul.asXML();
        }
        return htmlData;
    }

    private Element recursiveWikiBookSummaryGeneration(NuxeoController nuxeoController, CMSItem item) throws CMSException, PortletException {
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        String spacePath = nuxeoController.getSpacePath();
        String path = item == null ? nuxeoController.getItemNavigationPath() : item.getPath();
        DOMElement ulParent = null;
        List subItems = NuxeoController.getCMSService().getPortalNavigationSubitems(cmsContext, spacePath, path);
        if (CollectionUtils.isNotEmpty((Collection)subItems)) {
            try {
                ulParent = new DOMElement(QName.get((String)"ul"));
                for (CMSItem subItem : subItems) {
                    Document document = (Document)subItem.getNativeItem();
                    Link link = nuxeoController.getLink(document);
                    String url = link.getUrl();
                    String title = document.getTitle();
                    DOMElement li = new DOMElement(QName.get((String)"li"));
                    ulParent.add((Element)li);
                    DOMElement a = new DOMElement(QName.get((String)"a"));
                    a.addAttribute(QName.get((String)"href"), url);
                    a.setText(title);
                    li.add((Element)a);
                    Element ulChildren = this.recursiveWikiBookSummaryGeneration(nuxeoController, subItem);
                    if (ulChildren == null) continue;
                    li.add(ulChildren);
                }
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        return ulParent;
    }

    public void saveLiveContent(NuxeoController nuxeoController, String currentTitleId, String data) throws PortletException {
        String managedData = data;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
        String path = nuxeoController.getLivePath(window.getProperty("osivia.cms.uri"));
        boolean wikiBook = false;
        try {
            nuxeoController.setDisplayLiveVersion(WikiMode.LIVE.getNuxeoDisplayLiveVersion());
            Document nuxeoDocument = nuxeoController.fetchDocument(path);
            String type = nuxeoDocument.getType();
            wikiBook = StringUtils.equals((String)"WikiBook", (String)type);
            if (currentTitleId != null) {
                String previousVersionData = wikiBook ? nuxeoDocument.getProperties().getString("wikibook:resume") : nuxeoDocument.getProperties().getString("wikisection:data");
                String[] splitData = this.splitWikiData(nuxeoController, previousVersionData, currentTitleId);
                managedData = splitData[0] + managedData + splitData[2];
            }
            WikiDocumentBean wikiDocument = new WikiDocumentBean(path, managedData, wikiBook);
            DocumentUpdateCommand command = new DocumentUpdateCommand(wikiDocument);
            nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            nuxeoController.setDisplayLiveVersion("1");
            nuxeoController.fetchDocument(path, true);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        this.addSimpleNotification(nuxeoController, "MESSAGE_SAVE_SUCCESS", NotificationsType.SUCCESS, new Object[0]);
    }

    public void publishLiveContent(NuxeoController nuxeoController) throws PortletException {
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
        String path = nuxeoController.getLivePath(window.getProperty("osivia.cms.uri"));
        try {
            NuxeoController.getCMSService().publishDocument(cmsContext, path);
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
        this.addSimpleNotification(nuxeoController, "MESSAGE_PUBLISH_SUCCESS", NotificationsType.SUCCESS, new Object[0]);
    }

    private void addSimpleNotification(NuxeoController nuxeoController, String key, NotificationsType type, Object ... args) {
        Locale locale = nuxeoController.getRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        String message = bundle.getString(key, args);
        this.notificationsService.addSimpleNotification(nuxeoController.getPortalCtx(), message, type);
    }
}

