/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services.generators;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.osivia.portal.services.wiki.services.generators.IWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.WikiContentGenerator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class PictureWikiGenerator
extends WikiContentGenerator
implements IWikiGenerator {
    private static final Log LOGGER = LogFactory.getLog(PictureWikiGenerator.class);
    private static PictureWikiGenerator instance;

    private PictureWikiGenerator() {
    }

    public static synchronized PictureWikiGenerator getInstance() {
        if (instance == null) {
            instance = new PictureWikiGenerator();
        }
        return instance;
    }

    public Element generate(NuxeoController nuxeoController, Node node, Element parent, Element root) {
        DOMElement figure = new DOMElement(QName.get((String)"figure"));
        DOMElement picture = new DOMElement(QName.get((String)"img"));
        figure.add((Element)picture);
        if (node.hasAttributes()) {
            NamedNodeMap attributes = node.getAttributes();
            Node sourceAttribute = attributes.getNamedItem("src");
            Node altAttribute = attributes.getNamedItem("alt");
            Node htmlClassAttribute = attributes.getNamedItem("class");
            this.addPictureSource(nuxeoController, (Element)picture, sourceAttribute);
            this.addPictureCaption((Element)figure, (Element)picture, altAttribute);
            this.addPictureClass((Element)figure, htmlClassAttribute);
        }
        root.add((Element)figure);
        return null;
    }

    private void addPictureSource(NuxeoController nuxeoController, Element picture, Node sourceAttribute) {
        if (sourceAttribute != null && 2 == sourceAttribute.getNodeType()) {
            String source = sourceAttribute.getTextContent();
            if (StringUtils.startsWithIgnoreCase((String)source, (String)"wiki:")) {
                String wikiPath = StringUtils.removeStartIgnoreCase((String)source, (String)"wiki:");
                if (StringUtils.isNumeric((String)wikiPath)) {
                    String itemNavigationPath = nuxeoController.getItemNavigationPath();
                    source = nuxeoController.createAttachedPictureLink(itemNavigationPath, wikiPath);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Wiki path '" + wikiPath + "' is not numeric."));
                }
            }
            picture.addAttribute(QName.get((String)"src"), source);
        }
    }

    private void addPictureCaption(Element figure, Element picture, Node altAttribute) {
        String alt;
        if (altAttribute != null && 2 == altAttribute.getNodeType() && StringUtils.isNotBlank((String)(alt = altAttribute.getTextContent()))) {
            picture.addAttribute(QName.get((String)"alt"), alt);
            DOMElement caption = new DOMElement(QName.get((String)"figcaption"));
            caption.setText(alt);
            figure.add((Element)caption);
        }
    }

    private void addPictureClass(Element figure, Node htmlClassAttribute) {
        String htmlClass;
        if (htmlClassAttribute != null && 2 == htmlClassAttribute.getNodeType() && StringUtils.isNotBlank((String)(htmlClass = htmlClassAttribute.getTextContent()))) {
            figure.addAttribute(QName.get((String)"class"), htmlClass);
        }
    }
}

