/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services.generators;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.dom4j.Element;
import org.osivia.portal.services.wiki.services.generators.IWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.WikiContentGenerator;
import org.w3c.dom.Node;

public final class TextWikiGenerator
extends WikiContentGenerator
implements IWikiGenerator {
    private static TextWikiGenerator instance;

    private TextWikiGenerator() {
    }

    public static synchronized TextWikiGenerator getInstance() {
        if (instance == null) {
            instance = new TextWikiGenerator();
        }
        return instance;
    }

    public Element generate(NuxeoController nuxeoController, Node node, Element parent, Element root) {
        Element newParent = parent;
        String text = node.getTextContent();
        if (StringUtils.isNotEmpty((String)text)) {
            List textElements = this.getTextElements(text);
            boolean newParagraph = false;
            for (String textElement : textElements) {
                if (textElement == null) {
                    newParent = null;
                    newParagraph = false;
                    continue;
                }
                boolean endSpace = StringUtils.endsWith((String)textElement, (String)" ");
                textElement = newParagraph ? " " + textElement.trim() : StringUtils.stripEnd((String)textElement, null);
                if (endSpace) {
                    textElement = textElement + " ";
                }
                if (newParent == null) {
                    newParent = this.createNewParagraph(root);
                }
                newParent.addText(textElement);
                newParagraph = true;
            }
        }
        return newParent;
    }

    private List<String> getTextElements(String text) {
        int i;
        String[] rawData = StringUtils.splitPreserveAllTokens((String)text, (String)SystemUtils.LINE_SEPARATOR);
        ArrayList<String> result = new ArrayList<String>();
        if (rawData.length > 0 && StringUtils.isNotBlank((String)rawData[0])) {
            result.add(rawData[0]);
        }
        boolean lineBreaked = false;
        for (i = 1; i < rawData.length - 1; ++i) {
            if (StringUtils.isBlank((String)rawData[i])) {
                if (lineBreaked) continue;
                result.add(null);
                lineBreaked = true;
                continue;
            }
            result.add(rawData[i]);
            lineBreaked = false;
        }
        i = rawData.length - 1;
        if (i > 0 && StringUtils.isNotBlank((String)rawData[i])) {
            result.add(rawData[i]);
        }
        return result;
    }
}

