/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services.generators;

import org.apache.commons.lang.StringUtils;
import org.osivia.portal.services.wiki.services.generators.CodeWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.IWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.IgnoredElementWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.InlineWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.LinkWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.ListWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.NoteWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.PictureWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.SectionWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.TableOfContentsWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.TableWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.TitleWikiGenerator;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public enum WikiGenerators {
    CODE("code", (IWikiGenerator)CodeWikiGenerator.getInstance()),
    LINK("a", (IWikiGenerator)LinkWikiGenerator.getInstance()),
    NOTE("note", (IWikiGenerator)NoteWikiGenerator.getInstance()),
    PICTURE("img", (IWikiGenerator)PictureWikiGenerator.getInstance()),
    SECTION("section", (IWikiGenerator)SectionWikiGenerator.getInstance()),
    TABLE_OF_CONTENTS("toc", (IWikiGenerator)TableOfContentsWikiGenerator.getInstance()),
    TABLE("table", (IWikiGenerator)TableWikiGenerator.getInstance()),
    BOLD("b", (IWikiGenerator)InlineWikiGenerator.getInstance()),
    ITALIC("i", (IWikiGenerator)InlineWikiGenerator.getInstance()),
    UNDERLINE("u", (IWikiGenerator)InlineWikiGenerator.getInstance()),
    H1("h1", (IWikiGenerator)TitleWikiGenerator.getInstance()),
    H2("h2", (IWikiGenerator)TitleWikiGenerator.getInstance()),
    H3("h3", (IWikiGenerator)TitleWikiGenerator.getInstance()),
    UNORDERED_LIST("ul", (IWikiGenerator)ListWikiGenerator.getUlInstance()),
    ORDERED_LIST("ol", (IWikiGenerator)ListWikiGenerator.getOlInstance()),
    DIV("div", (IWikiGenerator)IgnoredElementWikiGenerator.getInstance());

    private final String nodeName;
    private final IWikiGenerator generator;

    private WikiGenerators(String nodeName, IWikiGenerator generator) {
        this.nodeName = nodeName;
        this.generator = generator;
    }

    public static IWikiGenerator getGenerator(Node node) {
        if (node != null) {
            WikiGenerators[] values;
            for (WikiGenerators value : values = WikiGenerators.values()) {
                if (!StringUtils.equalsIgnoreCase((String)value.nodeName, (String)node.getNodeName())) continue;
                return value.generator;
            }
        }
        return null;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public IWikiGenerator getGenerator() {
        return this.generator;
    }
}

