/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services.generators;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.osivia.portal.services.wiki.services.generators.WikiSummaryGenerator;
import org.osivia.portal.services.wiki.services.generators.WikiTitleTypes;
import org.osivia.portal.services.wiki.utils.WikiUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TitleWikiSummaryGenerator
extends WikiSummaryGenerator {
    private static final int PARENTS_COUNT = 3;
    private static final String CLASS_LEVEL_PREFIX = "level-";
    private int previousLevel = 0;
    private final Element[] parents = new Element[3];

    public void generate(NuxeoController nuxeoController, Node node, Element root) {
        WikiTitleTypes type = WikiTitleTypes.getWikiTitleType((String)node.getNodeName());
        if (type != null) {
            int level = type.getLevel();
            Element parent = this.getParent(level, root);
            DOMElement li = new DOMElement(QName.get((String)"li"));
            parent.add((Element)li);
            DOMElement link = new DOMElement(QName.get((String)"a"));
            link.setText(node.getTextContent());
            li.add((Element)link);
            StringBuffer url = new StringBuffer();
            url.append("#");
            NamedNodeMap attributes = node.getAttributes();
            Node idAttribute = attributes.getNamedItem("id");
            if (idAttribute != null && 2 == idAttribute.getNodeType()) {
                url.append(idAttribute.getTextContent());
            } else {
                url.append(WikiUtils.generateUniqueTitleAnchor((NuxeoController)nuxeoController, (String)node.getTextContent()));
            }
            link.addAttribute(QName.get((String)"href"), url.toString());
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.generate(nuxeoController, child, root);
        }
    }

    private Element getParent(int level, Element root) {
        if (level > this.previousLevel) {
            for (int i = this.previousLevel; i < level; ++i) {
                DOMElement ol = new DOMElement(QName.get((String)"ol"));
                ol.addAttribute(QName.get((String)"class"), CLASS_LEVEL_PREFIX + (i + 1));
                this.parents[i] = ol;
                if (i == 0) {
                    root.add(this.parents[i]);
                    continue;
                }
                this.parents[i - 1].add((Element)ol);
            }
        }
        this.previousLevel = level;
        return this.parents[level - 1];
    }
}

