/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.utils;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSServiceCtx;

/*
 * Exception performing whole class analysis ignored.
 */
public final class WikiUtils {
    private WikiUtils() {
        throw new AssertionError();
    }

    public static String generateUniqueTitleAnchor(NuxeoController nuxeoController, String title) {
        if (nuxeoController == null || StringUtils.isBlank((String)title)) {
            return null;
        }
        String namespace = nuxeoController.getResponse().getNamespace();
        try {
            return namespace + URLEncoder.encode(title, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static Element generateTableOfContents(NuxeoController nuxeoController, CMSItem item) {
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        String spacePath = nuxeoController.getSpacePath();
        String path = item == null ? nuxeoController.getItemNavigationPath() : item.getPath();
        DOMElement ulParent = null;
        List subItems = null;
        try {
            subItems = NuxeoController.getCMSService().getPortalNavigationSubitems(cmsContext, spacePath, path);
        }
        catch (CMSException e) {
            // empty catch block
        }
        if (CollectionUtils.isNotEmpty(subItems)) {
            ulParent = new DOMElement(QName.get((String)"ul"));
            for (CMSItem subItem : subItems) {
                Document document = (Document)subItem.getNativeItem();
                String url = "#";
                try {
                    Link link = nuxeoController.getLink(document);
                    url = link.getUrl();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String title = document.getTitle();
                DOMElement li = new DOMElement(QName.get((String)"li"));
                ulParent.add((Element)li);
                DOMElement a = new DOMElement(QName.get((String)"a"));
                a.addAttribute(QName.get((String)"href"), url);
                a.setText(title);
                li.add((Element)a);
                Element ulChildren = WikiUtils.generateTableOfContents((NuxeoController)nuxeoController, (CMSItem)subItem);
                if (ulChildren == null) continue;
                li.add(ulChildren);
            }
        }
        return ulParent;
    }
}

