/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.directory;

import fr.toutatice.outils.ldap.entity.Person;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.directory.DirectoryBean;
import org.osivia.portal.api.directory.IDirectoryService;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.login.IUserDatasModule;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.portlet.context.PortletApplicationContextUtils;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryService
implements IDirectoryService,
IUserDatasModule,
PortletContextAware,
PortletConfigAware {
    protected static final Log logger = LogFactory.getLog(DirectoryService.class);
    private PortletContext portletContext;
    private PortletConfig portletConfig;
    @Autowired
    private Person personne;
    ApplicationContext appContext;

    public DirectoryPerson getPerson(String username) {
        Person findUtilisateur = this.personne.findUtilisateur(username);
        if (findUtilisateur != null) {
            DirectoryPerson person = new DirectoryPerson();
            person.setNativeItem((Object)findUtilisateur);
            try {
                BeanUtils.copyProperties((Object)person, (Object)findUtilisateur);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)"unable to map properties from ldap ", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)"unable to map properties from ldap ", (Throwable)e);
            }
            ICMSServiceLocator cmsLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
            ICMSService cmsService = cmsLocator.getCMSService();
            try {
                CMSServiceCtx cmsCtx = new CMSServiceCtx();
                cmsCtx.setPortletCtx(this.portletContext);
                Link userAvatar = cmsService.getUserAvatar(cmsCtx, username);
                person.setAvatar(userAvatar);
            }
            catch (CMSException e) {
                logger.error((Object)"unable to prepare user avatar link ", (Throwable)e);
            }
            return person;
        }
        logger.warn((Object)("no person with uid " + username + " found "));
        return null;
    }

    public <T extends DirectoryBean> T getDirectoryBean(String name, Class<T> requiredType) {
        return (T)((DirectoryBean)this.appContext.getBean(name, requiredType));
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public void setPortletContext(PortletContext ctx) {
        this.portletContext = ctx;
        this.appContext = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.portletContext);
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void computeUserDatas(HttpServletRequest request, Map<String, Object> datas) {
        Person userConnecte;
        String uid = request.getUserPrincipal().getName();
        if (uid != null && (userConnecte = this.personne.findUtilisateur(uid)) != null) {
            userConnecte.populateMap(datas);
        }
    }

    public DirectoryPerson computeLoggedUser(HttpServletRequest request) {
        DirectoryPerson person = null;
        String uid = request.getUserPrincipal().getName();
        if (uid != null) {
            person = this.getPerson(uid);
        }
        return person;
    }
}

