/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.opentoutatice.sharing.elasticsearch;

import fr.toutatice.ecm.es.customizer.writers.api.AbstractCustomJsonESWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;

public class SharingJsonESDocumentWriter
extends AbstractCustomJsonESWriter {
    private void writeSharingProperties(JsonGenerator jsonGenerator, DocumentModel document) throws IOException {
        ACP acp = document.getACP();
        ACL acl = acp.getACL("sharing");
        jsonGenerator.writeArrayFieldStart("sharing:users");
        if (CollectionUtils.isNotEmpty((Collection)acl)) {
            for (ACE ace : acl) {
                String user = ace.getUsername();
                if (!StringUtils.isNotEmpty((String)user)) continue;
                jsonGenerator.writeString(user);
            }
        }
        jsonGenerator.writeEndArray();
    }

    public boolean accept(DocumentModel doc) {
        return doc.hasFacet("Sharing");
    }

    public void writeData(JsonGenerator jsonGenerator, DocumentModel document, String[] schemas, Map<String, String> contextParameters) throws IOException {
        this.writeSharingProperties(jsonGenerator, document);
    }
}

