/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.analyzing;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.TokenStreamToAutomaton;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.Sort;
import org.apache.lucene.search.suggest.analyzing.FSTUtil;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.BasicOperations;
import org.apache.lucene.util.automaton.SpecialOperations;
import org.apache.lucene.util.automaton.State;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;

public class XAnalyzingSuggester
extends Lookup {
    private FST<PairOutputs.Pair<Long, BytesRef>> fst = null;
    private final Analyzer indexAnalyzer;
    private final Analyzer queryAnalyzer;
    private final boolean exactFirst;
    private final boolean preserveSep;
    public static final int EXACT_FIRST = 1;
    public static final int PRESERVE_SEP = 2;
    public static final int SEP_LABEL = 31;
    public static final int END_BYTE = 0;
    private final int maxSurfaceFormsPerAnalyzedForm;
    private final int maxGraphExpansions;
    private int maxAnalyzedPathsForOneInput;
    private boolean hasPayloads;
    private final int sepLabel;
    private final int payloadSep;
    private final int endByte;
    private final int holeCharacter;
    public static final int PAYLOAD_SEP = 31;
    public static final int HOLE_CHARACTER = 30;
    private boolean preservePositionIncrements;
    private long count = 0L;
    static final Comparator<PairOutputs.Pair<Long, BytesRef>> weightComparator = new Comparator<PairOutputs.Pair<Long, BytesRef>>(){

        @Override
        public int compare(PairOutputs.Pair<Long, BytesRef> left, PairOutputs.Pair<Long, BytesRef> right) {
            return ((Long)left.output1).compareTo((Long)right.output1);
        }
    };

    public XAnalyzingSuggester(Analyzer analyzer) {
        this(analyzer, analyzer, 3, 256, -1, true, null, false, 0, 31, 31, 0, 30);
    }

    public XAnalyzingSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer) {
        this(indexAnalyzer, queryAnalyzer, 3, 256, -1, true, null, false, 0, 31, 31, 0, 30);
    }

    public XAnalyzingSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer, int options, int maxSurfaceFormsPerAnalyzedForm, int maxGraphExpansions, boolean preservePositionIncrements, FST<PairOutputs.Pair<Long, BytesRef>> fst, boolean hasPayloads, int maxAnalyzedPathsForOneInput, int sepLabel, int payloadSep, int endByte, int holeCharacter) {
        this.indexAnalyzer = indexAnalyzer;
        this.queryAnalyzer = queryAnalyzer;
        this.fst = fst;
        this.hasPayloads = hasPayloads;
        if ((options & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException("options should only contain EXACT_FIRST and PRESERVE_SEP; got " + options);
        }
        this.exactFirst = (options & 1) != 0;
        boolean bl = this.preserveSep = (options & 2) != 0;
        if (maxSurfaceFormsPerAnalyzedForm <= 0 || maxSurfaceFormsPerAnalyzedForm > 256) {
            throw new IllegalArgumentException("maxSurfaceFormsPerAnalyzedForm must be > 0 and < 256 (got: " + maxSurfaceFormsPerAnalyzedForm + ")");
        }
        this.maxSurfaceFormsPerAnalyzedForm = maxSurfaceFormsPerAnalyzedForm;
        if (maxGraphExpansions < 1 && maxGraphExpansions != -1) {
            throw new IllegalArgumentException("maxGraphExpansions must -1 (no limit) or > 0 (got: " + maxGraphExpansions + ")");
        }
        this.maxGraphExpansions = maxGraphExpansions;
        this.maxAnalyzedPathsForOneInput = maxAnalyzedPathsForOneInput;
        this.preservePositionIncrements = preservePositionIncrements;
        this.sepLabel = sepLabel;
        this.payloadSep = payloadSep;
        this.endByte = endByte;
        this.holeCharacter = holeCharacter;
    }

    public long sizeInBytes() {
        return this.fst == null ? 0L : this.fst.sizeInBytes();
    }

    private static void copyDestTransitions(State from, State to, List<Transition> transitions) {
        if (to.isAccept()) {
            from.setAccept(true);
        }
        for (Transition t : to.getTransitions()) {
            transitions.add(t);
        }
    }

    private static void replaceSep(Automaton a, boolean preserveSep, int replaceSep) {
        State[] states = a.getNumberedStates();
        for (int stateNumber = states.length - 1; stateNumber >= 0; --stateNumber) {
            State state = states[stateNumber];
            ArrayList<Transition> newTransitions = new ArrayList<Transition>();
            for (Transition t : state.getTransitions()) {
                assert (t.getMin() == t.getMax());
                if (t.getMin() == 31) {
                    if (preserveSep) {
                        newTransitions.add(new Transition(replaceSep, t.getDest()));
                        continue;
                    }
                    XAnalyzingSuggester.copyDestTransitions(state, t.getDest(), newTransitions);
                    a.setDeterministic(false);
                    continue;
                }
                if (t.getMin() == 30) {
                    XAnalyzingSuggester.copyDestTransitions(state, t.getDest(), newTransitions);
                    a.setDeterministic(false);
                    continue;
                }
                newTransitions.add(t);
            }
            state.setTransitions(newTransitions.toArray(new Transition[newTransitions.size()]));
        }
    }

    protected Automaton convertAutomaton(Automaton a) {
        return a;
    }

    public TokenStreamToAutomaton getTokenStreamToAutomaton() {
        TokenStreamToAutomaton tsta = this.preserveSep ? new EscapingTokenStreamToAutomaton((char)this.sepLabel) : new TokenStreamToAutomaton();
        tsta.setPreservePositionIncrements(this.preservePositionIncrements);
        return tsta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(InputIterator iterator) throws IOException {
        File tempSorted;
        File tempInput;
        block23: {
            Sort.ByteSequencesReader reader;
            Sort.ByteSequencesWriter writer;
            block22: {
                String prefix = ((Object)((Object)this)).getClass().getSimpleName();
                File directory = Sort.defaultTempDir();
                tempInput = File.createTempFile(prefix, ".input", directory);
                tempSorted = File.createTempFile(prefix, ".sorted", directory);
                this.hasPayloads = iterator.hasPayloads();
                writer = new Sort.ByteSequencesWriter(tempInput);
                reader = null;
                BytesRef scratch = new BytesRef();
                TokenStreamToAutomaton ts2a = this.getTokenStreamToAutomaton();
                boolean success = false;
                this.count = 0L;
                byte[] buffer = new byte[8];
                try {
                    BytesRef surfaceForm;
                    ByteArrayDataOutput output = new ByteArrayDataOutput(buffer);
                    while ((surfaceForm = iterator.next()) != null) {
                        Set<IntsRef> paths = this.toFiniteStrings(surfaceForm, ts2a);
                        this.maxAnalyzedPathsForOneInput = Math.max(this.maxAnalyzedPathsForOneInput, paths.size());
                        for (IntsRef path : paths) {
                            BytesRef payload;
                            Util.toBytesRef((IntsRef)path, (BytesRef)scratch);
                            if (scratch.length > 32765) {
                                throw new IllegalArgumentException("cannot handle analyzed forms > 32765 in length (got " + scratch.length + ")");
                            }
                            short analyzedLength = (short)scratch.length;
                            int requiredLength = analyzedLength + 4 + surfaceForm.length + 2;
                            if (this.hasPayloads) {
                                if (surfaceForm.length > 32765) {
                                    throw new IllegalArgumentException("cannot handle surface form > 32765 in length (got " + surfaceForm.length + ")");
                                }
                                payload = iterator.payload();
                                requiredLength += payload.length + 2;
                            } else {
                                payload = null;
                            }
                            buffer = ArrayUtil.grow((byte[])buffer, (int)requiredLength);
                            output.reset(buffer);
                            output.writeShort(analyzedLength);
                            output.writeBytes(scratch.bytes, scratch.offset, scratch.length);
                            output.writeInt(XAnalyzingSuggester.encodeWeight(iterator.weight()));
                            if (this.hasPayloads) {
                                for (int i = 0; i < surfaceForm.length; ++i) {
                                    if (surfaceForm.bytes[i] != this.payloadSep) continue;
                                    throw new IllegalArgumentException("surface form cannot contain unit separator character U+001F; this character is reserved");
                                }
                                output.writeShort((short)surfaceForm.length);
                                output.writeBytes(surfaceForm.bytes, surfaceForm.offset, surfaceForm.length);
                                output.writeBytes(payload.bytes, payload.offset, payload.length);
                            } else {
                                output.writeBytes(surfaceForm.bytes, surfaceForm.offset, surfaceForm.length);
                            }
                            assert (output.getPosition() == requiredLength) : output.getPosition() + " vs " + requiredLength;
                            writer.write(buffer, 0, output.getPosition());
                        }
                        ++this.count;
                    }
                    writer.close();
                    new Sort((Comparator)new AnalyzingComparator(this.hasPayloads)).sort(tempInput, tempSorted);
                    tempInput.delete();
                    reader = new Sort.ByteSequencesReader(tempSorted);
                    PairOutputs outputs = new PairOutputs((Outputs)PositiveIntOutputs.getSingleton(), (Outputs)ByteSequenceOutputs.getSingleton());
                    Builder builder = new Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
                    BytesRef previousAnalyzed = null;
                    BytesRef analyzed = new BytesRef();
                    BytesRef surface = new BytesRef();
                    IntsRef scratchInts = new IntsRef();
                    ByteArrayDataInput input = new ByteArrayDataInput();
                    HashSet<BytesRef> seenSurfaceForms = new HashSet<BytesRef>();
                    int dedup = 0;
                    while (reader.read(scratch)) {
                        input.reset(scratch.bytes, scratch.offset, scratch.length);
                        short analyzedLength = input.readShort();
                        analyzed.grow(analyzedLength + 2);
                        input.readBytes(analyzed.bytes, 0, (int)analyzedLength);
                        analyzed.length = analyzedLength;
                        long cost = input.readInt();
                        surface.bytes = scratch.bytes;
                        if (this.hasPayloads) {
                            surface.length = input.readShort();
                            surface.offset = input.getPosition();
                        } else {
                            surface.offset = input.getPosition();
                            surface.length = scratch.length - surface.offset;
                        }
                        if (previousAnalyzed == null) {
                            previousAnalyzed = new BytesRef();
                            previousAnalyzed.copyBytes(analyzed);
                            seenSurfaceForms.add(BytesRef.deepCopyOf((BytesRef)surface));
                        } else if (analyzed.equals(previousAnalyzed)) {
                            if (++dedup >= this.maxSurfaceFormsPerAnalyzedForm || seenSurfaceForms.contains(surface)) continue;
                            seenSurfaceForms.add(BytesRef.deepCopyOf((BytesRef)surface));
                        } else {
                            dedup = 0;
                            previousAnalyzed.copyBytes(analyzed);
                            seenSurfaceForms.clear();
                            seenSurfaceForms.add(BytesRef.deepCopyOf((BytesRef)surface));
                        }
                        analyzed.bytes[analyzed.offset + analyzed.length] = 0;
                        analyzed.bytes[analyzed.offset + analyzed.length + 1] = (byte)dedup;
                        analyzed.length += 2;
                        Util.toIntsRef((BytesRef)analyzed, (IntsRef)scratchInts);
                        if (!this.hasPayloads) {
                            builder.add(scratchInts, (Object)outputs.newPair((Object)cost, (Object)BytesRef.deepCopyOf((BytesRef)surface)));
                            continue;
                        }
                        int payloadOffset = input.getPosition() + surface.length;
                        int payloadLength = scratch.length - payloadOffset;
                        BytesRef br = new BytesRef(surface.length + 1 + payloadLength);
                        System.arraycopy(surface.bytes, surface.offset, br.bytes, 0, surface.length);
                        br.bytes[surface.length] = (byte)this.payloadSep;
                        System.arraycopy(scratch.bytes, payloadOffset, br.bytes, surface.length + 1, payloadLength);
                        br.length = br.bytes.length;
                        builder.add(scratchInts, (Object)outputs.newPair((Object)cost, (Object)br));
                    }
                    this.fst = builder.finish();
                    success = true;
                    if (!success) break block22;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{reader, writer});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader, writer});
                    }
                    tempInput.delete();
                    tempSorted.delete();
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{reader, writer});
                break block23;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader, writer});
        }
        tempInput.delete();
        tempSorted.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean store(OutputStream output) throws IOException {
        OutputStreamDataOutput dataOut;
        block3: {
            boolean bl;
            dataOut = new OutputStreamDataOutput(output);
            try {
                if (this.fst != null) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{output});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{output});
            return bl;
        }
        this.fst.save((DataOutput)dataOut);
        dataOut.writeVInt(this.maxAnalyzedPathsForOneInput);
        dataOut.writeByte((byte)(this.hasPayloads ? 1 : 0));
        IOUtils.close((Closeable[])new Closeable[]{output});
        return true;
    }

    public long getCount() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputStream input) throws IOException {
        InputStreamDataInput dataIn = new InputStreamDataInput(input);
        try {
            this.fst = new FST((DataInput)dataIn, (Outputs)new PairOutputs((Outputs)PositiveIntOutputs.getSingleton(), (Outputs)ByteSequenceOutputs.getSingleton()));
            this.maxAnalyzedPathsForOneInput = dataIn.readVInt();
            this.hasPayloads = dataIn.readByte() == 1;
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{input});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{input});
        return true;
    }

    private Lookup.LookupResult getLookupResult(Long output1, BytesRef output2, CharsRef spare) {
        Lookup.LookupResult result;
        if (this.hasPayloads) {
            int sepIndex = -1;
            for (int i = 0; i < output2.length; ++i) {
                if (output2.bytes[output2.offset + i] != this.payloadSep) continue;
                sepIndex = i;
                break;
            }
            assert (sepIndex != -1);
            spare.grow(sepIndex);
            int payloadLen = output2.length - sepIndex - 1;
            UnicodeUtil.UTF8toUTF16((byte[])output2.bytes, (int)output2.offset, (int)sepIndex, (CharsRef)spare);
            BytesRef payload = new BytesRef(payloadLen);
            System.arraycopy(output2.bytes, sepIndex + 1, payload.bytes, 0, payloadLen);
            payload.length = payloadLen;
            result = new Lookup.LookupResult((CharSequence)spare.toString(), (long)XAnalyzingSuggester.decodeWeight(output1), payload);
        } else {
            spare.grow(output2.length);
            UnicodeUtil.UTF8toUTF16((BytesRef)output2, (CharsRef)spare);
            result = new Lookup.LookupResult((CharSequence)spare.toString(), (long)XAnalyzingSuggester.decodeWeight(output1));
        }
        return result;
    }

    private boolean sameSurfaceForm(BytesRef key, BytesRef output2) {
        if (this.hasPayloads) {
            if (key.length >= output2.length) {
                return false;
            }
            for (int i = 0; i < key.length; ++i) {
                if (key.bytes[key.offset + i] == output2.bytes[output2.offset + i]) continue;
                return false;
            }
            return output2.bytes[output2.offset + key.length] == this.payloadSep;
        }
        return key.bytesEquals(output2);
    }

    public List<Lookup.LookupResult> lookup(CharSequence key, boolean onlyMorePopular, int num) {
        assert (num > 0);
        if (onlyMorePopular) {
            throw new IllegalArgumentException("this suggester only works with onlyMorePopular=false");
        }
        if (this.fst == null) {
            return Collections.emptyList();
        }
        for (int i = 0; i < key.length(); ++i) {
            if (key.charAt(i) == this.holeCharacter) {
                throw new IllegalArgumentException("lookup key cannot contain HOLE character U+001E; this character is reserved");
            }
            if (key.charAt(i) != this.sepLabel) continue;
            throw new IllegalArgumentException("lookup key cannot contain unit separator character U+001F; this character is reserved");
        }
        final BytesRef utf8Key = new BytesRef(key);
        try {
            Util.MinResult[] completions;
            Automaton lookupAutomaton = this.toLookupAutomaton(key);
            CharsRef spare = new CharsRef();
            FST.BytesReader bytesReader = this.fst.getBytesReader();
            FST.Arc scratchArc = new FST.Arc();
            final ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>();
            List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> prefixPaths = FSTUtil.intersectPrefixPaths((Automaton)this.convertAutomaton(lookupAutomaton), this.fst);
            if (this.exactFirst) {
                Util.MinResult[] minResultArray;
                int count = 0;
                for (FSTUtil.Path path : prefixPaths) {
                    if (this.fst.findTargetArc(this.endByte, path.fstNode, scratchArc, bytesReader) == null) continue;
                    ++count;
                }
                Util.TopNSearcher searcher = new Util.TopNSearcher(this.fst, count * this.maxSurfaceFormsPerAnalyzedForm, count * this.maxSurfaceFormsPerAnalyzedForm, weightComparator);
                for (FSTUtil.Path path : prefixPaths) {
                    if (this.fst.findTargetArc(this.endByte, path.fstNode, scratchArc, bytesReader) == null) continue;
                    searcher.addStartPaths(scratchArc, this.fst.outputs.add(path.output, scratchArc.output), false, path.input);
                }
                for (Util.MinResult completion : minResultArray = searcher.search()) {
                    BytesRef output2 = (BytesRef)((PairOutputs.Pair)completion.output).output2;
                    if (!this.sameSurfaceForm(utf8Key, output2)) continue;
                    results.add(this.getLookupResult((Long)((PairOutputs.Pair)completion.output).output1, output2, spare));
                    break;
                }
                if (results.size() == num) {
                    return results;
                }
            }
            Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>> searcher = new Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>>(this.fst, num - results.size(), num * this.maxAnalyzedPathsForOneInput, weightComparator){
                private final Set<BytesRef> seen;
                {
                    super(x0, x1, x2, x3);
                    this.seen = new HashSet<BytesRef>();
                }

                protected boolean acceptResult(IntsRef input, PairOutputs.Pair<Long, BytesRef> output) {
                    if (this.seen.contains(output.output2)) {
                        return false;
                    }
                    this.seen.add((BytesRef)output.output2);
                    if (!XAnalyzingSuggester.this.exactFirst) {
                        return true;
                    }
                    if (XAnalyzingSuggester.this.sameSurfaceForm(utf8Key, (BytesRef)output.output2)) {
                        assert (results.size() == 1);
                        return false;
                    }
                    return true;
                }
            };
            prefixPaths = this.getFullPrefixPaths(prefixPaths, lookupAutomaton, this.fst);
            for (FSTUtil.Path path : prefixPaths) {
                searcher.addStartPaths(path.fstNode, path.output, true, path.input);
            }
            for (Util.MinResult completion : completions = searcher.search()) {
                Lookup.LookupResult result = this.getLookupResult((Long)((PairOutputs.Pair)completion.output).output1, (BytesRef)((PairOutputs.Pair)completion.output).output2, spare);
                results.add(result);
                if (results.size() == num) break;
            }
            return results;
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
    }

    public boolean store(DataOutput output) throws IOException {
        output.writeVLong(this.count);
        if (this.fst == null) {
            return false;
        }
        this.fst.save(output);
        output.writeVInt(this.maxAnalyzedPathsForOneInput);
        output.writeByte((byte)(this.hasPayloads ? 1 : 0));
        return true;
    }

    public boolean load(DataInput input) throws IOException {
        this.count = input.readVLong();
        this.fst = new FST(input, (Outputs)new PairOutputs((Outputs)PositiveIntOutputs.getSingleton(), (Outputs)ByteSequenceOutputs.getSingleton()));
        this.maxAnalyzedPathsForOneInput = input.readVInt();
        this.hasPayloads = input.readByte() == 1;
        return true;
    }

    protected List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> getFullPrefixPaths(List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> prefixPaths, Automaton lookupAutomaton, FST<PairOutputs.Pair<Long, BytesRef>> fst) throws IOException {
        return prefixPaths;
    }

    public final Set<IntsRef> toFiniteStrings(BytesRef surfaceForm, TokenStreamToAutomaton ts2a) throws IOException {
        TokenStream ts = this.indexAnalyzer.tokenStream("", surfaceForm.utf8ToString());
        return this.toFiniteStrings(ts2a, ts);
    }

    public final Set<IntsRef> toFiniteStrings(TokenStreamToAutomaton ts2a, TokenStream ts) throws IOException {
        Automaton automaton = ts2a.toAutomaton(ts);
        ts.close();
        XAnalyzingSuggester.replaceSep(automaton, this.preserveSep, this.sepLabel);
        assert (SpecialOperations.isFinite((Automaton)automaton));
        return SpecialOperations.getFiniteStrings((Automaton)automaton, (int)this.maxGraphExpansions);
    }

    final Automaton toLookupAutomaton(CharSequence key) throws IOException {
        TokenStream ts = this.queryAnalyzer.tokenStream("", ((Object)key).toString());
        Automaton automaton = this.getTokenStreamToAutomaton().toAutomaton(ts);
        ts.close();
        XAnalyzingSuggester.replaceSep(automaton, this.preserveSep, this.sepLabel);
        BasicOperations.determinize((Automaton)automaton);
        return automaton;
    }

    public Object get(CharSequence key) {
        throw new UnsupportedOperationException();
    }

    public static int decodeWeight(long encoded) {
        return (int)(Integer.MAX_VALUE - encoded);
    }

    public static int encodeWeight(long value) {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("cannot encode value: " + value);
        }
        return Integer.MAX_VALUE - (int)value;
    }

    public static class XBuilder {
        private Builder<PairOutputs.Pair<Long, BytesRef>> builder;
        private int maxSurfaceFormsPerAnalyzedForm;
        private IntsRef scratchInts = new IntsRef();
        private final PairOutputs<Long, BytesRef> outputs;
        private boolean hasPayloads;
        private BytesRef analyzed = new BytesRef();
        private final SurfaceFormAndPayload[] surfaceFormsAndPayload;
        private int count;
        private ObjectIntOpenHashMap<BytesRef> seenSurfaceForms = HppcMaps.Object.Integer.ensureNoNullKeys(256, 0.75f);
        private int payloadSep;

        public XBuilder(int maxSurfaceFormsPerAnalyzedForm, boolean hasPayloads, int payloadSep) {
            this.payloadSep = payloadSep;
            this.outputs = new PairOutputs((Outputs)PositiveIntOutputs.getSingleton(), (Outputs)ByteSequenceOutputs.getSingleton());
            this.builder = new Builder(FST.INPUT_TYPE.BYTE1, this.outputs);
            this.maxSurfaceFormsPerAnalyzedForm = maxSurfaceFormsPerAnalyzedForm;
            this.hasPayloads = hasPayloads;
            this.surfaceFormsAndPayload = new SurfaceFormAndPayload[maxSurfaceFormsPerAnalyzedForm];
        }

        public void startTerm(BytesRef analyzed) {
            this.analyzed.copyBytes(analyzed);
            this.analyzed.grow(analyzed.length + 2);
        }

        public void addSurface(BytesRef surface, BytesRef payload, long cost) throws IOException {
            BytesRef payloadRef;
            BytesRef surfaceCopy;
            long encodedWeight;
            int surfaceIndex = -1;
            long l = encodedWeight = cost == -1L ? cost : (long)XAnalyzingSuggester.encodeWeight(cost);
            if (this.count >= this.maxSurfaceFormsPerAnalyzedForm) {
                return;
            }
            if (this.count > 0 && this.seenSurfaceForms.containsKey(surface)) {
                surfaceIndex = this.seenSurfaceForms.lget();
                SurfaceFormAndPayload surfaceFormAndPayload = this.surfaceFormsAndPayload[surfaceIndex];
                if (encodedWeight >= surfaceFormAndPayload.weight) {
                    return;
                }
                surfaceCopy = BytesRef.deepCopyOf((BytesRef)surface);
            } else {
                surfaceIndex = this.count++;
                surfaceCopy = BytesRef.deepCopyOf((BytesRef)surface);
                this.seenSurfaceForms.put(surfaceCopy, surfaceIndex);
            }
            if (!this.hasPayloads) {
                payloadRef = surfaceCopy;
            } else {
                int len = surface.length + 1 + payload.length;
                BytesRef br = new BytesRef(len);
                System.arraycopy(surface.bytes, surface.offset, br.bytes, 0, surface.length);
                br.bytes[surface.length] = (byte)this.payloadSep;
                System.arraycopy(payload.bytes, payload.offset, br.bytes, surface.length + 1, payload.length);
                br.length = len;
                payloadRef = br;
            }
            if (this.surfaceFormsAndPayload[surfaceIndex] == null) {
                this.surfaceFormsAndPayload[surfaceIndex] = new SurfaceFormAndPayload(payloadRef, encodedWeight);
            } else {
                this.surfaceFormsAndPayload[surfaceIndex].payload = payloadRef;
                this.surfaceFormsAndPayload[surfaceIndex].weight = encodedWeight;
            }
        }

        public void finishTerm(long defaultWeight) throws IOException {
            ArrayUtil.timSort((Comparable[])this.surfaceFormsAndPayload, (int)0, (int)this.count);
            int deduplicator = 0;
            this.analyzed.bytes[this.analyzed.offset + this.analyzed.length] = 0;
            this.analyzed.length += 2;
            for (int i = 0; i < this.count; ++i) {
                this.analyzed.bytes[this.analyzed.offset + this.analyzed.length - 1] = (byte)deduplicator++;
                Util.toIntsRef((BytesRef)this.analyzed, (IntsRef)this.scratchInts);
                SurfaceFormAndPayload candiate = this.surfaceFormsAndPayload[i];
                long cost = candiate.weight == -1L ? (long)XAnalyzingSuggester.encodeWeight(Math.min(Integer.MAX_VALUE, defaultWeight)) : candiate.weight;
                this.builder.add(this.scratchInts, (Object)this.outputs.newPair((Object)cost, (Object)candiate.payload));
            }
            this.seenSurfaceForms.clear();
            this.count = 0;
        }

        public FST<PairOutputs.Pair<Long, BytesRef>> build() throws IOException {
            return this.builder.finish();
        }

        public boolean hasPayloads() {
            return this.hasPayloads;
        }

        public int maxSurfaceFormsPerAnalyzedForm() {
            return this.maxSurfaceFormsPerAnalyzedForm;
        }

        private static final class SurfaceFormAndPayload
        implements Comparable<SurfaceFormAndPayload> {
            BytesRef payload;
            long weight;

            public SurfaceFormAndPayload(BytesRef payload, long cost) {
                this.payload = payload;
                this.weight = cost;
            }

            @Override
            public int compareTo(SurfaceFormAndPayload o) {
                int res = SurfaceFormAndPayload.compare(this.weight, o.weight);
                if (res == 0) {
                    return this.payload.compareTo(o.payload);
                }
                return res;
            }

            public static int compare(long x, long y) {
                return x < y ? -1 : (x == y ? 0 : 1);
            }
        }
    }

    private static class AnalyzingComparator
    implements Comparator<BytesRef> {
        private final boolean hasPayloads;
        private final ByteArrayDataInput readerA = new ByteArrayDataInput();
        private final ByteArrayDataInput readerB = new ByteArrayDataInput();
        private final BytesRef scratchA = new BytesRef();
        private final BytesRef scratchB = new BytesRef();

        public AnalyzingComparator(boolean hasPayloads) {
            this.hasPayloads = hasPayloads;
        }

        @Override
        public int compare(BytesRef a, BytesRef b) {
            this.readerA.reset(a.bytes, a.offset, a.length);
            this.scratchA.length = this.readerA.readShort();
            this.scratchA.bytes = a.bytes;
            this.scratchA.offset = this.readerA.getPosition();
            this.readerB.reset(b.bytes, b.offset, b.length);
            this.scratchB.bytes = b.bytes;
            this.scratchB.length = this.readerB.readShort();
            this.scratchB.offset = this.readerB.getPosition();
            int cmp = this.scratchA.compareTo(this.scratchB);
            if (cmp != 0) {
                return cmp;
            }
            this.readerA.skipBytes(this.scratchA.length);
            this.readerB.skipBytes(this.scratchB.length);
            long aCost = this.readerA.readInt();
            long bCost = this.readerB.readInt();
            if (aCost < bCost) {
                return -1;
            }
            if (aCost > bCost) {
                return 1;
            }
            if (this.hasPayloads) {
                this.scratchA.length = this.readerA.readShort();
                this.scratchA.offset = this.readerA.getPosition();
                this.scratchB.length = this.readerB.readShort();
                this.scratchB.offset = this.readerB.getPosition();
            } else {
                this.scratchA.offset = this.readerA.getPosition();
                this.scratchA.length = a.length - this.scratchA.offset;
                this.scratchB.offset = this.readerB.getPosition();
                this.scratchB.length = b.length - this.scratchB.offset;
            }
            return this.scratchA.compareTo(this.scratchB);
        }
    }

    private static final class EscapingTokenStreamToAutomaton
    extends TokenStreamToAutomaton {
        final BytesRef spare = new BytesRef();
        private char sepLabel;

        public EscapingTokenStreamToAutomaton(char sepLabel) {
            this.sepLabel = sepLabel;
        }

        protected BytesRef changeToken(BytesRef in) {
            int upto = 0;
            for (int i = 0; i < in.length; ++i) {
                byte b = in.bytes[in.offset + i];
                if (b == (byte)this.sepLabel) {
                    if (this.spare.bytes.length == upto) {
                        this.spare.grow(upto + 2);
                    }
                    this.spare.bytes[upto++] = (byte)this.sepLabel;
                    this.spare.bytes[upto++] = b;
                    continue;
                }
                if (this.spare.bytes.length == upto) {
                    this.spare.grow(upto + 1);
                }
                this.spare.bytes[upto++] = b;
            }
            this.spare.offset = 0;
            this.spare.length = upto;
            return this.spare;
        }
    }
}

