/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.web.document;

import fr.toutatice.ecm.platform.web.document.ToutaticeOrderableDocumentActions;
import java.text.Collator;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Sorter;

@Name(value="orderableDocumentActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=56)
public class AcrennesOrderableDocumentActionsBean
extends ToutaticeOrderableDocumentActions {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AcrennesOrderableDocumentActionsBean.class);

    public void orderAlphabetically() {
        DocumentModel container = this.navigationContext.getCurrentDocument();
        if (container == null) {
            return;
        }
        try {
            DocumentModelList childrenSorted = this.getChildrenFor(container.getId());
            Collections.sort(childrenSorted, new AlphabeticallSorter());
            if (1 < childrenSorted.size()) {
                DocumentModel latestDoc = (DocumentModel)childrenSorted.get(childrenSorted.size() - 1);
                this.documentManager.orderBefore(container.getRef(), latestDoc.getName(), null);
                for (int index = childrenSorted.size() - 2; index >= 0; --index) {
                    DocumentModel child = (DocumentModel)childrenSorted.get(index);
                    DocumentModel follower = (DocumentModel)childrenSorted.get(index + 1);
                    this.documentManager.orderBefore(container.getRef(), child.getName(), follower.getName());
                }
                if (this.documentActions.belongToPublishSpace()) {
                    for (DocumentModel child : childrenSorted) {
                        this.moveDocumentProxy(container, child);
                    }
                }
                this.documentManager.save();
                this.notifyChildrenChanged(container);
            }
            this.addFacesMessage("label.acaren.action.ordering.done.successfully");
        }
        catch (Exception e) {
            log.debug((Object)("Failed to order as alphabetical order the folder '" + container.getName() + "', error: " + e.getMessage()));
        }
    }

    private class AlphabeticallSorter
    implements Sorter {
        Pattern pattern;
        Pattern patternExtractTail;
        Collator collator = Collator.getInstance();

        public AlphabeticallSorter() {
            this.collator.setDecomposition(1);
            this.collator.setStrength(2);
            this.pattern = Pattern.compile("^\\s*\\d+.*");
            this.patternExtractTail = Pattern.compile("^\\s*\\d+");
        }

        public int compare(DocumentModel d1, DocumentModel d2) {
            try {
                String o1 = d1.getTitle();
                String o2 = d2.getTitle();
                int oi1 = this.extractIndexPrefix(o1);
                int oi2 = this.extractIndexPrefix(o2);
                if (oi1 != Integer.MAX_VALUE && oi2 != Integer.MAX_VALUE) {
                    return oi1 < oi2 ? -1 : 1;
                }
                return this.collator.compare(o1, o2);
            }
            catch (ClientException e) {
                log.error((Object)("AlphabeticallSorter: failed to get the title of the document id '" + d1.getId() + ", '" + d2.getId() + "'"));
                return 0;
            }
        }

        private int extractIndexPrefix(String stg) {
            int index = Integer.MAX_VALUE;
            if (this.pattern.matcher(stg).matches()) {
                String tail = stg.replaceFirst(this.patternExtractTail.pattern(), "");
                tail = Pattern.quote(tail);
                String indexStg = stg.replaceFirst(tail, "").trim();
                index = Integer.valueOf(indexStg);
            }
            return index;
        }
    }
}

