/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.web.userservices;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.invalidations.AutomaticDocumentBasedInvalidation;

@Name(value="acrennesCurrentUserBean")
@Scope(value=ScopeType.CONVERSATION)
@AutomaticDocumentBasedInvalidation
public class AcrennesCurrentUserBean
implements Serializable {
    private static final long serialVersionUID = -8847660557550172111L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    NavigationContext navigationContext;
    private transient SecurityService securityService;

    private SecurityService getSecurityService() {
        if (this.securityService == null) {
            this.securityService = NXCore.getSecurityService();
        }
        return this.securityService;
    }

    public boolean checkHasReadOnlyPermission() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        boolean hasRead = this.documentManager.hasPermission(currentDoc.getRef(), "Read");
        boolean hasWrite = this.documentManager.hasPermission(currentDoc.getRef(), "Write");
        return hasRead && !hasWrite;
    }

    public boolean checkHasPermission(String permission) throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        boolean hasPerm = this.documentManager.hasPermission(currentDoc.getRef(), permission);
        return hasPerm;
    }

    public boolean checkExclusivePermission(String permission) throws ClientException {
        String[] resolvedPermissions;
        boolean status = false;
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        for (String permItem : resolvedPermissions = this.getSecurityService().getPermissionsToCheck(permission)) {
            if (permission.equals(permItem)) {
                status = this.documentManager.hasPermission(currentDoc.getRef(), permItem);
                continue;
            }
            if (!this.documentManager.hasPermission(currentDoc.getRef(), permItem)) continue;
            status = false;
            break;
        }
        return status;
    }
}

