/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeImageCollectionHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;

@Operation(id="ImagesBlobHolder.Attach", category="Files", label="Attach images to the currentDocument.", description="Attach the input image(s) to the current document using the BlobHolder abstraction")
public class ImagesBlobHolderAttach {
    public static final String ID = "ImagesBlobHolder.Attach";
    private static final String SCHEMA_IMAGES = "toutatice";
    private static final String NXPATH_IMAGES = "ttc:images";
    @Context
    protected CoreSession session;
    @Context
    protected AutomationService as;
    @Context
    protected OperationContext context;

    protected DocumentModel getCurrentDocument() throws Exception {
        String cdRef = (String)this.context.get((Object)"currentDocument");
        return (DocumentModel)this.as.getAdaptedValue(this.context, (Object)cdRef, DocumentModel.class);
    }

    @OperationMethod
    public DocumentModel run(Blob blob) throws Exception {
        DocumentModel currentDocument = this.getCurrentDocument();
        BlobHolder bh = (BlobHolder)currentDocument.getAdapter(BlobHolder.class);
        if (bh == null) {
            return currentDocument;
        }
        bh.setBlob(blob);
        currentDocument = this.session.saveDocument(currentDocument);
        this.context.put("currentDocument", (Object)currentDocument);
        return currentDocument;
    }

    @OperationMethod
    public DocumentModel run(BlobList blobs) throws Exception {
        DocumentModel currentDocument = null;
        currentDocument = this.getCurrentDocument();
        if (blobs.size() > 0 && currentDocument.hasSchema(SCHEMA_IMAGES)) {
            ArrayList existingBlobs = (ArrayList)currentDocument.getPropertyValue(NXPATH_IMAGES);
            if (existingBlobs == null) {
                existingBlobs = new ArrayList();
            }
            for (Blob blob : blobs) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("file", blob);
                map.put("filename", blob.getFilename());
                ToutaticeImageCollectionHelper.instance().add(existingBlobs, map);
            }
            currentDocument.setPropertyValue(NXPATH_IMAGES, (Serializable)existingBlobs);
            currentDocument = this.session.saveDocument(currentDocument);
        }
        return currentDocument;
    }
}

