/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;

@Deprecated
@Operation(id="Document.SetACEList", category="Document", label="Set ACL for a list of principals", description="Set Acces Control Entry on the input document(s) for a list of principals. Returns the document(s).")
public class SetDocumentACEList {
    public static final String ID = "Document.SetACEList";
    @Context
    protected CoreSession session;
    @Param(name="users")
    protected StringList users;
    @Param(name="permission")
    String permission;
    @Param(name="acl", required=false, values={"local"})
    String aclName = "local";
    @Param(name="grant", required=false, values={"true"})
    boolean grant = true;
    @Param(name="overwrite", required=false, values={"true"})
    boolean overwrite = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        this.setACE(doc.getRef());
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef doc) throws Exception {
        this.setACE(doc);
        return this.session.getDocument(doc);
    }

    protected void setACE(DocumentRef ref) throws ClientException {
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = new ACLImpl(this.aclName);
        acp.addACL((ACL)acl);
        for (String user : this.users) {
            ACE ace = new ACE(user, this.permission, this.grant);
            acl.add((Object)ace);
        }
        this.session.setACP(ref, (ACP)acp, this.overwrite);
    }
}

