/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.Type;

@Operation(id="Document.SetExtendedDocumentProperty", category="Document", label="Update the doc property (extended implementation)", description="Set a single property value on the input document. The property is specified using its xpath. The document is automatically saved if 'save' parameter is true. If you unset the 'save' you need to save it later using Save Document operation. Return the modified document.")
public class SetExtendedDocumentProperty {
    public static final String ID = "Document.SetExtendedDocumentProperty";
    private static final List<Class<?>> FILTERED_SERVICES_LIST = new ArrayList<Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(EventService.class);
            this.add(VersioningService.class);
        }
    };
    @Context
    protected CoreSession session;
    @Param(name="xpath")
    protected String xpath;
    @Param(name="value")
    protected Serializable value;
    @Param(name="save", required=false, values={"false,true"})
    protected boolean save = true;
    @Param(name="Unrestricted", required=false, values={"false,true"})
    protected boolean unrestricted = false;
    @Param(name="silent mode", required=false, values={"false,true"})
    protected boolean silent = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        Property p = doc.getProperty(this.xpath);
        Type type = p.getField().getType();
        if (!type.isSimpleType()) {
            throw new OperationException("Only scalar types can be set using update operation");
        }
        if (this.value.getClass() == String.class) {
            p.setValue(((SimpleType)type).getPrimitiveType().decode((String)((Object)this.value)));
        } else {
            p.setValue((Object)this.value);
        }
        if (this.save) {
            if (this.silent) {
                InnerSilentModeSaver runner = new InnerSilentModeSaver(this.session, doc);
                runner.silentRun(this.unrestricted, FILTERED_SERVICES_LIST);
                doc = runner.getDoc();
            } else {
                doc = this.session.saveDocument(doc);
            }
        }
        return doc;
    }

    private class InnerSilentModeSaver
    extends ToutaticeSilentProcessRunnerHelper {
        DocumentModel doc;

        public InnerSilentModeSaver(CoreSession session, DocumentModel doc) {
            super(session);
            this.doc = doc;
        }

        public void run() throws ClientException {
            this.doc = this.session.saveDocument(this.doc);
        }

        public DocumentModel getDoc() {
            return this.doc;
        }
    }
}

