/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.gwt.client.view;

import com.google.gwt.i18n.client.Dictionary;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseListenerAdapter;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.controller.TilingController;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingInfo;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingInfoCallback;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingModel;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.view.TilingPreviewControllerPanel;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.view.TilingPreviewPanel;

public class TilingMainPanel
extends Composite {
    private static final int TILE_WIDTH = 256;
    private static final int TILE_HEIGHT = 256;
    private static final int PREVIEW_PANEL_BORDER_SIZE = 3;
    private static String HIDE_THUMBNAIL_IMAGE;
    private static String SHOW_THUMBNAIL_IMAGE;
    private String repoId;
    private String docId;
    private String contextPath;

    public TilingMainPanel() {
        Dictionary dictionary = Dictionary.getDictionary((String)"serverSetting");
        this.repoId = dictionary.get("repoId");
        this.docId = dictionary.get("docId");
        this.contextPath = dictionary.get("contextPath");
        HIDE_THUMBNAIL_IMAGE = this.contextPath + "/img/hide_thumbnail.png";
        SHOW_THUMBNAIL_IMAGE = this.contextPath + "/img/show_thumbnail.png";
        this.loadControllerPanelTilingInfo();
    }

    private void loadControllerPanelTilingInfo() {
        final TilingInfo tilingInfo = new TilingInfo(this.repoId, this.docId, this.contextPath, 64, 64, 3);
        tilingInfo.updateTilingInfo(new TilingInfoCallback(){

            @Override
            public void tilingInfoUpdated() {
                TilingMainPanel.this.loadModelTilingInfo(tilingInfo);
            }
        });
    }

    private void loadModelTilingInfo(final TilingInfo tilingInfo) {
        int maxTilesH;
        int maxTilesW = (Window.getClientWidth() - 6) / 256 + 1;
        int maxTiles = maxTilesW > (maxTilesH = (Window.getClientHeight() - 6) / 256 + 1) ? maxTilesW : maxTilesH;
        final TilingInfo currentTilingInfo = new TilingInfo(this.repoId, this.docId, this.contextPath, 256, 256, ++maxTiles);
        currentTilingInfo.updateTilingInfo(new TilingInfoCallback(){

            @Override
            public void tilingInfoUpdated() {
                TilingMainPanel.this.finishLoading(tilingInfo, currentTilingInfo);
            }
        });
    }

    private void finishLoading(TilingInfo sourceTilingInfo, TilingInfo currentTilingInfo) {
        int width = Window.getClientWidth();
        int height = Window.getClientHeight();
        TilingModel model = new TilingModel(currentTilingInfo, width, height, currentTilingInfo.getZoom());
        TilingController controller = new TilingController(sourceTilingInfo, model);
        AbsolutePanel rootPanel = new AbsolutePanel();
        TilingPreviewPanel previewPanel = new TilingPreviewPanel(controller, model);
        rootPanel.add((Widget)previewPanel);
        TilingPreviewControllerPanel controllerPanel = new TilingPreviewControllerPanel(sourceTilingInfo, model);
        controllerPanel.addStyleName("thumbnail-panel");
        int controllerPanelWidth = (int)Math.round((double)sourceTilingInfo.getOriginalImageWidth() * sourceTilingInfo.getZoom());
        int controllerPanelHeight = (int)Math.round((double)sourceTilingInfo.getOriginalImageHeight() * sourceTilingInfo.getZoom());
        rootPanel.add((Widget)controllerPanel, width - controllerPanelWidth - 3, height - controllerPanelHeight - 3);
        ThumbnailButton thumbnailButton = new ThumbnailButton(controllerPanel);
        rootPanel.add((Widget)thumbnailButton, width - thumbnailButton.getWidth(), height - thumbnailButton.getHeight());
        this.initWidget((Widget)rootPanel);
        rootPanel.getElement().getStyle().setProperty("position", "absolute");
        RootPanel.get((String)"display").add((Widget)this);
        model.notifyListeners();
    }

    private static class ThumbnailButton
    extends Image {
        private static int THUMBNAIL_BUTTON_SIZE = 17;
        private boolean showThumbnail = true;

        public ThumbnailButton(final TilingPreviewControllerPanel previewControllerPanel) {
            super(HIDE_THUMBNAIL_IMAGE);
            this.addMouseListener((MouseListener)new MouseListenerAdapter(){

                public void onMouseDown(Widget sender, int x, int y) {
                    Event currentEvent = Event.getCurrentEvent();
                    DOM.eventPreventDefault((Event)currentEvent);
                    currentEvent.cancelBubble(true);
                }
            });
            final ThumbnailButton thumbnailButton = this;
            this.addClickListener(new ClickListener(){

                public void onClick(Widget arg0) {
                    ThumbnailButton.this.showThumbnail = !ThumbnailButton.this.showThumbnail;
                    previewControllerPanel.setVisible(ThumbnailButton.this.showThumbnail);
                    thumbnailButton.setUrl(ThumbnailButton.this.showThumbnail ? HIDE_THUMBNAIL_IMAGE : SHOW_THUMBNAIL_IMAGE);
                }
            });
        }

        public int getWidth() {
            return THUMBNAIL_BUTTON_SIZE;
        }

        public int getHeight() {
            return THUMBNAIL_BUTTON_SIZE;
        }
    }
}

