/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.document;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeNotifyEventHelper;
import fr.toutatice.ecm.platform.web.context.ToutaticeNavigationContext;
import fr.toutatice.ecm.platform.web.publication.validation.ToutaticeRemotePublishActionsBean;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.opentoutatice.ecm.attached.images.bean.OttcDocumentActionsBean;

@Name(value="documentActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=51)
public class ToutaticeRPDocumentActionsBean
extends OttcDocumentActionsBean {
    private static final long serialVersionUID = 8652740421940377204L;
    private static final Log log = LogFactory.getLog(ToutaticeRPDocumentActionsBean.class);
    @In(create=true)
    protected transient ToutaticeRemotePublishActionsBean publishActions;

    public boolean isSeeLatestValidDocumentVersionActionAuthorized() {
        boolean status = false;
        DocumentModel currentDoc = null;
        try {
            currentDoc = this.navigationContext.getCurrentDocument();
            DocumentModel validDocument = ToutaticeDocumentHelper.getLatestDocumentVersion((DocumentModel)currentDoc, (CoreSession)this.documentManager);
            if (null != validDocument) {
                status = !currentDoc.getVersionLabel().equals(validDocument.getVersionLabel());
            }
        }
        catch (Exception e) {
            String docName = null != currentDoc ? currentDoc.getName() : "unknown";
            log.debug((Object)("Failed to get the latest valid version of document '" + docName + "', error: " + e.getMessage()));
        }
        return status;
    }

    public String viewArchivedVersion() throws ClientException {
        return this.viewArchivedVersion(this.navigationContext.getCurrentDocument());
    }

    public String viewArchivedVersion(DocumentModel document) throws ClientException {
        String output = "";
        try {
            DocumentModel archivedDocument = ToutaticeDocumentHelper.getLatestDocumentVersion((DocumentModel)document, (CoreSession)this.documentManager);
            if (null != archivedDocument) {
                output = this.navigationContext.navigateToDocument(document, ToutaticeDocumentHelper.getVersionModel((DocumentModel)archivedDocument));
            }
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
        return output;
    }

    public boolean isRemoteProxy() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return currentDocument.isProxy() && (!StringUtils.endsWith((String)currentDocument.getName(), (String)".proxy") || StringUtils.endsWith((String)currentDocument.getName(), (String)".remote.proxy"));
    }

    public void unPublishDocumentSelection() throws ClientException {
        List currentDocumentSelection = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (null != currentDocumentSelection && !currentDocumentSelection.isEmpty()) {
            DocumentModel currentFolder = this.navigationContext.getCurrentDocument();
            try {
                for (DocumentModel document : currentDocumentSelection) {
                    DocumentModelList proxies = this.documentManager.getProxies(document.getRef(), currentFolder.getRef());
                    this.publishActions.unPublish((DocumentModel)proxies.get(0));
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to set offline the selection from the document: '" + currentFolder.getTitle() + "', error: " + e.getMessage()));
            }
            ToutaticeNotifyEventHelper.notifyAuditEvent((CoreSession)this.documentManager, (String)"UnpublishSelectionCompleted", (DocumentModel)currentFolder, null);
            this.documentsListsManager.resetWorkingList("CURRENT_SELECTION");
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentFolder});
        }
    }

    public String getPublicationAreaNameOfSection(DocumentModel section) {
        String areaName = this.getPublicationAreaName(section);
        if ("inconnu".equals(areaName)) {
            DocumentModel sectionRoot = ((ToutaticeNavigationContext)this.navigationContext).getSectionPublicationArea(section);
            if (sectionRoot != null) {
                try {
                    areaName = sectionRoot.getTitle();
                }
                catch (ClientException e) {
                    log.error((Object)("Failed to get the domain title, error: " + e.getMessage()));
                    areaName = "inconnu";
                }
            } else {
                DocumentModel domain = ((ToutaticeNavigationContext)this.navigationContext).getDocumentDomain(section);
                if (domain != null) {
                    try {
                        areaName = domain.getTitle();
                    }
                    catch (ClientException e) {
                        log.error((Object)("Failed to get the domain title, error: " + e.getMessage()));
                        areaName = "inconnu";
                    }
                }
            }
        }
        return areaName;
    }
}

