/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.ValueEnforcer;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class NonBlockingStringReader
extends Reader {
    private String m_sStr;
    private final int m_nLength;
    private int m_nNext = 0;
    private int m_nMark = 0;

    public NonBlockingStringReader(@Nonnull char[] cArray) {
        this(new String(cArray));
    }

    public NonBlockingStringReader(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this(new String(cArray, n, n2));
    }

    public NonBlockingStringReader(@Nonnull String string) {
        this.m_sStr = ValueEnforcer.notNull(string, "String");
        this.m_nLength = string.length();
    }

    private void _ensureOpen() throws IOException {
        if (this.m_sStr == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    @CheckForSigned
    public int read() throws IOException {
        this._ensureOpen();
        if (this.m_nNext >= this.m_nLength) {
            return -1;
        }
        return this.m_sStr.charAt(this.m_nNext++);
    }

    @Override
    @CheckForSigned
    public int read(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        this._ensureOpen();
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        if (n2 == 0) {
            return 0;
        }
        if (this.m_nNext >= this.m_nLength) {
            return -1;
        }
        int n3 = Math.min(this.m_nLength - this.m_nNext, n2);
        this.m_sStr.getChars(this.m_nNext, this.m_nNext + n3, cArray, n);
        this.m_nNext += n3;
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        this._ensureOpen();
        if (this.m_nNext >= this.m_nLength) {
            return 0L;
        }
        long l2 = Math.min((long)(this.m_nLength - this.m_nNext), l);
        l2 = Math.max((long)(-this.m_nNext), l2);
        this.m_nNext = (int)((long)this.m_nNext + l2);
        return l2;
    }

    @Override
    public boolean ready() throws IOException {
        this._ensureOpen();
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) throws IOException {
        ValueEnforcer.isGE0(n, "ReadAheadLimit");
        this._ensureOpen();
        this.m_nMark = this.m_nNext;
    }

    @Override
    public void reset() throws IOException {
        this._ensureOpen();
        this.m_nNext = this.m_nMark;
    }

    @Override
    public void close() {
        this.m_sStr = null;
    }
}

