/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mutable;

import com.phloc.commons.compare.CompareUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mutable.IMutableInteger;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableByte
extends Number
implements IMutableInteger<MutableByte> {
    public static final byte DEFAULT_VALUE = 0;
    private byte m_nValue;

    public MutableByte() {
        this(0);
    }

    public MutableByte(int n) {
        this((byte)n);
    }

    public MutableByte(@Nonnull Byte by) {
        this((byte)by);
    }

    public MutableByte(byte by) {
        this.m_nValue = by;
    }

    @Override
    public byte byteValue() {
        return this.m_nValue;
    }

    @Nonnull
    public Byte getAsByte() {
        return this.m_nValue;
    }

    @Override
    public float floatValue() {
        return this.m_nValue;
    }

    @Override
    public double doubleValue() {
        return this.m_nValue;
    }

    @Override
    public int intValue() {
        return this.m_nValue;
    }

    @Override
    public long longValue() {
        return this.m_nValue;
    }

    public int inc() {
        return this.inc(1);
    }

    public int inc(int n) {
        this.m_nValue = (byte)(this.m_nValue + n);
        return this.m_nValue;
    }

    public int dec() {
        return this.inc(-1);
    }

    public int dec(int n) {
        return this.inc(-n);
    }

    @Nonnull
    public EChange set(int n) {
        return this.set((byte)n);
    }

    @Nonnull
    public EChange set(byte by) {
        if (this.m_nValue == by) {
            return EChange.UNCHANGED;
        }
        this.m_nValue = by;
        return EChange.CHANGED;
    }

    @Override
    public boolean is0() {
        return this.m_nValue == 0;
    }

    @Override
    public boolean isNot0() {
        return this.m_nValue != 0;
    }

    @Override
    public boolean isSmaller0() {
        return this.m_nValue < 0;
    }

    @Override
    public boolean isSmallerOrEqual0() {
        return this.m_nValue <= 0;
    }

    @Override
    public boolean isGreater0() {
        return this.m_nValue > 0;
    }

    @Override
    public boolean isGreaterOrEqual0() {
        return this.m_nValue >= 0;
    }

    @Override
    public boolean isEven() {
        return this.m_nValue % 2 == 0;
    }

    @Override
    public boolean isOdd() {
        return this.m_nValue % 2 != 0;
    }

    @Override
    public int compareTo(@Nonnull MutableByte mutableByte) {
        return CompareUtils.compare(this.m_nValue, mutableByte.m_nValue);
    }

    @Override
    @Nonnull
    public MutableByte getClone() {
        return new MutableByte(this.m_nValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MutableByte)) {
            return false;
        }
        MutableByte mutableByte = (MutableByte)object;
        return this.m_nValue == mutableByte.m_nValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_nValue).toString();
    }
}

